/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.logging.LogLevel;

public class DeferredLog
implements Log {
    private List<Line> lines = new ArrayList<Line>();

    public boolean isTraceEnabled() {
        return true;
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isFatalEnabled() {
        return true;
    }

    public void trace(Object message) {
        this.log(LogLevel.TRACE, message, null);
    }

    public void trace(Object message, Throwable t) {
        this.log(LogLevel.TRACE, message, t);
    }

    public void debug(Object message) {
        this.log(LogLevel.DEBUG, message, null);
    }

    public void debug(Object message, Throwable t) {
        this.log(LogLevel.DEBUG, message, t);
    }

    public void info(Object message) {
        this.log(LogLevel.INFO, message, null);
    }

    public void info(Object message, Throwable t) {
        this.log(LogLevel.INFO, message, t);
    }

    public void warn(Object message) {
        this.log(LogLevel.WARN, message, null);
    }

    public void warn(Object message, Throwable t) {
        this.log(LogLevel.WARN, message, t);
    }

    public void error(Object message) {
        this.log(LogLevel.ERROR, message, null);
    }

    public void error(Object message, Throwable t) {
        this.log(LogLevel.ERROR, message, t);
    }

    public void fatal(Object message) {
        this.log(LogLevel.FATAL, message, null);
    }

    public void fatal(Object message, Throwable t) {
        this.log(LogLevel.FATAL, message, t);
    }

    private void log(LogLevel level, Object message, Throwable t) {
        this.lines.add(new Line(level, message, t));
    }

    public void replayTo(Log log) {
        for (Line line : this.lines) {
            line.replayTo(log);
        }
        this.lines.clear();
    }

    public static Log replay(Log source, Log destination) {
        if (source instanceof DeferredLog) {
            ((DeferredLog)source).replayTo(destination);
        }
        return destination;
    }

    private static class Line {
        private final LogLevel level;
        private final Object message;
        private final Throwable throwable;

        public Line(LogLevel level, Object message, Throwable throwable) {
            this.level = level;
            this.message = message;
            this.throwable = throwable;
        }

        public void replayTo(Log log) {
            switch (this.level) {
                case TRACE: {
                    log.trace(this.message, this.throwable);
                    return;
                }
                case DEBUG: {
                    log.debug(this.message, this.throwable);
                    return;
                }
                case INFO: {
                    log.info(this.message, this.throwable);
                    return;
                }
                case WARN: {
                    log.warn(this.message, this.throwable);
                    return;
                }
                case ERROR: {
                    log.error(this.message, this.throwable);
                    return;
                }
                case FATAL: {
                    log.fatal(this.message, this.throwable);
                    return;
                }
            }
        }
    }
}

