/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.admin;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.admin.SpringApplicationAdminMXBean;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;

public class SpringApplicationAdminMXBeanRegistrar
implements ApplicationContextAware,
InitializingBean,
DisposableBean,
ApplicationListener<ApplicationReadyEvent> {
    private static final Log logger = LogFactory.getLog(SpringApplicationAdmin.class);
    private ConfigurableApplicationContext applicationContext;
    private final ObjectName objectName;
    private boolean ready = false;

    public SpringApplicationAdminMXBeanRegistrar(String name) throws MalformedObjectNameException {
        this.objectName = new ObjectName(name);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Assert.state((boolean)(applicationContext instanceof ConfigurableApplicationContext), (String)"ApplicationContext does not implement ConfigurableApplicationContext");
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.ready = true;
    }

    public void afterPropertiesSet() throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.registerMBean(new SpringApplicationAdmin(), this.objectName);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Application Admin MBean registered with name '" + this.objectName + "'"));
        }
    }

    public void destroy() throws Exception {
        ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.objectName);
    }

    private class SpringApplicationAdmin
    implements SpringApplicationAdminMXBean {
        private SpringApplicationAdmin() {
        }

        @Override
        public boolean isReady() {
            return SpringApplicationAdminMXBeanRegistrar.this.ready;
        }

        @Override
        public void shutdown() {
            logger.info((Object)"Application shutdown requested.");
            SpringApplicationAdminMXBeanRegistrar.this.applicationContext.close();
        }
    }
}

