/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.reactive;

import java.lang.reflect.AnnotatedElement;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.web.reactive.server.WebTestClient;

class WebTestClientContextCustomizer
implements ContextCustomizer {
    WebTestClientContextCustomizer() {
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        SpringBootTest annotation = (SpringBootTest)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)mergedConfig.getTestClass(), SpringBootTest.class);
        if (annotation.webEnvironment().isEmbedded()) {
            this.registerWebTestClient(context);
        }
    }

    private void registerWebTestClient(ConfigurableApplicationContext context) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory instanceof BeanDefinitionRegistry) {
            this.registerWebTestClient(context, (BeanDefinitionRegistry)context);
        }
    }

    private void registerWebTestClient(ConfigurableApplicationContext context, BeanDefinitionRegistry registry) {
        registry.registerBeanDefinition(WebTestClient.class.getName(), (BeanDefinition)new RootBeanDefinition(WebTestClientFactory.class));
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public static class WebTestClientFactory
    implements FactoryBean<WebTestClient>,
    ApplicationContextAware {
        private ApplicationContext applicationContext;
        private WebTestClient object;

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        public boolean isSingleton() {
            return true;
        }

        public Class<?> getObjectType() {
            return WebTestClient.class;
        }

        public WebTestClient getObject() throws Exception {
            if (this.object == null) {
                this.object = this.createWebTestClient();
            }
            return this.object;
        }

        private WebTestClient createWebTestClient() {
            boolean sslEnabled = this.isSslEnabled(this.applicationContext);
            String port = this.applicationContext.getEnvironment().getProperty("local.server.port", "8080");
            String baseUrl = (sslEnabled ? "https" : "http") + "://localhost:" + port;
            return WebTestClient.bindToServer().baseUrl(baseUrl).build();
        }

        private boolean isSslEnabled(ApplicationContext context) {
            try {
                AbstractReactiveWebServerFactory webServerFactory = (AbstractReactiveWebServerFactory)context.getBean(AbstractReactiveWebServerFactory.class);
                return webServerFactory.getSsl() != null && webServerFactory.getSsl().isEnabled();
            }
            catch (NoSuchBeanDefinitionException ex) {
                return false;
            }
        }
    }
}

