/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.util;

import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.Assert;

public final class TestPropertyValues {
    private final Map<String, Object> properties = new HashMap<String, Object>();

    private TestPropertyValues(String[] pairs) {
        this.addProperties(pairs);
    }

    private void addProperties(String[] pairs) {
        String[] stringArray = pairs;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String pair;
            int index = this.getSeparatorIndex(pair = stringArray[i]);
            String key = pair.substring(0, index > 0 ? index : pair.length());
            String value = index > 0 ? pair.substring(index + 1) : "";
            this.properties.put(key.trim(), value.trim());
        }
    }

    private int getSeparatorIndex(String pair) {
        int colonIndex = pair.indexOf(":");
        int equalIndex = pair.indexOf("=");
        if (colonIndex == -1) {
            return equalIndex;
        }
        if (equalIndex == -1) {
            return colonIndex;
        }
        return Math.min(colonIndex, equalIndex);
    }

    public TestPropertyValues and(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public void applyTo(ConfigurableApplicationContext context) {
        this.applyTo(context.getEnvironment());
    }

    public void applyTo(ConfigurableEnvironment environment) {
        this.applyTo(environment, Type.MAP);
    }

    public void applyTo(ConfigurableEnvironment environment, Type type) {
        this.applyTo(environment, type, "test");
    }

    public void applyTo(ConfigurableEnvironment environment, Type type, String name) {
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        Assert.notNull((Object)((Object)type), (String)"Property source type must not be null");
        Assert.notNull((Object)name, (String)"Property source name must not be null");
        MutablePropertySources sources = environment.getPropertySources();
        this.addToSources(sources, type, name);
        ConfigurationPropertySources.attach((Environment)environment);
    }

    private void addToSources(MutablePropertySources sources, Type type, String name) {
        PropertySource propertySource;
        if (sources.contains(name) && (propertySource = sources.get(name)).getClass().equals(type.getSourceClass())) {
            ((Map)propertySource.getSource()).putAll(this.properties);
            return;
        }
        MapPropertySource source = type.equals((Object)Type.MAP) ? new MapPropertySource(name, this.properties) : new SystemEnvironmentPropertySource(name, this.properties);
        sources.addFirst((PropertySource)source);
    }

    public static TestPropertyValues of(String ... pairs) {
        return new TestPropertyValues(pairs);
    }

    public static enum Type {
        SYSTEM(SystemEnvironmentPropertySource.class),
        MAP(MapPropertySource.class);

        private Class<? extends MapPropertySource> sourceClass;

        private Type(Class<? extends MapPropertySource> sourceClass) {
            this.sourceClass = sourceClass;
        }

        public Class<? extends MapPropertySource> getSourceClass() {
            return this.sourceClass;
        }
    }
}

