/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.filewatch;

import java.io.File;
import org.springframework.util.Assert;

class FileSnapshot {
    private final File file;
    private final boolean exists;
    private final long length;
    private final long lastModified;

    public FileSnapshot(File file) {
        Assert.notNull((Object)file, (String)"File must not be null");
        Assert.isTrue((file.isFile() || !file.exists() ? 1 : 0) != 0, (String)"File must not be a folder");
        this.file = file;
        this.exists = file.exists();
        this.length = file.length();
        this.lastModified = file.lastModified();
    }

    public File getFile() {
        return this.file;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof FileSnapshot) {
            FileSnapshot other = (FileSnapshot)obj;
            boolean equals = this.file.equals(other.file);
            equals &= this.exists == other.exists;
            equals &= this.length == other.length;
            return equals &= this.lastModified == other.lastModified;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hashCode = this.file.hashCode();
        hashCode = 31 * hashCode + (this.exists ? 1231 : 1237);
        hashCode = 31 * hashCode + (int)(this.length ^ this.length >>> 32);
        hashCode = 31 * hashCode + (int)(this.lastModified ^ this.lastModified >>> 32);
        return hashCode;
    }

    public String toString() {
        return this.file.toString();
    }
}

