/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.devtools.autoconfigure.RemoteDevToolsProperties;

@ConfigurationProperties(prefix="spring.devtools")
public class DevToolsProperties {
    private static final String DEFAULT_RESTART_EXCLUDES = "META-INF/maven/**,META-INF/resources/**,resources/**,static/**,public/**,templates/**";
    private static final long DEFAULT_RESTART_POLL_INTERVAL = 1000L;
    private static final long DEFAULT_RESTART_QUIET_PERIOD = 400L;
    private Restart restart = new Restart();
    private Livereload livereload = new Livereload();
    @NestedConfigurationProperty
    private RemoteDevToolsProperties remote = new RemoteDevToolsProperties();

    public Restart getRestart() {
        return this.restart;
    }

    public Livereload getLivereload() {
        return this.livereload;
    }

    public RemoteDevToolsProperties getRemote() {
        return this.remote;
    }

    public static class Livereload {
        private boolean enabled = true;
        private int port = 35729;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }

    public static class Restart {
        private boolean enabled = true;
        private String exclude = "META-INF/maven/**,META-INF/resources/**,resources/**,static/**,public/**,templates/**";
        private long pollInterval = 1000L;
        private long quietPeriod = 400L;
        private String triggerFile;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getExclude() {
            return this.exclude;
        }

        public void setExclude(String exclude) {
            this.exclude = exclude;
        }

        public long getPollInterval() {
            return this.pollInterval;
        }

        public void setPollInterval(long pollInterval) {
            this.pollInterval = pollInterval;
        }

        public long getQuietPeriod() {
            return this.quietPeriod;
        }

        public void setQuietPeriod(long quietPeriod) {
            this.quietPeriod = quietPeriod;
        }

        public String getTriggerFile() {
            return this.triggerFile;
        }

        public void setTriggerFile(String triggerFile) {
            this.triggerFile = triggerFile;
        }
    }
}

