/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded.tomcat;

import java.time.Duration;
import org.apache.catalina.Valve;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.catalina.valves.RemoteIpValve;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.web.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.web.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public final class TomcatCustomizer {
    private TomcatCustomizer() {
    }

    public static void customizeTomcat(ServerProperties serverProperties, Environment environment, ConfigurableTomcatWebServerFactory factory) {
        ServerProperties.Tomcat tomcatProperties = serverProperties.getTomcat();
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(tomcatProperties::getBasedir).whenNonNull().to(arg_0 -> ((ConfigurableTomcatWebServerFactory)factory).setBaseDirectory(arg_0));
        propertyMapper.from(tomcatProperties::getBackgroundProcessorDelay).whenNonNull().as(Duration::getSeconds).as(Long::intValue).to(arg_0 -> ((ConfigurableTomcatWebServerFactory)factory).setBackgroundProcessorDelay(arg_0));
        TomcatCustomizer.customizeRemoteIpValve(serverProperties, environment, factory);
        propertyMapper.from(tomcatProperties::getMaxThreads).when(TomcatCustomizer::isPositive).to(maxThreads -> TomcatCustomizer.customizeMaxThreads(factory, tomcatProperties.getMaxThreads()));
        propertyMapper.from(tomcatProperties::getMinSpareThreads).when(TomcatCustomizer::isPositive).to(minSpareThreads -> TomcatCustomizer.customizeMinThreads(factory, minSpareThreads));
        propertyMapper.from(() -> TomcatCustomizer.determineMaxHttpHeaderSize(serverProperties, tomcatProperties)).when(TomcatCustomizer::isPositive).to(maxHttpHeaderSize -> TomcatCustomizer.customizeMaxHttpHeaderSize(factory, maxHttpHeaderSize));
        propertyMapper.from(tomcatProperties::getMaxHttpPostSize).when(maxHttpPostSize -> maxHttpPostSize != 0).to(maxHttpPostSize -> TomcatCustomizer.customizeMaxHttpPostSize(factory, maxHttpPostSize));
        propertyMapper.from(tomcatProperties::getAccesslog).when(ServerProperties.Tomcat.Accesslog::isEnabled).to(enabled -> TomcatCustomizer.customizeAccessLog(tomcatProperties, factory));
        propertyMapper.from(tomcatProperties::getUriEncoding).whenNonNull().to(arg_0 -> ((ConfigurableTomcatWebServerFactory)factory).setUriEncoding(arg_0));
        propertyMapper.from(serverProperties::getConnectionTimeout).whenNonNull().to(connectionTimeout -> TomcatCustomizer.customizeConnectionTimeout(factory, connectionTimeout));
        propertyMapper.from(tomcatProperties::getMaxConnections).when(TomcatCustomizer::isPositive).to(maxConnections -> TomcatCustomizer.customizeMaxConnections(factory, maxConnections));
        propertyMapper.from(tomcatProperties::getAcceptCount).when(TomcatCustomizer::isPositive).to(acceptCount -> TomcatCustomizer.customizeAcceptCount(factory, acceptCount));
        TomcatCustomizer.customizeStaticResources(serverProperties.getTomcat().getResource(), factory);
        TomcatCustomizer.customizeErrorReportValve(serverProperties.getError(), factory);
    }

    private static boolean isPositive(int value) {
        return value > 0;
    }

    private static int determineMaxHttpHeaderSize(ServerProperties serverProperties, ServerProperties.Tomcat tomcatProperties) {
        return serverProperties.getMaxHttpHeaderSize() > 0 ? serverProperties.getMaxHttpHeaderSize() : tomcatProperties.getMaxHttpHeaderSize();
    }

    private static void customizeAcceptCount(ConfigurableTomcatWebServerFactory factory, int acceptCount) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setAcceptCount(acceptCount);
            }
        }});
    }

    private static void customizeMaxConnections(ConfigurableTomcatWebServerFactory factory, int maxConnections) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setMaxConnections(maxConnections);
            }
        }});
    }

    private static void customizeConnectionTimeout(ConfigurableTomcatWebServerFactory factory, Duration connectionTimeout) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setConnectionTimeout((int)connectionTimeout.toMillis());
            }
        }});
    }

    private static void customizeRemoteIpValve(ServerProperties properties, Environment environment, ConfigurableTomcatWebServerFactory factory) {
        String protocolHeader = properties.getTomcat().getProtocolHeader();
        String remoteIpHeader = properties.getTomcat().getRemoteIpHeader();
        if (StringUtils.hasText((String)protocolHeader) || StringUtils.hasText((String)remoteIpHeader) || TomcatCustomizer.getOrDeduceUseForwardHeaders(properties, environment)) {
            RemoteIpValve valve = new RemoteIpValve();
            valve.setProtocolHeader(StringUtils.hasLength((String)protocolHeader) ? protocolHeader : "X-Forwarded-Proto");
            if (StringUtils.hasLength((String)remoteIpHeader)) {
                valve.setRemoteIpHeader(remoteIpHeader);
            }
            valve.setInternalProxies(properties.getTomcat().getInternalProxies());
            valve.setPortHeader(properties.getTomcat().getPortHeader());
            valve.setProtocolHeaderHttpsValue(properties.getTomcat().getProtocolHeaderHttpsValue());
            factory.addEngineValves(new Valve[]{valve});
        }
    }

    private static boolean getOrDeduceUseForwardHeaders(ServerProperties serverProperties, Environment environment) {
        if (serverProperties.isUseForwardHeaders() != null) {
            return serverProperties.isUseForwardHeaders();
        }
        CloudPlatform platform = CloudPlatform.getActive((Environment)environment);
        return platform != null && platform.isUsingForwardHeaders();
    }

    private static void customizeMaxThreads(ConfigurableTomcatWebServerFactory factory, int maxThreads) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setMaxThreads(maxThreads);
            }
        }});
    }

    private static void customizeMinThreads(ConfigurableTomcatWebServerFactory factory, int minSpareThreads) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractProtocol) {
                AbstractProtocol protocol = (AbstractProtocol)handler;
                protocol.setMinSpareThreads(minSpareThreads);
            }
        }});
    }

    private static void customizeMaxHttpHeaderSize(ConfigurableTomcatWebServerFactory factory, int maxHttpHeaderSize) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> {
            ProtocolHandler handler = connector.getProtocolHandler();
            if (handler instanceof AbstractHttp11Protocol) {
                AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)handler;
                protocol.setMaxHttpHeaderSize(maxHttpHeaderSize);
            }
        }});
    }

    private static void customizeMaxHttpPostSize(ConfigurableTomcatWebServerFactory factory, int maxHttpPostSize) {
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{connector -> connector.setMaxPostSize(maxHttpPostSize)});
    }

    private static void customizeAccessLog(ServerProperties.Tomcat tomcatProperties, ConfigurableTomcatWebServerFactory factory) {
        AccessLogValve valve = new AccessLogValve();
        valve.setPattern(tomcatProperties.getAccesslog().getPattern());
        valve.setDirectory(tomcatProperties.getAccesslog().getDirectory());
        valve.setPrefix(tomcatProperties.getAccesslog().getPrefix());
        valve.setSuffix(tomcatProperties.getAccesslog().getSuffix());
        valve.setRenameOnRotate(tomcatProperties.getAccesslog().isRenameOnRotate());
        valve.setFileDateFormat(tomcatProperties.getAccesslog().getFileDateFormat());
        valve.setRequestAttributesEnabled(tomcatProperties.getAccesslog().isRequestAttributesEnabled());
        valve.setRotatable(tomcatProperties.getAccesslog().isRotate());
        valve.setBuffered(tomcatProperties.getAccesslog().isBuffered());
        factory.addEngineValves(new Valve[]{valve});
    }

    private static void customizeStaticResources(ServerProperties.Tomcat.Resource resource, ConfigurableTomcatWebServerFactory factory) {
        if (resource.getCacheTtl() == null) {
            return;
        }
        factory.addContextCustomizers(new TomcatContextCustomizer[]{context -> context.addLifecycleListener(event -> {
            if (event.getType().equals("configure_start")) {
                long ttl = resource.getCacheTtl().toMillis();
                context.getResources().setCacheTtl(ttl);
            }
        })});
    }

    private static void customizeErrorReportValve(ErrorProperties error, ConfigurableTomcatWebServerFactory factory) {
        if (error.getIncludeStacktrace() == ErrorProperties.IncludeStacktrace.NEVER) {
            factory.addContextCustomizers(new TomcatContextCustomizer[]{context -> {
                ErrorReportValve valve = new ErrorReportValve();
                valve.setShowServerInfo(false);
                valve.setShowReport(false);
                context.getParent().getPipeline().addValve((Valve)valve);
            }});
        }
    }
}

