/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.embedded.jetty;

import java.time.Duration;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NCSARequestLog;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.web.embedded.jetty.ConfigurableJettyWebServerFactory;
import org.springframework.boot.web.embedded.jetty.JettyServerCustomizer;
import org.springframework.core.env.Environment;

public final class JettyCustomizer {
    private JettyCustomizer() {
    }

    public static void customizeJetty(ServerProperties serverProperties, Environment environment, ConfigurableJettyWebServerFactory factory) {
        ServerProperties.Jetty jettyProperties = serverProperties.getJetty();
        factory.setUseForwardHeaders(JettyCustomizer.getOrDeduceUseForwardHeaders(serverProperties, environment));
        PropertyMapper propertyMapper = PropertyMapper.get();
        propertyMapper.from(jettyProperties::getAcceptors).whenNonNull().to(arg_0 -> ((ConfigurableJettyWebServerFactory)factory).setAcceptors(arg_0));
        propertyMapper.from(jettyProperties::getSelectors).whenNonNull().to(arg_0 -> ((ConfigurableJettyWebServerFactory)factory).setSelectors(arg_0));
        propertyMapper.from(serverProperties::getMaxHttpHeaderSize).when(JettyCustomizer::isPositive).to(maxHttpHeaderSize -> JettyCustomizer.customizeMaxHttpHeaderSize(factory, maxHttpHeaderSize));
        propertyMapper.from(jettyProperties::getMaxHttpPostSize).when(JettyCustomizer::isPositive).to(maxHttpPostSize -> JettyCustomizer.customizeMaxHttpPostSize(factory, maxHttpPostSize));
        propertyMapper.from(serverProperties::getConnectionTimeout).whenNonNull().to(connectionTimeout -> JettyCustomizer.customizeConnectionTimeout(factory, connectionTimeout));
        propertyMapper.from(jettyProperties::getAccesslog).when(ServerProperties.Jetty.Accesslog::isEnabled).to(accesslog -> JettyCustomizer.customizeAccessLog(factory, accesslog));
    }

    private static boolean isPositive(Integer value) {
        return value > 0;
    }

    private static boolean getOrDeduceUseForwardHeaders(ServerProperties serverProperties, Environment environment) {
        if (serverProperties.isUseForwardHeaders() != null) {
            return serverProperties.isUseForwardHeaders();
        }
        CloudPlatform platform = CloudPlatform.getActive((Environment)environment);
        return platform != null && platform.isUsingForwardHeaders();
    }

    private static void customizeConnectionTimeout(ConfigurableJettyWebServerFactory factory, Duration connectionTimeout) {
        factory.addServerCustomizers(new JettyServerCustomizer[]{server -> {
            for (Connector connector : server.getConnectors()) {
                if (!(connector instanceof AbstractConnector)) continue;
                ((AbstractConnector)connector).setIdleTimeout(connectionTimeout.toMillis());
            }
        }});
    }

    private static void customizeMaxHttpHeaderSize(ConfigurableJettyWebServerFactory factory, final int maxHttpHeaderSize) {
        factory.addServerCustomizers(new JettyServerCustomizer[]{new JettyServerCustomizer(){

            public void customize(Server server) {
                for (Connector connector : server.getConnectors()) {
                    for (ConnectionFactory connectionFactory : connector.getConnectionFactories()) {
                        if (!(connectionFactory instanceof HttpConfiguration.ConnectionFactory)) continue;
                        this.customize((HttpConfiguration.ConnectionFactory)connectionFactory);
                    }
                }
            }

            private void customize(HttpConfiguration.ConnectionFactory factory) {
                HttpConfiguration configuration = factory.getHttpConfiguration();
                configuration.setRequestHeaderSize(maxHttpHeaderSize);
                configuration.setResponseHeaderSize(maxHttpHeaderSize);
            }
        }});
    }

    private static void customizeMaxHttpPostSize(ConfigurableJettyWebServerFactory factory, final int maxHttpPostSize) {
        factory.addServerCustomizers(new JettyServerCustomizer[]{new JettyServerCustomizer(){

            public void customize(Server server) {
                this.setHandlerMaxHttpPostSize(maxHttpPostSize, server.getHandlers());
            }

            private void setHandlerMaxHttpPostSize(int maxHttpPostSize2, Handler ... handlers) {
                for (Handler handler : handlers) {
                    if (handler instanceof ContextHandler) {
                        ((ContextHandler)handler).setMaxFormContentSize(maxHttpPostSize2);
                        continue;
                    }
                    if (handler instanceof HandlerWrapper) {
                        this.setHandlerMaxHttpPostSize(maxHttpPostSize2, ((HandlerWrapper)handler).getHandler());
                        continue;
                    }
                    if (!(handler instanceof HandlerCollection)) continue;
                    this.setHandlerMaxHttpPostSize(maxHttpPostSize2, ((HandlerCollection)handler).getHandlers());
                }
            }
        }});
    }

    private static void customizeAccessLog(ConfigurableJettyWebServerFactory factory, ServerProperties.Jetty.Accesslog properties) {
        factory.addServerCustomizers(new JettyServerCustomizer[]{server -> {
            NCSARequestLog log = new NCSARequestLog();
            if (properties.getFilename() != null) {
                log.setFilename(properties.getFilename());
            }
            if (properties.getFileDateFormat() != null) {
                log.setFilenameDateFormat(properties.getFileDateFormat());
            }
            log.setRetainDays(properties.getRetentionPeriod());
            log.setAppend(properties.isAppend());
            log.setExtended(properties.isExtendedFormat());
            if (properties.getDateFormat() != null) {
                log.setLogDateFormat(properties.getDateFormat());
            }
            if (properties.getLocale() != null) {
                log.setLogLocale(properties.getLocale());
            }
            if (properties.getTimeZone() != null) {
                log.setLogTimeZone(properties.getTimeZone().getID());
            }
            log.setLogCookies(properties.isLogCookies());
            log.setLogServer(properties.isLogServer());
            log.setLogLatency(properties.isLogLatency());
            server.setRequestLog((RequestLog)log);
        }});
    }
}

