/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.session.RedisSessionProperties;
import org.springframework.boot.autoconfigure.session.SessionCondition;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.session.SessionRepository;
import org.springframework.session.data.redis.RedisOperationsSessionRepository;
import org.springframework.session.data.redis.config.annotation.web.http.RedisHttpSessionConfiguration;

@Configuration
@ConditionalOnClass(value={RedisTemplate.class, RedisOperationsSessionRepository.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={RedisConnectionFactory.class})
@Conditional(value={SessionCondition.class})
@EnableConfigurationProperties(value={RedisSessionProperties.class})
class RedisSessionConfiguration {
    RedisSessionConfiguration() {
    }

    @Configuration
    public static class SpringBootRedisHttpSessionConfiguration
    extends RedisHttpSessionConfiguration {
        private SessionProperties sessionProperties;

        @Autowired
        public void customize(SessionProperties sessionProperties, RedisSessionProperties redisSessionProperties) {
            this.sessionProperties = sessionProperties;
            Integer timeout = this.sessionProperties.getTimeout();
            if (timeout != null) {
                this.setMaxInactiveIntervalInSeconds(timeout);
            }
            this.setRedisNamespace(redisSessionProperties.getNamespace());
            this.setRedisFlushMode(redisSessionProperties.getFlushMode());
        }
    }
}

