/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security;

import java.lang.reflect.Field;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.ProviderManagerBuilder;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnBean(value={ObjectPostProcessor.class})
@ConditionalOnMissingBean(value={AuthenticationManager.class, AuthenticationProvider.class, UserDetailsService.class})
@Order(value=0)
public class AuthenticationManagerConfiguration {
    private static final Log logger = LogFactory.getLog(AuthenticationManagerConfiguration.class);

    @Bean
    @Primary
    public AuthenticationManager authenticationManager(AuthenticationConfiguration configuration) throws Exception {
        return configuration.getAuthenticationManager();
    }

    @Bean
    public static SpringBootAuthenticationConfigurerAdapter springBootAuthenticationConfigurerAdapter() {
        return new SpringBootAuthenticationConfigurerAdapter();
    }

    @Bean
    public AuthenticationManagerConfigurationListener authenticationManagerConfigurationListener() {
        return new AuthenticationManagerConfigurationListener();
    }

    protected static class AuthenticationManagerConfigurationListener
    implements SmartInitializingSingleton {
        @Autowired
        private AuthenticationEventPublisher eventPublisher;
        @Autowired
        private ApplicationContext context;

        protected AuthenticationManagerConfigurationListener() {
        }

        public void afterSingletonsInstantiated() {
            try {
                this.configureAuthenticationManager((AuthenticationManager)this.context.getBean(AuthenticationManager.class));
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }

        private void configureAuthenticationManager(AuthenticationManager manager) {
            if (manager instanceof ProviderManager) {
                ((ProviderManager)manager).setAuthenticationEventPublisher(this.eventPublisher);
            }
        }
    }

    private static class DefaultInMemoryUserDetailsManagerConfigurer
    extends InMemoryUserDetailsManagerConfigurer<AuthenticationManagerBuilder> {
        private DefaultInMemoryUserDetailsManagerConfigurer() {
        }

        public void configure(AuthenticationManagerBuilder auth) throws Exception {
            if (auth.isConfigured()) {
                return;
            }
            String password = UUID.randomUUID().toString();
            logger.info((Object)String.format("%n%nUsing default security password: %s%n", password));
            this.withUser("user").password(password).roles(new String[0]);
            this.setField(auth, "defaultUserDetailsService", this.getUserDetailsService());
            super.configure((ProviderManagerBuilder)auth);
        }

        private void setField(Object target, String name, Object value) {
            try {
                Field field = ReflectionUtils.findField(target.getClass(), (String)name);
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)target, (Object)value);
            }
            catch (Exception ex) {
                logger.info((Object)("Could not set " + name));
            }
        }
    }

    @Order(value=2147483547)
    private static class SpringBootAuthenticationConfigurerAdapter
    extends GlobalAuthenticationConfigurerAdapter {
        private SpringBootAuthenticationConfigurerAdapter() {
        }

        public void init(AuthenticationManagerBuilder auth) throws Exception {
            auth.apply((SecurityConfigurerAdapter)new DefaultInMemoryUserDetailsManagerConfigurer());
        }
    }
}

