/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.batch;

import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.support.JobRepositoryFactoryBean;
import org.springframework.boot.autoconfigure.batch.BatchProperties;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.StringUtils;

@Component
class BasicBatchConfigurer
implements BatchConfigurer {
    private static Log logger = LogFactory.getLog(BasicBatchConfigurer.class);
    private final BatchProperties properties;
    private final DataSource dataSource;
    private final EntityManagerFactory entityManagerFactory;
    private PlatformTransactionManager transactionManager;
    private JobRepository jobRepository;
    private JobLauncher jobLauncher;
    private JobExplorer jobExplorer;

    public BasicBatchConfigurer(BatchProperties properties, DataSource dataSource) {
        this(properties, dataSource, null);
    }

    public BasicBatchConfigurer(BatchProperties properties, DataSource dataSource, EntityManagerFactory entityManagerFactory) {
        this.properties = properties;
        this.entityManagerFactory = entityManagerFactory;
        this.dataSource = dataSource;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public JobLauncher getJobLauncher() {
        return this.jobLauncher;
    }

    public JobExplorer getJobExplorer() throws Exception {
        return this.jobExplorer;
    }

    @PostConstruct
    public void initialize() {
        try {
            this.transactionManager = this.createTransactionManager();
            this.jobRepository = this.createJobRepository();
            this.jobLauncher = this.createJobLauncher();
            this.jobExplorer = this.createJobExplorer();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to initialize Spring Batch", ex);
        }
    }

    private JobExplorer createJobExplorer() throws Exception {
        JobExplorerFactoryBean jobExplorerFactoryBean = new JobExplorerFactoryBean();
        jobExplorerFactoryBean.setDataSource(this.dataSource);
        String tablePrefix = this.properties.getTablePrefix();
        if (StringUtils.hasText((String)tablePrefix)) {
            jobExplorerFactoryBean.setTablePrefix(tablePrefix);
        }
        jobExplorerFactoryBean.afterPropertiesSet();
        return jobExplorerFactoryBean.getObject();
    }

    private JobLauncher createJobLauncher() throws Exception {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(this.getJobRepository());
        jobLauncher.afterPropertiesSet();
        return jobLauncher;
    }

    protected JobRepository createJobRepository() throws Exception {
        String tablePrefix;
        JobRepositoryFactoryBean factory = new JobRepositoryFactoryBean();
        factory.setDataSource(this.dataSource);
        if (this.entityManagerFactory != null) {
            logger.warn((Object)"JPA does not support custom isolation levels, so locks may not be taken when launching Jobs");
            factory.setIsolationLevelForCreate("ISOLATION_DEFAULT");
        }
        if (StringUtils.hasText((String)(tablePrefix = this.properties.getTablePrefix()))) {
            factory.setTablePrefix(tablePrefix);
        }
        factory.setTransactionManager(this.getTransactionManager());
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    protected PlatformTransactionManager createTransactionManager() {
        if (this.entityManagerFactory != null) {
            return new JpaTransactionManager(this.entityManagerFactory);
        }
        return new DataSourceTransactionManager(this.dataSource);
    }
}

