/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.thymeleaf;

import com.github.mxab.thymeleaf.extras.dataattribute.dialect.DataAttributeDialect;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import javax.annotation.PostConstruct;
import javax.servlet.Servlet;
import nz.net.ultraq.thymeleaf.LayoutDialect;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.template.TemplateLocation;
import org.springframework.boot.autoconfigure.thymeleaf.ThymeleafProperties;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.web.servlet.resource.ResourceUrlEncodingFilter;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.conditionalcomments.dialect.ConditionalCommentsDialect;
import org.thymeleaf.extras.springsecurity4.dialect.SpringSecurityDialect;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.spring4.SpringTemplateEngine;
import org.thymeleaf.spring4.resourceresolver.SpringResourceResourceResolver;
import org.thymeleaf.spring4.view.ThymeleafViewResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolver;

@Configuration
@EnableConfigurationProperties(value={ThymeleafProperties.class})
@ConditionalOnClass(value={SpringTemplateEngine.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class ThymeleafAutoConfiguration {

    @Configuration
    @ConditionalOnWebApplication
    protected static class ThymeleafResourceHandlingConfig {
        protected ThymeleafResourceHandlingConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ResourceUrlEncodingFilter resourceUrlEncodingFilter() {
            return new ResourceUrlEncodingFilter();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Servlet.class})
    @ConditionalOnWebApplication
    protected static class ThymeleafViewResolverConfiguration {
        @Autowired
        private ThymeleafProperties properties;
        @Autowired
        private SpringTemplateEngine templateEngine;

        protected ThymeleafViewResolverConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"thymeleafViewResolver"})
        @ConditionalOnProperty(name={"spring.thymeleaf.enabled"}, matchIfMissing=true)
        public ThymeleafViewResolver thymeleafViewResolver() {
            ThymeleafViewResolver resolver = new ThymeleafViewResolver();
            resolver.setTemplateEngine(this.templateEngine);
            resolver.setCharacterEncoding(this.properties.getEncoding().name());
            resolver.setContentType(this.appendCharset(this.properties.getContentType(), resolver.getCharacterEncoding()));
            resolver.setExcludedViewNames(this.properties.getExcludedViewNames());
            resolver.setViewNames(this.properties.getViewNames());
            resolver.setOrder(0x7FFFFFFA);
            return resolver;
        }

        private String appendCharset(MimeType type, String charset) {
            if (type.getCharSet() != null) {
                return type.toString();
            }
            LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
            parameters.put("charset", charset);
            parameters.putAll(type.getParameters());
            return new MimeType(type, parameters).toString();
        }
    }

    @Configuration
    @ConditionalOnClass(value={ConditionalCommentsDialect.class})
    protected static class ThymeleafConditionalCommentsDialectConfiguration {
        protected ThymeleafConditionalCommentsDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public ConditionalCommentsDialect conditionalCommentsDialect() {
            return new ConditionalCommentsDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={SpringSecurityDialect.class})
    protected static class ThymeleafSecurityDialectConfiguration {
        protected ThymeleafSecurityDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public SpringSecurityDialect securityDialect() {
            return new SpringSecurityDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={DataAttributeDialect.class})
    protected static class DataAttributeDialectConfiguration {
        protected DataAttributeDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public DataAttributeDialect dialect() {
            return new DataAttributeDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"nz.net.ultraq.thymeleaf.LayoutDialect"})
    protected static class ThymeleafWebLayoutConfiguration {
        protected ThymeleafWebLayoutConfiguration() {
        }

        @Bean
        public LayoutDialect layoutDialect() {
            return new LayoutDialect();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={SpringTemplateEngine.class})
    protected static class ThymeleafDefaultConfiguration {
        @Autowired
        private final Collection<ITemplateResolver> templateResolvers = Collections.emptySet();
        @Autowired(required=false)
        private final Collection<IDialect> dialects = Collections.emptySet();

        protected ThymeleafDefaultConfiguration() {
        }

        @Bean
        public SpringTemplateEngine templateEngine() {
            SpringTemplateEngine engine = new SpringTemplateEngine();
            for (ITemplateResolver templateResolver : this.templateResolvers) {
                engine.addTemplateResolver(templateResolver);
            }
            for (IDialect dialect : this.dialects) {
                engine.addDialect(dialect);
            }
            return engine;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(name={"defaultTemplateResolver"})
    public static class DefaultTemplateResolverConfiguration {
        @Autowired
        private ThymeleafProperties properties;
        @Autowired
        private ApplicationContext applicationContext;

        @PostConstruct
        public void checkTemplateLocationExists() {
            boolean checkTemplateLocation = this.properties.isCheckTemplateLocation();
            if (checkTemplateLocation) {
                TemplateLocation location = new TemplateLocation(this.properties.getPrefix());
                Assert.state((boolean)location.exists((ResourcePatternResolver)this.applicationContext), (String)("Cannot find template location: " + location + " (please add some templates or check " + "your Thymeleaf configuration)"));
            }
        }

        @Bean
        public TemplateResolver defaultTemplateResolver() {
            TemplateResolver resolver = new TemplateResolver();
            resolver.setResourceResolver((IResourceResolver)this.thymeleafResourceResolver());
            resolver.setPrefix(this.properties.getPrefix());
            resolver.setSuffix(this.properties.getSuffix());
            resolver.setTemplateMode(this.properties.getMode());
            if (this.properties.getEncoding() != null) {
                resolver.setCharacterEncoding(this.properties.getEncoding().name());
            }
            resolver.setCacheable(this.properties.isCache());
            Integer order = this.properties.getTemplateResolverOrder();
            if (order != null) {
                resolver.setOrder(order);
            }
            return resolver;
        }

        @Bean
        public SpringResourceResourceResolver thymeleafResourceResolver() {
            return new SpringResourceResourceResolver();
        }
    }
}

