/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.flyway;

import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.jpa.EntityManagerFactoryDependsOnPostProcessor;
import org.springframework.boot.autoconfigure.flyway.FlywayDataSource;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.orm.jpa.HibernateJpaAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(value={Flyway.class})
@ConditionalOnBean(value={DataSource.class})
@ConditionalOnProperty(prefix="flyway", name={"enabled"}, matchIfMissing=true)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class, HibernateJpaAutoConfiguration.class})
public class FlywayAutoConfiguration {

    private static class FlywayMigrationInitializer
    implements InitializingBean {
        private final Flyway flyway;
        private final FlywayMigrationStrategy migrationStrategy;

        public FlywayMigrationInitializer(Flyway flyway, FlywayMigrationStrategy migrationStrategy) {
            this.flyway = flyway;
            this.migrationStrategy = migrationStrategy;
        }

        public void afterPropertiesSet() throws Exception {
            if (this.migrationStrategy != null) {
                this.migrationStrategy.migrate(this.flyway);
            } else {
                this.flyway.migrate();
            }
        }
    }

    @Configuration
    @ConditionalOnClass(value={LocalContainerEntityManagerFactoryBean.class})
    @ConditionalOnBean(value={AbstractEntityManagerFactoryBean.class})
    protected static class FlywayJpaDependencyConfiguration
    extends EntityManagerFactoryDependsOnPostProcessor {
        public FlywayJpaDependencyConfiguration() {
            super("flywayInitializer", "flyway");
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={Flyway.class})
    @EnableConfigurationProperties(value={FlywayProperties.class})
    @Import(value={FlywayJpaDependencyConfiguration.class})
    public static class FlywayConfiguration {
        @Autowired
        private FlywayProperties properties = new FlywayProperties();
        @Autowired
        private ResourceLoader resourceLoader = new DefaultResourceLoader();
        @Autowired(required=false)
        private DataSource dataSource;
        @Autowired(required=false)
        @FlywayDataSource
        private DataSource flywayDataSource;
        @Autowired(required=false)
        private FlywayMigrationStrategy migrationStrategy;

        @PostConstruct
        public void checkLocationExists() {
            if (this.properties.isCheckLocation()) {
                Assert.state((!this.properties.getLocations().isEmpty() ? 1 : 0) != 0, (String)"Migration script locations not configured");
                boolean exists = this.hasAtLeastOneLocation();
                Assert.state((boolean)exists, (String)("Cannot find migrations location in: " + this.properties.getLocations() + " (please add migrations or check your Flyway configuration)"));
            }
        }

        private boolean hasAtLeastOneLocation() {
            for (String location : this.properties.getLocations()) {
                if (!this.resourceLoader.getResource(location).exists()) continue;
                return true;
            }
            return false;
        }

        @Bean
        @ConfigurationProperties(prefix="flyway")
        public Flyway flyway() {
            Flyway flyway = new Flyway();
            if (this.properties.isCreateDataSource()) {
                flyway.setDataSource(this.properties.getUrl(), this.properties.getUser(), this.properties.getPassword(), this.properties.getInitSqls().toArray(new String[0]));
            } else if (this.flywayDataSource != null) {
                flyway.setDataSource(this.flywayDataSource);
            } else {
                flyway.setDataSource(this.dataSource);
            }
            return flyway;
        }

        @Bean
        public FlywayMigrationInitializer flywayInitializer(Flyway flyway) {
            return new FlywayMigrationInitializer(flyway, this.migrationStrategy);
        }
    }
}

