/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerEndpointsConfiguration;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@ConfigurationProperties(value="spring.oauth2.resource")
public class ResourceServerProperties
implements Validator,
BeanFactoryAware {
    @JsonIgnore
    private final String clientId;
    @JsonIgnore
    private final String clientSecret;
    @JsonIgnore
    private ListableBeanFactory beanFactory;
    private String serviceId = "resource";
    private String id;
    private String userInfoUri;
    private String tokenInfoUri;
    private boolean preferTokenInfo = true;
    private String tokenType = "Bearer";
    private Jwt jwt = new Jwt();

    public ResourceServerProperties() {
        this(null, null);
    }

    public ResourceServerProperties(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ListableBeanFactory)beanFactory;
    }

    public String getResourceId() {
        return this.id;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUserInfoUri() {
        return this.userInfoUri;
    }

    public void setUserInfoUri(String userInfoUri) {
        this.userInfoUri = userInfoUri;
    }

    public String getTokenInfoUri() {
        return this.tokenInfoUri;
    }

    public void setTokenInfoUri(String tokenInfoUri) {
        this.tokenInfoUri = tokenInfoUri;
    }

    public boolean isPreferTokenInfo() {
        return this.preferTokenInfo;
    }

    public void setPreferTokenInfo(boolean preferTokenInfo) {
        this.preferTokenInfo = preferTokenInfo;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Jwt getJwt() {
        return this.jwt;
    }

    public void setJwt(Jwt jwt) {
        this.jwt = jwt;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public boolean supports(Class<?> clazz) {
        return ResourceServerProperties.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, AuthorizationServerEndpointsConfiguration.class).length > 0) {
            return;
        }
        ResourceServerProperties resource = (ResourceServerProperties)target;
        if (StringUtils.hasText((String)this.clientId)) {
            if (!StringUtils.hasText((String)this.clientSecret)) {
                if (!StringUtils.hasText((String)resource.getUserInfoUri())) {
                    errors.rejectValue("userInfoUri", "missing.userInfoUri", "Missing userInfoUri (no client secret available)");
                }
            } else if (this.isPreferTokenInfo() && !StringUtils.hasText((String)resource.getTokenInfoUri())) {
                if (StringUtils.hasText((String)this.getJwt().getKeyUri()) || StringUtils.hasText((String)this.getJwt().getKeyValue())) {
                    return;
                }
                if (!StringUtils.hasText((String)resource.getUserInfoUri())) {
                    errors.rejectValue("tokenInfoUri", "missing.tokenInfoUri", "Missing tokenInfoUri and userInfoUri and there is no JWT verifier key");
                }
            }
        }
    }

    public class Jwt {
        private String keyValue;
        private String keyUri;

        public String getKeyValue() {
            return this.keyValue;
        }

        public void setKeyValue(String keyValue) {
            this.keyValue = keyValue;
        }

        public void setKeyUri(String keyUri) {
            this.keyUri = keyUri;
        }

        public String getKeyUri() {
            if (this.keyUri != null) {
                return this.keyUri;
            }
            if (ResourceServerProperties.this.userInfoUri != null && ResourceServerProperties.this.userInfoUri.endsWith("/userinfo")) {
                return ResourceServerProperties.this.userInfoUri.replace("/userinfo", "/token_key");
            }
            if (ResourceServerProperties.this.tokenInfoUri != null && ResourceServerProperties.this.tokenInfoUri.endsWith("/check_token")) {
                return ResourceServerProperties.this.userInfoUri.replace("/check_token", "/token_key");
            }
            return null;
        }
    }
}

