/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.orm.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.jpa")
public class JpaProperties {
    private Map<String, String> properties = new HashMap<String, String>();
    private String databasePlatform;
    private Database database = Database.DEFAULT;
    private boolean generateDdl = false;
    private boolean showSql = false;
    private Hibernate hibernate = new Hibernate();

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getDatabasePlatform() {
        return this.databasePlatform;
    }

    public void setDatabasePlatform(String databasePlatform) {
        this.databasePlatform = databasePlatform;
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public boolean isGenerateDdl() {
        return this.generateDdl;
    }

    public void setGenerateDdl(boolean generateDdl) {
        this.generateDdl = generateDdl;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public Hibernate getHibernate() {
        return this.hibernate;
    }

    public void setHibernate(Hibernate hibernate) {
        this.hibernate = hibernate;
    }

    public Map<String, String> getHibernateProperties(DataSource dataSource) {
        return this.hibernate.getAdditionalProperties(this.properties, dataSource);
    }

    public static class Hibernate {
        private static final String DEFAULT_NAMING_STRATEGY = "org.springframework.boot.orm.jpa.hibernate.SpringNamingStrategy";
        private Class<?> namingStrategy;
        private String ddlAuto;

        public Class<?> getNamingStrategy() {
            return this.namingStrategy;
        }

        public void setNamingStrategy(Class<?> namingStrategy) {
            this.namingStrategy = namingStrategy;
        }

        public String getDdlAuto() {
            return this.ddlAuto;
        }

        public void setDdlAuto(String ddlAuto) {
            this.ddlAuto = ddlAuto;
        }

        private Map<String, String> getAdditionalProperties(Map<String, String> existing, DataSource dataSource) {
            String ddlAuto;
            HashMap<String, String> result = new HashMap<String, String>(existing);
            if (!this.isAlreadyProvided(existing, "ejb.naming_strategy_delegator")) {
                result.put("hibernate.ejb.naming_strategy", this.getHibernateNamingStrategy(existing));
            }
            if (StringUtils.hasText((String)(ddlAuto = this.getOrDeduceDdlAuto(existing, dataSource))) && !"none".equals(ddlAuto)) {
                result.put("hibernate.hbm2ddl.auto", ddlAuto);
            } else {
                result.remove("hibernate.hbm2ddl.auto");
            }
            return result;
        }

        private String getHibernateNamingStrategy(Map<String, String> existing) {
            if (!this.isAlreadyProvided(existing, "ejb.naming_strategy") && this.namingStrategy != null) {
                return this.namingStrategy.getName();
            }
            return DEFAULT_NAMING_STRATEGY;
        }

        private String getOrDeduceDdlAuto(Map<String, String> existing, DataSource dataSource) {
            String ddlAuto;
            String string = ddlAuto = this.ddlAuto != null ? this.ddlAuto : this.getDefaultDdlAuto(dataSource);
            if (!this.isAlreadyProvided(existing, "hbm2ddl.auto") && !"none".equals(ddlAuto)) {
                return ddlAuto;
            }
            if (this.isAlreadyProvided(existing, "hbm2ddl.auto")) {
                return existing.get("hibernate.hbm2ddl.auto");
            }
            return "none";
        }

        private String getDefaultDdlAuto(DataSource dataSource) {
            if (EmbeddedDatabaseConnection.isEmbedded(dataSource)) {
                return "create-drop";
            }
            return "none";
        }

        private boolean isAlreadyProvided(Map<String, String> existing, String key) {
            return existing.containsKey("hibernate." + key);
        }
    }
}

