/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.data.jpa;

import java.util.Arrays;
import java.util.HashSet;
import javax.persistence.EntityManagerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.orm.jpa.AbstractEntityManagerFactoryBean;
import org.springframework.util.StringUtils;

public class EntityManagerFactoryDependsOnPostProcessor
implements BeanFactoryPostProcessor {
    private final String[] dependsOn;

    public EntityManagerFactoryDependsOnPostProcessor(String ... dependsOn) {
        this.dependsOn = dependsOn;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        for (String beanName : this.getEntityManagerFactoryBeanNames((ListableBeanFactory)beanFactory)) {
            BeanDefinition definition = EntityManagerFactoryDependsOnPostProcessor.getBeanDefinition(beanName, beanFactory);
            String[] dependencies = definition.getDependsOn();
            for (String bean : this.dependsOn) {
                dependencies = StringUtils.addStringToArray((String[])dependencies, (String)bean);
            }
            definition.setDependsOn(dependencies);
        }
    }

    private static BeanDefinition getBeanDefinition(String beanName, ConfigurableListableBeanFactory beanFactory) {
        try {
            return beanFactory.getBeanDefinition(beanName);
        }
        catch (NoSuchBeanDefinitionException ex) {
            BeanFactory parentBeanFactory = beanFactory.getParentBeanFactory();
            if (parentBeanFactory instanceof ConfigurableListableBeanFactory) {
                return EntityManagerFactoryDependsOnPostProcessor.getBeanDefinition(beanName, (ConfigurableListableBeanFactory)parentBeanFactory);
            }
            throw ex;
        }
    }

    private Iterable<String> getEntityManagerFactoryBeanNames(ListableBeanFactory beanFactory) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(Arrays.asList(BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, EntityManagerFactory.class, (boolean)true, (boolean)false)));
        for (String factoryBeanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)beanFactory, AbstractEntityManagerFactoryBean.class, (boolean)true, (boolean)false)) {
            names.add(BeanFactoryUtils.transformedBeanName((String)factoryBeanName));
        }
        return names;
    }
}

