/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.cache;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;

abstract class CacheConfigFileCondition
extends SpringBootCondition {
    private final String name;
    private final String configPrefix;
    private final String[] resourceLocations;

    public CacheConfigFileCondition(String name, String configPrefix, String ... resourceLocations) {
        this.name = name;
        this.configPrefix = configPrefix;
        this.resourceLocations = resourceLocations;
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), this.configPrefix);
        if (resolver.containsProperty("config")) {
            return ConditionOutcome.match("A '" + this.configPrefix + ".config' " + "property is specified");
        }
        return this.getResourceOutcome(context, metadata);
    }

    protected ConditionOutcome getResourceOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        for (String location : this.resourceLocations) {
            Resource resource = context.getResourceLoader().getResource(location);
            if (resource == null || !resource.exists()) continue;
            return ConditionOutcome.match("Found " + this.name + " config in " + resource);
        }
        return ConditionOutcome.noMatch("No specific " + this.name + " configuration found");
    }
}

