/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.jdbc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.EmbeddedDataSourceConfiguration;
import org.springframework.boot.autoconfigure.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={EmbeddedDatabaseType.class})
@EnableConfigurationProperties(value={DataSourceProperties.class})
public class DataSourceAutoConfiguration {
    private static Log logger = LogFactory.getLog(DataSourceAutoConfiguration.class);
    public static final String CONFIGURATION_PREFIX = "spring.datasource";
    @Autowired(required=false)
    private DataSource dataSource;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DataSourceProperties properties;

    @PostConstruct
    protected void initialize() {
        boolean initialize = this.properties.isInitialize();
        if (this.dataSource == null || !initialize) {
            logger.debug((Object)"No DataSource found so not initializing");
            return;
        }
        String schema = this.properties.getSchema();
        if (schema == null) {
            String platform = this.properties.getPlatform();
            schema = "classpath*:schema-" + platform + ".sql,";
            schema = schema + "classpath*:schema.sql,";
            schema = schema + "classpath*:data-" + platform + ".sql,";
            schema = schema + "classpath*:data.sql";
        }
        List<Resource> resources = this.getSchemaResources(schema);
        boolean continueOnError = this.properties.isContinueOnError();
        boolean exists = false;
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        for (Resource resource : resources) {
            if (!resource.exists()) continue;
            exists = true;
            populator.addScript(resource);
            populator.setContinueOnError(continueOnError);
        }
        populator.setSeparator(this.properties.getSeparator());
        if (exists) {
            DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
        }
    }

    private List<Resource> getSchemaResources(String schema) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String schemaLocation : StringUtils.commaDelimitedListToStringArray((String)schema)) {
            try {
                resources.addAll(Arrays.asList(this.applicationContext.getResources(schemaLocation)));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to load resource from " + schemaLocation, ex);
            }
        }
        return resources;
    }

    public static boolean containsAutoConfiguredDataSource(ConfigurableListableBeanFactory beanFactory) {
        try {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition("dataSource");
            return EmbeddedDataSourceConfiguration.class.getName().equals(beanDefinition.getFactoryBeanName());
        }
        catch (NoSuchBeanDefinitionException ex) {
            return false;
        }
    }

    static class DatabaseCondition
    extends SpringBootCondition {
        private final SpringBootCondition nonEmbedded = new NonEmbeddedDatabaseCondition();
        private final SpringBootCondition embeddedCondition = new EmbeddedDatabaseCondition();

        DatabaseCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (this.anyMatches(context, metadata, this.nonEmbedded, this.embeddedCondition)) {
                return ConditionOutcome.match("existing auto database detected");
            }
            if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)context.getBeanFactory(), DataSource.class, (boolean)true, (boolean)false).length > 0) {
                return ConditionOutcome.match("Existing bean configured database detected");
            }
            return ConditionOutcome.noMatch("no existing bean configured database");
        }
    }

    static class EmbeddedDatabaseCondition
    extends SpringBootCondition {
        private final SpringBootCondition nonEmbedded = new NonEmbeddedDatabaseCondition();

        EmbeddedDatabaseCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            if (this.anyMatches(context, metadata, this.nonEmbedded)) {
                return ConditionOutcome.noMatch("existing non-embedded database detected");
            }
            EmbeddedDatabaseType type = EmbeddedDatabaseConnection.get(context.getClassLoader()).getType();
            if (type == null) {
                return ConditionOutcome.noMatch("no embedded database detected");
            }
            return ConditionOutcome.match("embedded database " + type + " detected");
        }
    }

    static class NonEmbeddedDatabaseCondition
    extends SpringBootCondition {
        NonEmbeddedDatabaseCondition() {
        }

        @Override
        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ClassLoader dataSourceClassLoader = this.getDataSourceClassLoader(context);
            if (dataSourceClassLoader != null) {
                return ConditionOutcome.match("Supported DataSource class found");
            }
            return ConditionOutcome.noMatch("missing supported DataSource");
        }

        private ClassLoader getDataSourceClassLoader(ConditionContext context) {
            Class<? extends DataSource> dataSourceClass = new DataSourceBuilder(context.getClassLoader()).findType();
            if (dataSourceClass == null) {
                return null;
            }
            return dataSourceClass.getClassLoader();
        }
    }

    @Configuration
    @Conditional(value={DatabaseCondition.class})
    protected static class JdbcTemplateConfiguration {
        @Autowired(required=false)
        private DataSource dataSource;

        protected JdbcTemplateConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={JdbcOperations.class})
        public JdbcTemplate jdbcTemplate() {
            return new JdbcTemplate(this.dataSource);
        }

        @Bean
        @ConditionalOnMissingBean(value={NamedParameterJdbcOperations.class})
        public NamedParameterJdbcTemplate namedParameterJdbcTemplate() {
            return new NamedParameterJdbcTemplate(this.dataSource);
        }
    }

    @Conditional(value={NonEmbeddedDatabaseCondition.class})
    @ConditionalOnMissingBean(value={DataSource.class})
    protected static class NonEmbeddedConfiguration {
        @Autowired
        private DataSourceProperties properties;

        protected NonEmbeddedConfiguration() {
        }

        @ConfigurationProperties(prefix="spring.datasource")
        @Bean
        public DataSource dataSource() {
            DataSourceBuilder factory = DataSourceBuilder.create(this.properties.getClassLoader()).driverClassName(this.properties.getDriverClassName()).url(this.properties.getUrl()).username(this.properties.getUsername()).password(this.properties.getPassword());
            return factory.build();
        }
    }

    @Conditional(value={EmbeddedDatabaseCondition.class})
    @ConditionalOnMissingBean(value={DataSource.class})
    @Import(value={EmbeddedDataSourceConfiguration.class})
    protected static class EmbeddedConfiguration {
        protected EmbeddedConfiguration() {
        }
    }
}

