/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database.builder;

import java.util.Map;
import org.hibernate.SessionFactory;
import org.springframework.batch.item.database.HibernateCursorItemReader;
import org.springframework.batch.item.database.orm.HibernateNativeQueryProvider;
import org.springframework.batch.item.database.orm.HibernateQueryProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HibernateCursorItemReaderBuilder<T> {
    private Map<String, Object> parameterValues;
    private String queryName;
    private int fetchSize;
    private HibernateQueryProvider<T> queryProvider;
    private String queryString;
    private SessionFactory sessionFactory;
    private boolean useStatelessSession;
    private int currentItem;
    private int maxItemCount = Integer.MAX_VALUE;
    private boolean saveState = true;
    private String name;
    private String nativeQuery;
    private Class nativeClass;

    public HibernateCursorItemReaderBuilder<T> name(String name) {
        this.name = name;
        return this;
    }

    public HibernateCursorItemReaderBuilder<T> parameterValues(Map<String, Object> parameterValues) {
        this.parameterValues = parameterValues;
        return this;
    }

    public HibernateCursorItemReaderBuilder<T> queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    public HibernateCursorItemReaderBuilder<T> fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public HibernateCursorItemReaderBuilder<T> queryProvider(HibernateQueryProvider<T> queryProvider) {
        this.queryProvider = queryProvider;
        return this;
    }

    public HibernateCursorItemReaderBuilder<T> queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public HibernateCursorItemReaderBuilder<T> sessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        return this;
    }

    public HibernateCursorItemReaderBuilder<T> useSatelessSession(boolean useStatelessSession) {
        this.useStatelessSession = useStatelessSession;
        return this;
    }

    public HibernateCursorItemReaderBuilder<T> currentItem(int currentItem) {
        this.currentItem = currentItem;
        return this;
    }

    public HibernateCursorItemReaderBuilder<T> maxItemCount(int maxItemCount) {
        this.maxItemCount = maxItemCount;
        return this;
    }

    public HibernateCursorItemReaderBuilder<T> saveState(boolean saveState) {
        this.saveState = saveState;
        return this;
    }

    public HibernateCursorItemReaderBuilder<T> nativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
        return this;
    }

    public HibernateCursorItemReaderBuilder<T> entityClass(Class nativeClass) {
        this.nativeClass = nativeClass;
        return this;
    }

    public HibernateCursorItemReader<T> build() {
        Assert.state((this.fetchSize >= 0 ? 1 : 0) != 0, (String)"fetchSize must not be negative");
        Assert.state((this.sessionFactory != null ? 1 : 0) != 0, (String)"A SessionFactory must be provided");
        if (this.saveState) {
            Assert.state((boolean)StringUtils.hasText((String)this.name), (String)"A name is required when saveState is set to true.");
        }
        HibernateCursorItemReader<Object> reader = new HibernateCursorItemReader<Object>();
        reader.setFetchSize(this.fetchSize);
        reader.setParameterValues(this.parameterValues);
        if (this.queryProvider != null) {
            reader.setQueryProvider(this.queryProvider);
        } else if (StringUtils.hasText((String)this.queryName)) {
            reader.setQueryName(this.queryName);
        } else if (StringUtils.hasText((String)this.queryString)) {
            reader.setQueryString(this.queryString);
        } else if (StringUtils.hasText((String)this.nativeQuery) && this.nativeClass != null) {
            HibernateNativeQueryProvider provider = new HibernateNativeQueryProvider();
            provider.setSqlQuery(this.nativeQuery);
            provider.setEntityClass(this.nativeClass);
            try {
                provider.afterPropertiesSet();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to initialize the HibernateNativeQueryProvider", e);
            }
            reader.setQueryProvider(provider);
        } else {
            throw new IllegalStateException("A HibernateQueryProvider, queryName, queryString, or both the nativeQuery and entityClass must be configured");
        }
        reader.setSessionFactory(this.sessionFactory);
        reader.setUseStatelessSession(this.useStatelessSession);
        reader.setCurrentItemCount(this.currentItem);
        reader.setMaxItemCount(this.maxItemCount);
        reader.setName(this.name);
        reader.setSaveState(this.saveState);
        return reader;
    }
}

