/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.GetResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.AmqpIllegalStateException;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.AmqpMessageReturnedException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.ReceiveAndReplyCallback;
import org.springframework.amqp.core.ReceiveAndReplyMessageCallback;
import org.springframework.amqp.core.ReplyToAddressCallback;
import org.springframework.amqp.rabbit.connection.AbstractRoutingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ChannelProxy;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.PublisherCallbackChannelConnectionFactory;
import org.springframework.amqp.rabbit.connection.RabbitAccessor;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.core.ChannelCallback;
import org.springframework.amqp.rabbit.core.ConsumeOkNotReceivedException;
import org.springframework.amqp.rabbit.core.CorrelationDataPostProcessor;
import org.springframework.amqp.rabbit.core.RabbitOperations;
import org.springframework.amqp.rabbit.listener.AbstractMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.DirectReplyToMessageListenerContainer;
import org.springframework.amqp.rabbit.support.ConsumerCancelledException;
import org.springframework.amqp.rabbit.support.CorrelationData;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.Delivery;
import org.springframework.amqp.rabbit.support.ListenerContainerAware;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.amqp.rabbit.support.PendingConfirm;
import org.springframework.amqp.rabbit.support.PublisherCallbackChannel;
import org.springframework.amqp.rabbit.support.RabbitExceptionTranslator;
import org.springframework.amqp.rabbit.support.ValueExpression;
import org.springframework.amqp.support.Correlation;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.converter.SimpleMessageConverter;
import org.springframework.amqp.support.converter.SmartMessageConverter;
import org.springframework.amqp.support.postprocessor.MessagePostProcessorUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.context.Lifecycle;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RabbitTemplate
extends RabbitAccessor
implements BeanFactoryAware,
RabbitOperations,
MessageListener,
ListenerContainerAware,
PublisherCallbackChannel.Listener,
Lifecycle,
BeanNameAware {
    private static final String RETURN_CORRELATION_KEY = "spring_request_return_correlation";
    private static final String DEFAULT_EXCHANGE = "";
    private static final String DEFAULT_ROUTING_KEY = "";
    private static final long DEFAULT_REPLY_TIMEOUT = 5000L;
    private static final long DEFAULT_CONSUME_TIMEOUT = 10000L;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private final ThreadLocal<Channel> dedicatedChannels = new ThreadLocal();
    private final AtomicInteger activeTemplateCallbacks = new AtomicInteger();
    private final ConcurrentMap<Channel, RabbitTemplate> publisherConfirmChannels = new ConcurrentHashMap<Channel, RabbitTemplate>();
    private final Map<String, PendingReply> replyHolder = new ConcurrentHashMap<String, PendingReply>();
    private final String uuid = UUID.randomUUID().toString();
    private final AtomicInteger messageTagProvider = new AtomicInteger();
    private final StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
    private final ReplyToAddressCallback<?> defaultReplyToAddressCallback = (request, reply) -> this.getReplyToAddress(request);
    private final Map<ConnectionFactory, DirectReplyToMessageListenerContainer> directReplyToContainers = new HashMap<ConnectionFactory, DirectReplyToMessageListenerContainer>();
    private final AtomicInteger containerInstance = new AtomicInteger();
    private volatile String exchange = "";
    private volatile String routingKey = "";
    private volatile String queue;
    private volatile long receiveTimeout = 0L;
    private volatile long replyTimeout = 5000L;
    private volatile MessageConverter messageConverter = new SimpleMessageConverter();
    private volatile MessagePropertiesConverter messagePropertiesConverter = new DefaultMessagePropertiesConverter();
    private volatile String encoding = "UTF-8";
    private volatile String replyAddress;
    private volatile ConfirmCallback confirmCallback;
    private volatile ReturnCallback returnCallback;
    private volatile Boolean confirmsOrReturnsCapable;
    private volatile Expression mandatoryExpression = new ValueExpression<Boolean>(false);
    private volatile String correlationKey = null;
    private volatile RetryTemplate retryTemplate;
    private volatile RecoveryCallback<?> recoveryCallback;
    private volatile Expression sendConnectionFactorySelectorExpression;
    private volatile Expression receiveConnectionFactorySelectorExpression;
    private volatile boolean usingFastReplyTo;
    private volatile boolean useDirectReplyToContainer = true;
    private volatile boolean evaluatedFastReplyTo;
    private volatile boolean useTemporaryReplyQueues;
    private volatile Collection<MessagePostProcessor> beforePublishPostProcessors;
    private volatile Collection<MessagePostProcessor> afterReceivePostProcessors;
    private volatile CorrelationDataPostProcessor correlationDataPostProcessor;
    private volatile boolean isListener;
    private volatile Expression userIdExpression;
    private String beanName = "rabbitTemplate";
    private Executor taskExecutor;

    public RabbitTemplate() {
        this.initDefaultStrategies();
    }

    public RabbitTemplate(ConnectionFactory connectionFactory) {
        this.setConnectionFactory(connectionFactory);
    }

    protected void initDefaultStrategies() {
        this.setMessageConverter((MessageConverter)new SimpleMessageConverter());
    }

    public void setExchange(String exchange) {
        this.exchange = exchange != null ? exchange : "";
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setRoutingKey(String routingKey) {
        this.routingKey = routingKey;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setReplyAddress(String replyAddress) {
        this.replyAddress = replyAddress;
        this.evaluatedFastReplyTo = false;
    }

    public void setReceiveTimeout(long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setReplyTimeout(long replyTimeout) {
        this.replyTimeout = replyTimeout;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setMessagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        Assert.notNull((Object)messagePropertiesConverter, (String)"messagePropertiesConverter must not be null");
        this.messagePropertiesConverter = messagePropertiesConverter;
    }

    protected MessagePropertiesConverter getMessagePropertiesConverter() {
        return this.messagePropertiesConverter;
    }

    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setConfirmCallback(ConfirmCallback confirmCallback) {
        Assert.state((this.confirmCallback == null || this.confirmCallback == confirmCallback ? 1 : 0) != 0, (String)"Only one ConfirmCallback is supported by each RabbitTemplate");
        this.confirmCallback = confirmCallback;
    }

    public void setReturnCallback(ReturnCallback returnCallback) {
        Assert.state((this.returnCallback == null || this.returnCallback == returnCallback ? 1 : 0) != 0, (String)"Only one ReturnCallback is supported by each RabbitTemplate");
        this.returnCallback = returnCallback;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatoryExpression = new ValueExpression<Boolean>(mandatory);
    }

    public void setMandatoryExpression(Expression mandatoryExpression) {
        Assert.notNull((Object)mandatoryExpression, (String)"'mandatoryExpression' must not be null");
        this.mandatoryExpression = mandatoryExpression;
    }

    public void setMandatoryExpressionString(String mandatoryExpression) {
        Assert.notNull((Object)mandatoryExpression, (String)"'mandatoryExpression' must not be null");
        this.mandatoryExpression = PARSER.parseExpression(mandatoryExpression);
    }

    public void setSendConnectionFactorySelectorExpression(Expression sendConnectionFactorySelectorExpression) {
        this.sendConnectionFactorySelectorExpression = sendConnectionFactorySelectorExpression;
    }

    public void setReceiveConnectionFactorySelectorExpression(Expression receiveConnectionFactorySelectorExpression) {
        this.receiveConnectionFactorySelectorExpression = receiveConnectionFactorySelectorExpression;
    }

    public void setCorrelationKey(String correlationKey) {
        Assert.hasText((String)correlationKey, (String)"'correlationKey' must not be null or empty");
        if (!correlationKey.trim().equals("correlationId")) {
            this.correlationKey = correlationKey.trim();
        }
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<?> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        this.evaluationContext.addPropertyAccessor((PropertyAccessor)new MapAccessor());
    }

    public void setBeforePublishPostProcessors(MessagePostProcessor ... beforePublishPostProcessors) {
        Assert.notNull((Object)beforePublishPostProcessors, (String)"'beforePublishPostProcessors' cannot be null");
        Assert.noNullElements((Object[])beforePublishPostProcessors, (String)"'beforePublishPostProcessors' cannot have null elements");
        this.beforePublishPostProcessors = MessagePostProcessorUtils.sort(Arrays.asList(beforePublishPostProcessors));
    }

    public void setAfterReceivePostProcessors(MessagePostProcessor ... afterReceivePostProcessors) {
        Assert.notNull((Object)afterReceivePostProcessors, (String)"'afterReceivePostProcessors' cannot be null");
        Assert.noNullElements((Object[])afterReceivePostProcessors, (String)"'afterReceivePostProcessors' cannot have null elements");
        this.afterReceivePostProcessors = MessagePostProcessorUtils.sort(Arrays.asList(afterReceivePostProcessors));
    }

    public void setCorrelationDataPostProcessor(CorrelationDataPostProcessor correlationDataPostProcessor) {
        this.correlationDataPostProcessor = correlationDataPostProcessor;
    }

    public void setUseTemporaryReplyQueues(boolean value) {
        this.useTemporaryReplyQueues = value;
    }

    public void setUseDirectReplyToContainer(boolean useDirectReplyToContainer) {
        this.useDirectReplyToContainer = useDirectReplyToContainer;
    }

    public void setUserIdExpression(Expression userIdExpression) {
        this.userIdExpression = userIdExpression;
    }

    public void setUserIdExpressionString(String userIdExpression) {
        this.userIdExpression = PARSER.parseExpression(userIdExpression);
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @Override
    public Collection<String> expectedQueueNames() {
        this.isListener = true;
        List<String> replyQueue = null;
        if (this.replyAddress == null || this.replyAddress.equals("amq.rabbitmq.reply-to")) {
            throw new IllegalStateException("A listener container must not be provided when using direct reply-to");
        }
        Address address = new Address(this.replyAddress);
        if ("".equals(address.getExchangeName())) {
            replyQueue = Collections.singletonList(address.getRoutingKey());
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Cannot verify reply queue because 'replyAddress' is not a simple queue name: " + this.replyAddress));
        }
        return replyQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CorrelationData> getUnconfirmed(long age) {
        HashSet<CorrelationData> unconfirmed = new HashSet<CorrelationData>();
        ConcurrentMap<Channel, RabbitTemplate> concurrentMap = this.publisherConfirmChannels;
        synchronized (concurrentMap) {
            long cutoffTime = System.currentTimeMillis() - age;
            for (Channel channel : this.publisherConfirmChannels.keySet()) {
                Collection<PendingConfirm> confirms = ((PublisherCallbackChannel)channel).expire(this, cutoffTime);
                for (PendingConfirm confirm : confirms) {
                    unconfirmed.add(confirm.getCorrelationData());
                }
            }
        }
        return unconfirmed.size() > 0 ? unconfirmed : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnconfirmedCount() {
        ConcurrentMap<Channel, RabbitTemplate> concurrentMap = this.publisherConfirmChannels;
        synchronized (concurrentMap) {
            return this.publisherConfirmChannels.keySet().stream().mapToInt(channel -> ((PublisherCallbackChannel)channel).getPendingConfirmsCount(this)).sum();
        }
    }

    public final void start() {
        this.doStart();
    }

    protected void doStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Map<ConnectionFactory, DirectReplyToMessageListenerContainer> map = this.directReplyToContainers;
        synchronized (map) {
            this.directReplyToContainers.values().stream().filter(AbstractMessageListenerContainer::isRunning).forEach(AbstractMessageListenerContainer::stop);
            this.directReplyToContainers.clear();
        }
        this.doStop();
    }

    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Map<ConnectionFactory, DirectReplyToMessageListenerContainer> map = this.directReplyToContainers;
        synchronized (map) {
            Map<ConnectionFactory, DirectReplyToMessageListenerContainer> map2 = this.directReplyToContainers;
            synchronized (map2) {
                return this.directReplyToContainers.values().stream().anyMatch(AbstractMessageListenerContainer::isRunning);
            }
        }
    }

    private void evaluateFastReplyTo() {
        this.usingFastReplyTo = this.useDirectReplyTo();
        this.evaluatedFastReplyTo = true;
    }

    protected boolean useDirectReplyTo() {
        if (this.useTemporaryReplyQueues) {
            if (this.replyAddress != null) {
                this.logger.warn((Object)"'useTemporaryReplyQueues' is ignored when a 'replyAddress' is provided");
            } else {
                return false;
            }
        }
        if (this.replyAddress == null || "amq.rabbitmq.reply-to".equals(this.replyAddress)) {
            try {
                this.execute(channel -> {
                    channel.queueDeclarePassive("amq.rabbitmq.reply-to");
                    return null;
                });
                return true;
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn((Object)("Broker does not support fast replies via 'amq.rabbitmq.reply-to', temporary queues will be used:" + e.getMessage() + "."));
                }
                this.replyAddress = null;
            }
        }
        return false;
    }

    public void send(Message message) throws AmqpException {
        this.send(this.exchange, this.routingKey, message);
    }

    public void send(String routingKey, Message message) throws AmqpException {
        this.send(this.exchange, routingKey, message);
    }

    public void send(String exchange, String routingKey, Message message) throws AmqpException {
        this.send(exchange, routingKey, message, null);
    }

    @Override
    public void send(String exchange, String routingKey, Message message, CorrelationData correlationData) throws AmqpException {
        this.execute(channel -> {
            this.doSend(channel, exchange, routingKey, message, this.returnCallback != null && (Boolean)this.mandatoryExpression.getValue((EvaluationContext)this.evaluationContext, (Object)message, Boolean.class) != false, correlationData);
            return null;
        }, this.obtainTargetConnectionFactory(this.sendConnectionFactorySelectorExpression, message));
    }

    private ConnectionFactory obtainTargetConnectionFactory(Expression expression, Object rootObject) {
        if (expression != null && this.getConnectionFactory() instanceof AbstractRoutingConnectionFactory) {
            AbstractRoutingConnectionFactory routingConnectionFactory = (AbstractRoutingConnectionFactory)this.getConnectionFactory();
            Object lookupKey = rootObject != null ? this.sendConnectionFactorySelectorExpression.getValue((EvaluationContext)this.evaluationContext, rootObject) : this.sendConnectionFactorySelectorExpression.getValue((EvaluationContext)this.evaluationContext);
            if (lookupKey != null) {
                ConnectionFactory connectionFactory = routingConnectionFactory.getTargetConnectionFactory(lookupKey);
                if (connectionFactory != null) {
                    return connectionFactory;
                }
                if (!routingConnectionFactory.isLenientFallback()) {
                    throw new IllegalStateException("Cannot determine target ConnectionFactory for lookup key [" + lookupKey + "]");
                }
            }
        }
        return this.getConnectionFactory();
    }

    public void convertAndSend(Object object) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, object, (CorrelationData)null);
    }

    @Override
    public void correlationConvertAndSend(Object object, CorrelationData correlationData) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, object, correlationData);
    }

    public void convertAndSend(String routingKey, Object object) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, object, (CorrelationData)null);
    }

    @Override
    public void convertAndSend(String routingKey, Object object, CorrelationData correlationData) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, object, correlationData);
    }

    public void convertAndSend(String exchange, String routingKey, Object object) throws AmqpException {
        this.convertAndSend(exchange, routingKey, object, (CorrelationData)null);
    }

    @Override
    public void convertAndSend(String exchange, String routingKey, Object object, CorrelationData correlationData) throws AmqpException {
        this.send(exchange, routingKey, this.convertMessageIfNecessary(object), correlationData);
    }

    public void convertAndSend(Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, message, messagePostProcessor);
    }

    public void convertAndSend(String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, message, messagePostProcessor, null);
    }

    @Override
    public void convertAndSend(Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) throws AmqpException {
        this.convertAndSend(this.exchange, this.routingKey, message, messagePostProcessor, correlationData);
    }

    @Override
    public void convertAndSend(String routingKey, Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) throws AmqpException {
        this.convertAndSend(this.exchange, routingKey, message, messagePostProcessor, correlationData);
    }

    public void convertAndSend(String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        this.convertAndSend(exchange, routingKey, message, messagePostProcessor, null);
    }

    @Override
    public void convertAndSend(String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) throws AmqpException {
        Message messageToSend = this.convertMessageIfNecessary(message);
        messageToSend = messagePostProcessor.postProcessMessage(messageToSend, (Correlation)correlationData);
        this.send(exchange, routingKey, messageToSend, correlationData);
    }

    public Message receive() throws AmqpException {
        String queue = this.getRequiredQueue();
        return this.receive(queue);
    }

    public Message receive(String queueName) {
        if (this.receiveTimeout == 0L) {
            return this.doReceiveNoWait(queueName);
        }
        return this.receive(queueName, this.receiveTimeout);
    }

    protected Message doReceiveNoWait(String queueName) {
        Message message = this.execute(channel -> {
            GetResponse response = channel.basicGet(queueName, !this.isChannelTransacted());
            if (response != null) {
                long deliveryTag = response.getEnvelope().getDeliveryTag();
                if (this.isChannelLocallyTransacted(channel)) {
                    channel.basicAck(deliveryTag, false);
                    channel.txCommit();
                } else if (this.isChannelTransacted()) {
                    ConnectionFactoryUtils.registerDeliveryTag(this.getConnectionFactory(), channel, deliveryTag);
                }
                return this.buildMessageFromResponse(response);
            }
            return null;
        }, this.obtainTargetConnectionFactory(this.receiveConnectionFactorySelectorExpression, queueName));
        this.logReceived(message);
        return message;
    }

    public Message receive(long timeoutMillis) throws AmqpException {
        String queue = this.getRequiredQueue();
        if (timeoutMillis == 0L) {
            return this.doReceiveNoWait(queue);
        }
        return this.receive(queue, timeoutMillis);
    }

    public Message receive(String queueName, long timeoutMillis) {
        Message message = this.execute(channel -> {
            Delivery delivery = this.consumeDelivery(channel, queueName, timeoutMillis);
            if (delivery == null) {
                return null;
            }
            if (this.isChannelLocallyTransacted(channel)) {
                channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
                channel.txCommit();
            } else if (this.isChannelTransacted()) {
                ConnectionFactoryUtils.registerDeliveryTag(this.getConnectionFactory(), channel, delivery.getEnvelope().getDeliveryTag());
            } else {
                channel.basicAck(delivery.getEnvelope().getDeliveryTag(), false);
            }
            return this.buildMessageFromDelivery(delivery);
        });
        this.logReceived(message);
        return message;
    }

    public Object receiveAndConvert() throws AmqpException {
        return this.receiveAndConvert(this.getRequiredQueue());
    }

    public Object receiveAndConvert(String queueName) throws AmqpException {
        return this.receiveAndConvert(queueName, this.receiveTimeout);
    }

    public Object receiveAndConvert(long timeoutMillis) throws AmqpException {
        return this.receiveAndConvert(this.getRequiredQueue(), timeoutMillis);
    }

    public Object receiveAndConvert(String queueName, long timeoutMillis) throws AmqpException {
        Message response;
        Message message = response = timeoutMillis == 0L ? this.doReceiveNoWait(queueName) : this.receive(queueName, timeoutMillis);
        if (response != null) {
            return this.getRequiredMessageConverter().fromMessage(response);
        }
        return null;
    }

    public <T> T receiveAndConvert(ParameterizedTypeReference<T> type) throws AmqpException {
        return this.receiveAndConvert(this.getRequiredQueue(), type);
    }

    public <T> T receiveAndConvert(String queueName, ParameterizedTypeReference<T> type) throws AmqpException {
        return this.receiveAndConvert(queueName, this.receiveTimeout, type);
    }

    public <T> T receiveAndConvert(long timeoutMillis, ParameterizedTypeReference<T> type) throws AmqpException {
        return this.receiveAndConvert(this.getRequiredQueue(), timeoutMillis, type);
    }

    public <T> T receiveAndConvert(String queueName, long timeoutMillis, ParameterizedTypeReference<T> type) throws AmqpException {
        Message response;
        Message message = response = timeoutMillis == 0L ? this.doReceiveNoWait(queueName) : this.receive(queueName, timeoutMillis);
        if (response != null) {
            return (T)this.getRequiredSmartMessageConverter().fromMessage(response, type);
        }
        return null;
    }

    public <R, S> boolean receiveAndReply(ReceiveAndReplyCallback<R, S> callback) throws AmqpException {
        return this.receiveAndReply(this.getRequiredQueue(), callback);
    }

    public <R, S> boolean receiveAndReply(String queueName, ReceiveAndReplyCallback<R, S> callback) throws AmqpException {
        return this.receiveAndReply(queueName, callback, this.defaultReplyToAddressCallback);
    }

    public <R, S> boolean receiveAndReply(ReceiveAndReplyCallback<R, S> callback, String exchange, String routingKey) throws AmqpException {
        return this.receiveAndReply(this.getRequiredQueue(), callback, exchange, routingKey);
    }

    public <R, S> boolean receiveAndReply(String queueName, ReceiveAndReplyCallback<R, S> callback, String replyExchange, String replyRoutingKey) throws AmqpException {
        return this.receiveAndReply(queueName, callback, (request, reply) -> new Address(replyExchange, replyRoutingKey));
    }

    public <R, S> boolean receiveAndReply(ReceiveAndReplyCallback<R, S> callback, ReplyToAddressCallback<S> replyToAddressCallback) throws AmqpException {
        return this.receiveAndReply(this.getRequiredQueue(), callback, replyToAddressCallback);
    }

    public <R, S> boolean receiveAndReply(String queueName, ReceiveAndReplyCallback<R, S> callback, ReplyToAddressCallback<S> replyToAddressCallback) throws AmqpException {
        return this.doReceiveAndReply(queueName, callback, replyToAddressCallback);
    }

    private <R, S> boolean doReceiveAndReply(String queueName, ReceiveAndReplyCallback<R, S> callback, ReplyToAddressCallback<S> replyToAddressCallback) throws AmqpException {
        return this.execute(channel -> {
            Message receiveMessage = null;
            if ((receiveMessage = this.receiveForReply(queueName, channel, receiveMessage)) != null) {
                return this.sendReply(callback, replyToAddressCallback, channel, receiveMessage);
            }
            return false;
        }, this.obtainTargetConnectionFactory(this.receiveConnectionFactorySelectorExpression, queueName));
    }

    private Message receiveForReply(String queueName, Channel channel, Message receiveMessage) throws Exception {
        boolean channelTransacted = this.isChannelTransacted();
        boolean channelLocallyTransacted = this.isChannelLocallyTransacted(channel);
        if (this.receiveTimeout == 0L) {
            GetResponse response = channel.basicGet(queueName, !channelTransacted);
            if (response != null) {
                long deliveryTag1 = response.getEnvelope().getDeliveryTag();
                if (channelLocallyTransacted) {
                    channel.basicAck(deliveryTag1, false);
                } else if (channelTransacted) {
                    ConnectionFactoryUtils.registerDeliveryTag(this.getConnectionFactory(), channel, deliveryTag1);
                }
                receiveMessage = this.buildMessageFromResponse(response);
            }
        } else {
            Delivery delivery = this.consumeDelivery(channel, queueName, this.receiveTimeout);
            if (delivery != null) {
                long deliveryTag2 = delivery.getEnvelope().getDeliveryTag();
                if (channelTransacted && !channelLocallyTransacted) {
                    ConnectionFactoryUtils.registerDeliveryTag(this.getConnectionFactory(), channel, deliveryTag2);
                } else {
                    channel.basicAck(deliveryTag2, false);
                }
                receiveMessage = this.buildMessageFromDelivery(delivery);
            }
        }
        this.logReceived(receiveMessage);
        return receiveMessage;
    }

    private Delivery consumeDelivery(Channel channel, String queueName, long timeoutMillis) throws Exception {
        Throwable exception;
        Delivery delivery;
        block10: {
            delivery = null;
            exception = null;
            CompletableFuture<Delivery> future = new CompletableFuture<Delivery>();
            DefaultConsumer consumer = this.createConsumer(queueName, channel, future, timeoutMillis < 0L ? 10000L : timeoutMillis);
            try {
                delivery = timeoutMillis < 0L ? future.get() : future.get(timeoutMillis, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                this.logger.error((Object)("Consumer failed to receive message: " + consumer), e.getCause());
                exception = e.getCause();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
                // empty catch block
            }
            try {
                if (exception == null || !(exception instanceof ConsumerCancelledException)) {
                    channel.basicCancel(consumer.getConsumerTag());
                }
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block10;
                this.logger.debug((Object)("Failed to cancel consumer: " + consumer), (Throwable)e);
            }
        }
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof Error) {
                throw (Error)exception;
            }
            throw new AmqpException(exception);
        }
        return delivery;
    }

    private void logReceived(Message message) {
        if (this.logger.isDebugEnabled()) {
            if (message == null) {
                this.logger.debug((Object)"Received no message");
            } else {
                this.logger.debug((Object)("Received: " + message));
            }
        }
    }

    private <R, S> Boolean sendReply(ReceiveAndReplyCallback<R, S> callback, ReplyToAddressCallback<S> replyToAddressCallback, Channel channel, Message receiveMessage) throws Exception {
        Object reply;
        Object receive = receiveMessage;
        if (!ReceiveAndReplyMessageCallback.class.isAssignableFrom(callback.getClass())) {
            receive = this.getRequiredMessageConverter().fromMessage(receiveMessage);
        }
        try {
            reply = callback.handle(receive);
        }
        catch (ClassCastException e) {
            StackTraceElement[] trace = e.getStackTrace();
            if (trace[0].getMethodName().equals("handle") && trace[1].getFileName().equals("RabbitTemplate.java")) {
                throw new IllegalArgumentException("ReceiveAndReplyCallback '" + callback + "' can't handle received object '" + receive + "'", e);
            }
            throw e;
        }
        if (reply != null) {
            String correlation;
            Address replyTo = replyToAddressCallback.getReplyToAddress(receiveMessage, reply);
            Message replyMessage = this.convertMessageIfNecessary(reply);
            MessageProperties receiveMessageProperties = receiveMessage.getMessageProperties();
            MessageProperties replyMessageProperties = replyMessage.getMessageProperties();
            String string = correlation = this.correlationKey == null ? receiveMessageProperties.getCorrelationId() : receiveMessageProperties.getHeaders().get(this.correlationKey);
            if (this.correlationKey == null || correlation == null) {
                String messageId;
                if (correlation == null && (messageId = receiveMessageProperties.getMessageId()) != null) {
                    correlation = messageId;
                }
                replyMessageProperties.setCorrelationId(correlation);
            } else {
                replyMessageProperties.setHeader(this.correlationKey, (Object)correlation);
            }
            this.doSend(channel, replyTo.getExchangeName(), replyTo.getRoutingKey(), replyMessage, this.returnCallback != null && this.isMandatoryFor(replyMessage) != false, null);
        } else if (this.isChannelLocallyTransacted(channel)) {
            channel.txCommit();
        }
        return true;
    }

    public Message sendAndReceive(Message message) throws AmqpException {
        return this.sendAndReceive(message, null);
    }

    public Message sendAndReceive(Message message, CorrelationData correlationData) throws AmqpException {
        return this.doSendAndReceive(this.exchange, this.routingKey, message, correlationData);
    }

    public Message sendAndReceive(String routingKey, Message message) throws AmqpException {
        return this.sendAndReceive(routingKey, message, null);
    }

    public Message sendAndReceive(String routingKey, Message message, CorrelationData correlationData) throws AmqpException {
        return this.doSendAndReceive(this.exchange, routingKey, message, correlationData);
    }

    public Message sendAndReceive(String exchange, String routingKey, Message message) throws AmqpException {
        return this.sendAndReceive(exchange, routingKey, message, null);
    }

    public Message sendAndReceive(String exchange, String routingKey, Message message, CorrelationData correlationData) throws AmqpException {
        return this.doSendAndReceive(exchange, routingKey, message, correlationData);
    }

    public Object convertSendAndReceive(Object message) throws AmqpException {
        return this.convertSendAndReceive(message, (CorrelationData)null);
    }

    @Override
    public Object convertSendAndReceive(Object message, CorrelationData correlationData) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, this.routingKey, message, null, correlationData);
    }

    public Object convertSendAndReceive(String routingKey, Object message) throws AmqpException {
        return this.convertSendAndReceive(routingKey, message, (CorrelationData)null);
    }

    @Override
    public Object convertSendAndReceive(String routingKey, Object message, CorrelationData correlationData) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, routingKey, message, null, correlationData);
    }

    public Object convertSendAndReceive(String exchange, String routingKey, Object message) throws AmqpException {
        return this.convertSendAndReceive(exchange, routingKey, message, (CorrelationData)null);
    }

    @Override
    public Object convertSendAndReceive(String exchange, String routingKey, Object message, CorrelationData correlationData) throws AmqpException {
        return this.convertSendAndReceive(exchange, routingKey, message, null, correlationData);
    }

    public Object convertSendAndReceive(Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        return this.convertSendAndReceive(message, messagePostProcessor, null);
    }

    @Override
    public Object convertSendAndReceive(Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, this.routingKey, message, messagePostProcessor, correlationData);
    }

    public Object convertSendAndReceive(String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        return this.convertSendAndReceive(routingKey, message, messagePostProcessor, null);
    }

    @Override
    public Object convertSendAndReceive(String routingKey, Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) throws AmqpException {
        return this.convertSendAndReceive(this.exchange, routingKey, message, messagePostProcessor, correlationData);
    }

    public Object convertSendAndReceive(String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor) throws AmqpException {
        return this.convertSendAndReceive(exchange, routingKey, message, messagePostProcessor, null);
    }

    @Override
    public Object convertSendAndReceive(String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) throws AmqpException {
        Message replyMessage = this.convertSendAndReceiveRaw(exchange, routingKey, message, messagePostProcessor, correlationData);
        if (replyMessage == null) {
            return null;
        }
        return this.getRequiredMessageConverter().fromMessage(replyMessage);
    }

    public <T> T convertSendAndReceiveAsType(Object message, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(message, (CorrelationData)null, responseType);
    }

    @Override
    public <T> T convertSendAndReceiveAsType(Object message, CorrelationData correlationData, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(this.exchange, this.routingKey, message, null, correlationData, responseType);
    }

    public <T> T convertSendAndReceiveAsType(String routingKey, Object message, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(routingKey, message, (CorrelationData)null, responseType);
    }

    @Override
    public <T> T convertSendAndReceiveAsType(String routingKey, Object message, CorrelationData correlationData, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(this.exchange, routingKey, message, null, correlationData, responseType);
    }

    public <T> T convertSendAndReceiveAsType(String exchange, String routingKey, Object message, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(exchange, routingKey, message, (CorrelationData)null, responseType);
    }

    @Override
    public <T> T convertSendAndReceiveAsType(String exchange, String routingKey, Object message, CorrelationData correlationData, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(exchange, routingKey, message, null, correlationData, responseType);
    }

    public <T> T convertSendAndReceiveAsType(Object message, MessagePostProcessor messagePostProcessor, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(message, messagePostProcessor, null, responseType);
    }

    @Override
    public <T> T convertSendAndReceiveAsType(Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(this.exchange, this.routingKey, message, messagePostProcessor, correlationData, responseType);
    }

    public <T> T convertSendAndReceiveAsType(String routingKey, Object message, MessagePostProcessor messagePostProcessor, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(routingKey, message, messagePostProcessor, null, responseType);
    }

    @Override
    public <T> T convertSendAndReceiveAsType(String routingKey, Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(this.exchange, routingKey, message, messagePostProcessor, correlationData, responseType);
    }

    public <T> T convertSendAndReceiveAsType(String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor, ParameterizedTypeReference<T> responseType) throws AmqpException {
        return this.convertSendAndReceiveAsType(exchange, routingKey, message, messagePostProcessor, null, responseType);
    }

    @Override
    public <T> T convertSendAndReceiveAsType(String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData, ParameterizedTypeReference<T> responseType) throws AmqpException {
        Message replyMessage = this.convertSendAndReceiveRaw(exchange, routingKey, message, messagePostProcessor, correlationData);
        if (replyMessage == null) {
            return null;
        }
        return (T)this.getRequiredSmartMessageConverter().fromMessage(replyMessage, responseType);
    }

    protected Message convertSendAndReceiveRaw(String exchange, String routingKey, Object message, MessagePostProcessor messagePostProcessor, CorrelationData correlationData) {
        Message requestMessage = this.convertMessageIfNecessary(message);
        if (messagePostProcessor != null) {
            requestMessage = messagePostProcessor.postProcessMessage(requestMessage, (Correlation)correlationData);
        }
        Message replyMessage = this.doSendAndReceive(exchange, routingKey, requestMessage, correlationData);
        return replyMessage;
    }

    protected Message convertMessageIfNecessary(Object object) {
        if (object instanceof Message) {
            return (Message)object;
        }
        return this.getRequiredMessageConverter().toMessage(object, new MessageProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Message doSendAndReceive(String exchange, String routingKey, Message message, CorrelationData correlationData) {
        if (!this.evaluatedFastReplyTo) {
            RabbitTemplate rabbitTemplate = this;
            synchronized (rabbitTemplate) {
                if (!this.evaluatedFastReplyTo) {
                    this.evaluateFastReplyTo();
                }
            }
        }
        if (this.usingFastReplyTo && this.useDirectReplyToContainer) {
            return this.doSendAndReceiveWithDirect(exchange, routingKey, message, correlationData);
        }
        if (this.replyAddress == null || this.usingFastReplyTo) {
            return this.doSendAndReceiveWithTemporary(exchange, routingKey, message, correlationData);
        }
        return this.doSendAndReceiveWithFixed(exchange, routingKey, message, correlationData);
    }

    protected Message doSendAndReceiveWithTemporary(String exchange, String routingKey, Message message, CorrelationData correlationData) {
        return this.execute(channel -> {
            String replyTo;
            final PendingReply pendingReply = new PendingReply();
            String messageTag = String.valueOf(this.messageTagProvider.incrementAndGet());
            this.replyHolder.put(messageTag, pendingReply);
            Assert.isNull((Object)message.getMessageProperties().getReplyTo(), (String)"Send-and-receive methods can only be used if the Message does not already have a replyTo property.");
            if (this.usingFastReplyTo) {
                replyTo = "amq.rabbitmq.reply-to";
            } else {
                AMQP.Queue.DeclareOk queueDeclaration = channel.queueDeclare();
                replyTo = queueDeclaration.getQueue();
            }
            message.getMessageProperties().setReplyTo(replyTo);
            String consumerTag = UUID.randomUUID().toString();
            TemplateConsumer consumer = new TemplateConsumer(channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    MessageProperties messageProperties = RabbitTemplate.this.messagePropertiesConverter.toMessageProperties(properties, envelope, RabbitTemplate.this.encoding);
                    Message reply = new Message(body, messageProperties);
                    if (RabbitTemplate.this.logger.isTraceEnabled()) {
                        RabbitTemplate.this.logger.trace((Object)("Message received " + reply));
                    }
                    pendingReply.reply(reply);
                }
            };
            channel.basicConsume(replyTo, true, consumerTag, true, true, null, (Consumer)consumer);
            Message reply = null;
            try {
                reply = this.exchangeMessages(exchange, routingKey, message, correlationData, channel, pendingReply, messageTag);
            }
            finally {
                this.replyHolder.remove(messageTag);
                try {
                    channel.basicCancel(consumerTag);
                }
                catch (Exception exception) {}
            }
            return reply;
        }, this.obtainTargetConnectionFactory(this.sendConnectionFactorySelectorExpression, message));
    }

    protected Message doSendAndReceiveWithFixed(String exchange, String routingKey, Message message, CorrelationData correlationData) {
        Assert.state((boolean)this.isListener, () -> "RabbitTemplate is not configured as MessageListener - cannot use a 'replyAddress': " + this.replyAddress);
        return this.execute(channel -> this.doSendAndReceiveAsListener(exchange, routingKey, message, correlationData, channel), this.obtainTargetConnectionFactory(this.sendConnectionFactorySelectorExpression, message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doSendAndReceiveWithDirect(String exchange, String routingKey, Message message, CorrelationData correlationData) {
        ConnectionFactory connectionFactory = this.obtainTargetConnectionFactory(this.sendConnectionFactorySelectorExpression, message);
        DirectReplyToMessageListenerContainer container = this.directReplyToContainers.get(connectionFactory);
        if (container == null) {
            Map<ConnectionFactory, DirectReplyToMessageListenerContainer> map = this.directReplyToContainers;
            synchronized (map) {
                container = this.directReplyToContainers.get(connectionFactory);
                if (container == null) {
                    container = new DirectReplyToMessageListenerContainer(connectionFactory);
                    container.setMessageListener(this);
                    container.setBeanName(this.beanName + "#" + this.containerInstance.getAndIncrement());
                    if (this.taskExecutor != null) {
                        container.setTaskExecutor(this.taskExecutor);
                    }
                    container.start();
                    this.directReplyToContainers.put(connectionFactory, container);
                    this.replyAddress = "amq.rabbitmq.reply-to";
                }
            }
        }
        DirectReplyToMessageListenerContainer.ChannelHolder channelHolder = container.getChannelHolder();
        try {
            return this.doSendAndReceiveAsListener(exchange, routingKey, message, correlationData, channelHolder.getChannel());
        }
        catch (Exception e) {
            container.releaseConsumerFor(channelHolder, false, null);
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doSendAndReceiveAsListener(String exchange, String routingKey, Message message, CorrelationData correlationData, Channel channel) throws Exception {
        PendingReply pendingReply = new PendingReply();
        String messageTag = String.valueOf(this.messageTagProvider.incrementAndGet());
        this.replyHolder.put(messageTag, pendingReply);
        this.saveAndSetProperties(message, pendingReply, messageTag);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Sending message with tag " + messageTag));
        }
        Message reply = null;
        try {
            reply = this.exchangeMessages(exchange, routingKey, message, correlationData, channel, pendingReply, messageTag);
        }
        finally {
            this.replyHolder.remove(messageTag);
        }
        return reply;
    }

    private void saveAndSetProperties(Message message, PendingReply pendingReply, String messageTag) {
        String savedReplyTo = message.getMessageProperties().getReplyTo();
        pendingReply.setSavedReplyTo(savedReplyTo);
        if (StringUtils.hasLength((String)savedReplyTo) && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Replacing replyTo header: " + savedReplyTo + " in favor of template's configured reply-queue: " + this.replyAddress));
        }
        message.getMessageProperties().setReplyTo(this.replyAddress);
        String savedCorrelation = null;
        if (this.correlationKey == null) {
            String correlationId = message.getMessageProperties().getCorrelationId();
            if (correlationId != null) {
                savedCorrelation = correlationId;
            }
        } else {
            savedCorrelation = (String)message.getMessageProperties().getHeaders().get(this.correlationKey);
        }
        pendingReply.setSavedCorrelation(savedCorrelation);
        if (this.correlationKey == null) {
            message.getMessageProperties().setCorrelationId(messageTag);
        } else {
            message.getMessageProperties().setHeader(this.correlationKey, (Object)messageTag);
        }
    }

    private Message exchangeMessages(String exchange, String routingKey, Message message, CorrelationData correlationData, Channel channel, PendingReply pendingReply, String messageTag) throws Exception {
        Message reply;
        boolean mandatory = this.isMandatoryFor(message);
        if (mandatory && this.returnCallback == null) {
            message.getMessageProperties().getHeaders().put(RETURN_CORRELATION_KEY, messageTag);
        }
        this.doSend(channel, exchange, routingKey, message, mandatory, correlationData);
        Message message2 = reply = this.replyTimeout < 0L ? pendingReply.get() : pendingReply.get(this.replyTimeout, TimeUnit.MILLISECONDS);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Reply: " + reply));
        }
        return reply;
    }

    public Boolean isMandatoryFor(Message message) {
        return (Boolean)this.mandatoryExpression.getValue((EvaluationContext)this.evaluationContext, (Object)message, Boolean.class);
    }

    @Override
    public <T> T execute(ChannelCallback<T> action) {
        return this.execute(action, this.getConnectionFactory());
    }

    private <T> T execute(ChannelCallback<T> action, ConnectionFactory connectionFactory) {
        if (this.retryTemplate != null) {
            try {
                return (T)this.retryTemplate.execute(context -> this.doExecute(action, connectionFactory), this.recoveryCallback);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw RabbitExceptionTranslator.convertRabbitAccessException(e);
            }
        }
        return this.doExecute(action, connectionFactory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T doExecute(ChannelCallback<T> action, ConnectionFactory connectionFactory) {
        Connection connection;
        RabbitResourceHolder resourceHolder;
        boolean invokeScope;
        Channel channel;
        block19: {
            block20: {
                Assert.notNull(action, (String)"Callback object must not be null");
                channel = null;
                invokeScope = false;
                if (this.activeTemplateCallbacks.get() > 0) {
                    channel = this.dedicatedChannels.get();
                }
                resourceHolder = null;
                connection = null;
                if (channel != null) break block20;
                if (this.isChannelTransacted()) {
                    resourceHolder = ConnectionFactoryUtils.getTransactionalResourceHolder(connectionFactory, true);
                    channel = resourceHolder.getChannel();
                    if (channel == null) {
                        ConnectionFactoryUtils.releaseResources(resourceHolder);
                        throw new IllegalStateException("Resource holder returned a null channel");
                    }
                    break block19;
                } else {
                    connection = connectionFactory.createConnection();
                    if (connection == null) {
                        throw new IllegalStateException("Connection factory returned a null connection");
                    }
                    try {
                        channel = connection.createChannel(false);
                        if (channel == null) {
                            throw new IllegalStateException("Connection returned a null channel");
                        }
                        break block19;
                    }
                    catch (RuntimeException e) {
                        RabbitUtils.closeConnection(connection);
                        throw e;
                    }
                }
            }
            invokeScope = true;
        }
        try {
            if (this.confirmsOrReturnsCapable == null) {
                this.determineConfirmsReturnsCapability(connectionFactory);
            }
            if (this.confirmsOrReturnsCapable.booleanValue()) {
                this.addListener(channel);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Executing callback " + action.getClass().getSimpleName() + " on RabbitMQ Channel: " + channel));
            }
            T e = action.doInRabbit(channel);
            return e;
        }
        catch (Exception ex) {
            if (!this.isChannelLocallyTransacted(channel)) throw this.convertRabbitAccessException(ex);
            resourceHolder.rollbackAll();
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            if (!invokeScope) {
                if (resourceHolder != null) {
                    ConnectionFactoryUtils.releaseResources(resourceHolder);
                } else {
                    RabbitUtils.closeChannel(channel);
                    RabbitUtils.closeConnection(connection);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T invoke(RabbitOperations.OperationsCallback<T> action) {
        Channel channel;
        Channel currentChannel = this.dedicatedChannels.get();
        Assert.state((currentChannel == null ? 1 : 0) != 0, () -> "Nested invoke() calls are not supported; channel '" + currentChannel + "' is already associated with this thread");
        this.activeTemplateCallbacks.incrementAndGet();
        RabbitResourceHolder resourceHolder = null;
        Connection connection = null;
        if (this.isChannelTransacted()) {
            resourceHolder = ConnectionFactoryUtils.getTransactionalResourceHolder(this.getConnectionFactory(), true);
            channel = resourceHolder.getChannel();
            if (channel == null) {
                ConnectionFactoryUtils.releaseResources(resourceHolder);
                throw new IllegalStateException("Resource holder returned a null channel");
            }
        } else {
            connection = this.getConnectionFactory().createConnection();
            if (connection == null) {
                throw new IllegalStateException("Connection factory returned a null connection");
            }
            try {
                channel = connection.createChannel(false);
                if (channel == null) {
                    throw new IllegalStateException("Connection returned a null channel");
                }
                RabbitUtils.setPhysicalCloseRequired(true);
                this.dedicatedChannels.set(channel);
            }
            catch (RuntimeException e) {
                RabbitUtils.closeConnection(connection);
                throw e;
            }
        }
        try {
            T t = action.doInRabbit(this);
            return t;
        }
        finally {
            this.activeTemplateCallbacks.decrementAndGet();
            this.dedicatedChannels.remove();
            if (resourceHolder != null) {
                ConnectionFactoryUtils.releaseResources(resourceHolder);
            } else {
                RabbitUtils.closeChannel(channel);
                RabbitUtils.closeConnection(connection);
            }
        }
    }

    @Override
    public boolean waitForConfirms(long timeout) {
        Channel channel = this.dedicatedChannels.get();
        Assert.state((channel != null ? 1 : 0) != 0, (String)"This operation is only available within the scope of an invoke operation");
        try {
            return channel.waitForConfirms(timeout);
        }
        catch (TimeoutException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    @Override
    public void waitForConfirmsOrDie(long timeout) {
        Channel channel = this.dedicatedChannels.get();
        Assert.state((channel != null ? 1 : 0) != 0, (String)"This operation is only available within the scope of an invoke operation");
        try {
            channel.waitForConfirmsOrDie(timeout);
        }
        catch (IOException | TimeoutException e) {
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw RabbitExceptionTranslator.convertRabbitAccessException(e);
        }
    }

    public void determineConfirmsReturnsCapability(ConnectionFactory connectionFactory) {
        PublisherCallbackChannelConnectionFactory pcccf;
        this.confirmsOrReturnsCapable = connectionFactory instanceof PublisherCallbackChannelConnectionFactory ? Boolean.valueOf((pcccf = (PublisherCallbackChannelConnectionFactory)((Object)connectionFactory)).isPublisherConfirms() || pcccf.isPublisherReturns()) : Boolean.FALSE;
    }

    public void doSend(Channel channel, String exchange, String routingKey, Message message, boolean mandatory, CorrelationData correlationData) throws Exception {
        String userId;
        if (exchange == null) {
            exchange = this.exchange;
        }
        if (routingKey == null) {
            routingKey = this.routingKey;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Publishing message " + message + "on exchange [" + exchange + "], routingKey = [" + routingKey + "]"));
        }
        Message messageToUse = message;
        MessageProperties messageProperties = messageToUse.getMessageProperties();
        if (mandatory) {
            messageProperties.getHeaders().put("spring_listener_return_correlation", this.uuid);
        }
        if (this.beforePublishPostProcessors != null) {
            for (MessagePostProcessor processor : this.beforePublishPostProcessors) {
                messageToUse = processor.postProcessMessage(messageToUse, (Correlation)correlationData);
            }
        }
        this.setupConfirm(channel, messageToUse, correlationData);
        if (this.userIdExpression != null && messageProperties.getUserId() == null && (userId = (String)this.userIdExpression.getValue((EvaluationContext)this.evaluationContext, (Object)messageToUse, String.class)) != null) {
            messageProperties.setUserId(userId);
        }
        this.sendToRabbit(channel, exchange, routingKey, mandatory, messageToUse);
        if (this.isChannelLocallyTransacted(channel)) {
            RabbitUtils.commitIfNecessary(channel);
        }
    }

    protected void sendToRabbit(Channel channel, String exchange, String routingKey, boolean mandatory, Message message) throws IOException {
        AMQP.BasicProperties convertedMessageProperties = this.messagePropertiesConverter.fromMessageProperties(message.getMessageProperties(), this.encoding);
        channel.basicPublish(exchange, routingKey, mandatory, convertedMessageProperties, message.getBody());
    }

    private void setupConfirm(Channel channel, Message message, CorrelationData correlationData) {
        if (this.confirmCallback != null && channel instanceof PublisherCallbackChannel) {
            PublisherCallbackChannel publisherCallbackChannel = (PublisherCallbackChannel)channel;
            correlationData = this.correlationDataPostProcessor != null ? this.correlationDataPostProcessor.postProcess(message, correlationData) : correlationData;
            publisherCallbackChannel.addPendingConfirm(this, channel.getNextPublishSeqNo(), new PendingConfirm(correlationData, System.currentTimeMillis()));
        }
    }

    protected boolean isChannelLocallyTransacted(Channel channel) {
        return this.isChannelTransacted() && !ConnectionFactoryUtils.isChannelTransactional(channel, this.getConnectionFactory());
    }

    private Message buildMessageFromDelivery(Delivery delivery) {
        return this.buildMessage(delivery.getEnvelope(), delivery.getProperties(), delivery.getBody(), -1);
    }

    private Message buildMessageFromResponse(GetResponse response) {
        return this.buildMessage(response.getEnvelope(), response.getProps(), response.getBody(), response.getMessageCount());
    }

    private Message buildMessage(Envelope envelope, AMQP.BasicProperties properties, byte[] body, int msgCount) {
        MessageProperties messageProps = this.messagePropertiesConverter.toMessageProperties(properties, envelope, this.encoding);
        if (msgCount >= 0) {
            messageProps.setMessageCount(Integer.valueOf(msgCount));
        }
        Message message = new Message(body, messageProps);
        if (this.afterReceivePostProcessors != null) {
            for (MessagePostProcessor processor : this.afterReceivePostProcessors) {
                message = processor.postProcessMessage(message);
            }
        }
        return message;
    }

    private MessageConverter getRequiredMessageConverter() throws IllegalStateException {
        MessageConverter converter = this.getMessageConverter();
        if (converter == null) {
            throw new AmqpIllegalStateException("No 'messageConverter' specified. Check configuration of RabbitTemplate.");
        }
        return converter;
    }

    private SmartMessageConverter getRequiredSmartMessageConverter() throws IllegalStateException {
        MessageConverter converter = this.getRequiredMessageConverter();
        Assert.state((boolean)(converter instanceof SmartMessageConverter), (String)"template's message converter must be a SmartMessageConverter");
        return (SmartMessageConverter)converter;
    }

    private String getRequiredQueue() throws IllegalStateException {
        String name = this.queue;
        if (name == null) {
            throw new AmqpIllegalStateException("No 'queue' specified. Check configuration of RabbitTemplate.");
        }
        return name;
    }

    private Address getReplyToAddress(Message request) throws AmqpException {
        Address replyTo = request.getMessageProperties().getReplyToAddress();
        if (replyTo == null) {
            if (this.exchange == null) {
                throw new AmqpException("Cannot determine ReplyTo message property value: Request message does not contain reply-to property, and no default Exchange was set.");
            }
            replyTo = new Address(this.exchange, this.routingKey);
        }
        return replyTo;
    }

    public void addListener(Channel channel) {
        if (channel instanceof PublisherCallbackChannel) {
            Channel key;
            PublisherCallbackChannel publisherCallbackChannel = (PublisherCallbackChannel)channel;
            Channel channel2 = key = channel instanceof ChannelProxy ? ((ChannelProxy)channel).getTargetChannel() : channel;
            if (this.publisherConfirmChannels.putIfAbsent(key, this) == null) {
                publisherCallbackChannel.addListener(this);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Added publisher confirm channel: " + channel + " to map, size now " + this.publisherConfirmChannels.size()));
                }
            }
        } else {
            throw new IllegalStateException("Channel does not support confirms or returns; is the connection factory configured for confirms or returns?");
        }
    }

    @Override
    public void handleConfirm(PendingConfirm pendingConfirm, boolean ack) {
        if (this.confirmCallback != null) {
            this.confirmCallback.confirm(pendingConfirm.getCorrelationData(), ack, pendingConfirm.getCause());
        } else if (this.logger.isDebugEnabled()) {
            this.logger.warn((Object)"Confirm received but no callback available");
        }
    }

    @Override
    public void handleReturn(int replyCode, String replyText, String exchange, String routingKey, AMQP.BasicProperties properties, byte[] body) throws IOException {
        ReturnCallback returnCallback = this.returnCallback;
        if (returnCallback == null) {
            Object messageTagHeader = properties.getHeaders().remove(RETURN_CORRELATION_KEY);
            if (messageTagHeader != null) {
                String messageTag = messageTagHeader.toString();
                PendingReply pendingReply = this.replyHolder.get(messageTag);
                if (pendingReply != null) {
                    returnCallback = (message, replyCode1, replyText1, exchange1, routingKey1) -> pendingReply.returned(new AmqpMessageReturnedException("Message returned", message, replyCode1, replyText1, exchange1, routingKey1));
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)"Returned request message but caller has timed out");
                }
            } else if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)"Returned message but no callback available");
            }
        }
        if (returnCallback != null) {
            properties.getHeaders().remove("spring_listener_return_correlation");
            MessageProperties messageProperties = this.messagePropertiesConverter.toMessageProperties(properties, null, this.encoding);
            Message returnedMessage = new Message(body, messageProperties);
            returnCallback.returnedMessage(returnedMessage, replyCode, replyText, exchange, routingKey);
        }
    }

    @Override
    public boolean isConfirmListener() {
        return this.confirmCallback != null;
    }

    @Override
    public boolean isReturnListener() {
        return true;
    }

    @Override
    public void revoke(Channel channel) {
        this.publisherConfirmChannels.remove(channel);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removed publisher confirm channel: " + channel + " from map, size now " + this.publisherConfirmChannels.size()));
        }
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    public void onMessage(Message message) {
        String messageTag;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Message received " + message));
        }
        if ((messageTag = this.correlationKey == null ? message.getMessageProperties().getCorrelationId() : (String)message.getMessageProperties().getHeaders().get(this.correlationKey)) == null) {
            this.logger.error((Object)"No correlation header in reply");
            return;
        }
        PendingReply pendingReply = this.replyHolder.get(messageTag);
        if (pendingReply == null) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Reply received after timeout for " + messageTag));
            }
            throw new AmqpRejectAndDontRequeueException("Reply received after timeout");
        }
        this.restoreProperties(message, pendingReply);
        pendingReply.reply(message);
    }

    private void restoreProperties(Message message, PendingReply pendingReply) {
        String savedCorrelation = pendingReply.getSavedCorrelation();
        if (this.correlationKey == null) {
            if (savedCorrelation == null) {
                message.getMessageProperties().setCorrelationId(null);
            } else {
                message.getMessageProperties().setCorrelationId(savedCorrelation);
            }
        } else if (savedCorrelation != null) {
            message.getMessageProperties().setHeader(this.correlationKey, (Object)savedCorrelation);
        } else {
            message.getMessageProperties().getHeaders().remove(this.correlationKey);
        }
        String savedReplyTo = pendingReply.getSavedReplyTo();
        message.getMessageProperties().setReplyTo(savedReplyTo);
        if (this.logger.isDebugEnabled() && savedReplyTo != null) {
            this.logger.debug((Object)("Restored replyTo to " + savedReplyTo));
        }
    }

    private DefaultConsumer createConsumer(String queueName, Channel channel, final CompletableFuture<Delivery> future, long timeoutMillis) throws Exception {
        channel.basicQos(1);
        final CountDownLatch latch = new CountDownLatch(1);
        TemplateConsumer consumer = new TemplateConsumer(channel){

            public void handleCancel(String consumerTag) throws IOException {
                future.completeExceptionally(new ConsumerCancelledException());
            }

            public void handleConsumeOk(String consumerTag) {
                super.handleConsumeOk(consumerTag);
                latch.countDown();
            }

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                future.complete(new Delivery(consumerTag, envelope, properties, body));
            }
        };
        channel.basicConsume(queueName, (Consumer)consumer);
        if (!latch.await(timeoutMillis, TimeUnit.MILLISECONDS)) {
            if (channel instanceof ChannelProxy) {
                ((ChannelProxy)channel).getTargetChannel().close();
            }
            future.completeExceptionally((Throwable)((Object)new ConsumeOkNotReceivedException("Blocking receive, consumer failed to consume: " + (Object)((Object)consumer))));
        }
        return consumer;
    }

    @FunctionalInterface
    public static interface ReturnCallback {
        public void returnedMessage(Message var1, int var2, String var3, String var4, String var5);
    }

    @FunctionalInterface
    public static interface ConfirmCallback {
        public void confirm(CorrelationData var1, boolean var2, String var3);
    }

    protected static abstract class TemplateConsumer
    extends DefaultConsumer {
        public TemplateConsumer(Channel channel) {
            super(channel);
        }

        public String toString() {
            return "TemplateConsumer [channel=" + this.getChannel() + ", consumerTag=" + this.getConsumerTag() + "]";
        }
    }

    private static class PendingReply {
        private volatile String savedReplyTo;
        private volatile String savedCorrelation;
        private final BlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);

        private PendingReply() {
        }

        public String getSavedReplyTo() {
            return this.savedReplyTo;
        }

        public void setSavedReplyTo(String savedReplyTo) {
            this.savedReplyTo = savedReplyTo;
        }

        public String getSavedCorrelation() {
            return this.savedCorrelation;
        }

        public void setSavedCorrelation(String savedCorrelation) {
            this.savedCorrelation = savedCorrelation;
        }

        public Message get() throws InterruptedException {
            Object reply = this.queue.take();
            return this.processReply(reply);
        }

        public Message get(long timeout, TimeUnit unit) throws InterruptedException {
            Object reply = this.queue.poll(timeout, unit);
            return reply == null ? null : this.processReply(reply);
        }

        private Message processReply(Object reply) {
            if (reply instanceof Message) {
                return (Message)reply;
            }
            if (reply instanceof AmqpException) {
                throw (AmqpException)((Object)reply);
            }
            throw new AmqpException("Unexpected reply type " + reply.getClass().getName());
        }

        public void reply(Message reply) {
            this.queue.add(reply);
        }

        public void returned(AmqpMessageReturnedException e) {
            this.queue.add(e);
        }
    }
}

