/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.support.converter.ClassMapper;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.ClassUtils;

public class DefaultClassMapper
implements ClassMapper,
InitializingBean {
    public static final String DEFAULT_CLASSID_FIELD_NAME = "__TypeId__";
    private static final String DEFAULT_HASHTABLE_TYPE_ID = "Hashtable";
    private volatile Map<String, Class<?>> idClassMapping = new HashMap();
    private volatile Map<Class<?>, String> classIdMapping = new HashMap();
    private volatile Class<?> defaultMapClass = LinkedHashMap.class;
    private volatile Class<?> defaultType = LinkedHashMap.class;

    public void setDefaultType(Class<?> defaultType) {
        this.defaultType = defaultType;
    }

    @Deprecated
    public void setDefaultHashtableClass(Class<?> defaultMapClass) {
        this.defaultMapClass = defaultMapClass;
    }

    public void setDefaultMapClass(Class<?> defaultMapClass) {
        this.defaultMapClass = defaultMapClass;
    }

    public String getClassIdFieldName() {
        return DEFAULT_CLASSID_FIELD_NAME;
    }

    public void setIdClassMapping(Map<String, Class<?>> idClassMapping) {
        this.idClassMapping = idClassMapping;
    }

    private String fromClass(Class<?> classOfObjectToConvert) {
        if (this.classIdMapping.containsKey(classOfObjectToConvert)) {
            return this.classIdMapping.get(classOfObjectToConvert);
        }
        if (Map.class.isAssignableFrom(classOfObjectToConvert)) {
            return DEFAULT_HASHTABLE_TYPE_ID;
        }
        return classOfObjectToConvert.getName();
    }

    private Class<?> toClass(String classId) {
        if (this.idClassMapping.containsKey(classId)) {
            return this.idClassMapping.get(classId);
        }
        if (classId.equals(DEFAULT_HASHTABLE_TYPE_ID)) {
            return this.defaultMapClass;
        }
        try {
            return ClassUtils.forName((String)classId, (ClassLoader)this.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MessageConversionException("failed to resolve class name [" + classId + "]", e);
        }
        catch (LinkageError e) {
            throw new MessageConversionException("failed to resolve class name [" + classId + "]", e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.validateIdTypeMapping();
    }

    private void validateIdTypeMapping() {
        HashMap finalIdClassMapping = new HashMap();
        this.classIdMapping.clear();
        for (Map.Entry<String, Class<?>> entry : this.idClassMapping.entrySet()) {
            String id = entry.getKey();
            Class<?> clazz = entry.getValue();
            finalIdClassMapping.put(id, clazz);
            this.classIdMapping.put(clazz, id);
        }
        this.idClassMapping = finalIdClassMapping;
    }

    @Override
    public void fromClass(Class<?> clazz, MessageProperties properties) {
        properties.getHeaders().put(this.getClassIdFieldName(), this.fromClass(clazz));
    }

    @Override
    public Class<?> toClass(MessageProperties properties) {
        Map<String, Object> headers = properties.getHeaders();
        Object classIdFieldNameValue = headers.get(this.getClassIdFieldName());
        String classId = null;
        if (classIdFieldNameValue != null) {
            classId = classIdFieldNameValue.toString();
        }
        if (classId == null) {
            if (this.defaultType != null) {
                return this.defaultType;
            }
            throw new MessageConversionException("failed to convert Message content. Could not resolve " + this.getClassIdFieldName() + " in header and no defaultType provided");
        }
        return this.toClass(classId);
    }
}

