/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.internal.EventAdminTracker;
import org.ops4j.pax.logging.service.internal.FrameworkHandler;
import org.ops4j.pax.logging.service.internal.JdkHandler;
import org.ops4j.pax.logging.service.internal.LogReaderServiceImpl;
import org.ops4j.pax.logging.service.internal.PaxLoggingServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogReaderService;
import org.osgi.service.log.LogService;

public class Activator
implements BundleActivator {
    public static final String CONFIGURATION_PID = "org.ops4j.pax.logging";
    private static final String[] LOGSERVICE_NAMES = new String[]{LogService.class.getName(), org.knopflerfish.service.log.LogService.class.getName(), PaxLoggingService.class.getName(), ManagedService.class.getName()};
    private ServiceRegistration m_RegistrationPaxLogging;
    private JdkHandler m_JdkHandler;
    private ServiceRegistration m_registrationLogReaderService;
    private FrameworkHandler m_frameworkHandler;
    private EventAdminPoster m_eventAdmin;

    public void start(BundleContext bundleContext) throws Exception {
        LogReaderServiceImpl logReader = new LogReaderServiceImpl(100);
        String readerServiceName = LogReaderService.class.getName();
        this.m_registrationLogReaderService = bundleContext.registerService(readerServiceName, (Object)logReader, null);
        try {
            this.m_eventAdmin = new EventAdminTracker(bundleContext);
        }
        catch (NoClassDefFoundError e) {
            this.m_eventAdmin = new EventAdminPoster(){

                public void postEvent(Bundle bundle, int level, LogEntry entry, String message, Throwable exception, ServiceReference sr, Map context) {
                }

                public void destroy() {
                }
            };
        }
        PaxLoggingServiceImpl paxLogging = new PaxLoggingServiceImpl(bundleContext, logReader, this.m_eventAdmin);
        Hashtable<String, String> serviceProperties = new Hashtable<String, String>();
        serviceProperties.put("service.id", "org.ops4j.pax.logging.configuration");
        serviceProperties.put("service.pid", CONFIGURATION_PID);
        this.m_RegistrationPaxLogging = bundleContext.registerService(LOGSERVICE_NAMES, (Object)paxLogging, serviceProperties);
        if (!Boolean.valueOf(bundleContext.getProperty("org.ops4j.pax.logging.skipJUL")).booleanValue()) {
            LogManager manager = LogManager.getLogManager();
            manager.reset();
            Logger rootLogger = manager.getLogger("");
            Handler[] handlers = rootLogger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                rootLogger.removeHandler(handlers[i]);
            }
            rootLogger.setFilter(null);
            this.m_JdkHandler = new JdkHandler(paxLogging);
            rootLogger.addHandler(this.m_JdkHandler);
        }
        this.m_frameworkHandler = new FrameworkHandler(paxLogging);
        bundleContext.addBundleListener((BundleListener)this.m_frameworkHandler);
        bundleContext.addFrameworkListener((FrameworkListener)this.m_frameworkHandler);
        bundleContext.addServiceListener((ServiceListener)this.m_frameworkHandler);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.m_eventAdmin.destroy();
        bundleContext.removeBundleListener((BundleListener)this.m_frameworkHandler);
        bundleContext.removeFrameworkListener((FrameworkListener)this.m_frameworkHandler);
        bundleContext.removeServiceListener((ServiceListener)this.m_frameworkHandler);
        if (this.m_JdkHandler != null) {
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            rootLogger.removeHandler(this.m_JdkHandler);
            this.m_JdkHandler.flush();
            this.m_JdkHandler.close();
            this.m_JdkHandler = null;
        }
        this.m_RegistrationPaxLogging.unregister();
        this.m_RegistrationPaxLogging = null;
        this.m_registrationLogReaderService.unregister();
        this.m_registrationLogReaderService = null;
    }
}

