/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.slf4j;

import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class Slf4jLogger
implements Logger {
    public static final String SLF4J_FQCN = Slf4jLogger.class.getName();
    private String m_name;
    private PaxLogger m_delegate;

    public Slf4jLogger(String name, PaxLogger delegate) {
        this.m_name = name;
        this.m_delegate = delegate;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.m_delegate.isTraceEnabled()) {
            this.m_delegate.trace(msg, null);
        }
    }

    public void trace(String format, Object arg) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.trace(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.trace(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void trace(String format, Object[] argArray) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.trace(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.m_delegate.isTraceEnabled()) {
            this.m_delegate.trace(msg, t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.m_delegate.isTraceEnabled();
    }

    public void trace(Marker marker, String msg) {
        if (this.m_delegate.isTraceEnabled()) {
            this.m_delegate.trace(msg, null);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.trace(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.trace(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void trace(Marker marker, String format, Object[] argArray) {
        if (this.m_delegate.isTraceEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.trace(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.m_delegate.isTraceEnabled()) {
            this.m_delegate.trace(msg, t);
        }
    }

    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.m_delegate.isDebugEnabled()) {
            this.m_delegate.debug(msg, null);
        }
    }

    public void debug(String format, Object arg) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.debug(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.debug(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void debug(String format, Object[] argArray) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.debug(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.m_delegate.isDebugEnabled()) {
            this.m_delegate.debug(msg, t);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.m_delegate.isDebugEnabled();
    }

    public void debug(Marker marker, String msg) {
        if (this.m_delegate.isDebugEnabled()) {
            this.m_delegate.debug(msg, null);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.debug(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.debug(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void debug(Marker marker, String format, Object[] argArray) {
        if (this.m_delegate.isDebugEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.debug(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.m_delegate.isDebugEnabled()) {
            this.m_delegate.debug(msg, t);
        }
    }

    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    public void info(String msg) {
        if (this.m_delegate.isInfoEnabled()) {
            this.m_delegate.inform(msg, null);
        }
    }

    public void info(String format, Object arg) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.inform(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void info(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.inform(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void info(String format, Object[] argArray) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.inform(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void info(String msg, Throwable t) {
        if (this.m_delegate.isInfoEnabled()) {
            this.m_delegate.inform(msg, t);
        }
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.m_delegate.isInfoEnabled();
    }

    public void info(Marker marker, String msg) {
        if (this.m_delegate.isInfoEnabled()) {
            this.m_delegate.inform(msg, null);
        }
    }

    public void info(Marker marker, String format, Object arg) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.inform(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.inform(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void info(Marker marker, String format, Object[] argArray) {
        if (this.m_delegate.isInfoEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.inform(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void info(Marker marker, String msg, Throwable t) {
        if (this.m_delegate.isInfoEnabled()) {
            this.m_delegate.inform(msg, t);
        }
    }

    public boolean isWarnEnabled() {
        return this.m_delegate.isWarnEnabled();
    }

    public void warn(String msg) {
        if (this.m_delegate.isWarnEnabled()) {
            this.m_delegate.warn(msg, null);
        }
    }

    public void warn(String format, Object arg) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.warn(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void warn(String format, Object[] argArray) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.warn(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.warn(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.m_delegate.isWarnEnabled()) {
            this.m_delegate.warn(msg, t);
        }
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.m_delegate.isWarnEnabled();
    }

    public void warn(Marker marker, String msg) {
        if (this.m_delegate.isWarnEnabled()) {
            this.m_delegate.warn(msg, null);
        }
    }

    public void warn(Marker marker, String format, Object arg) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.warn(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.warn(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void warn(Marker marker, String format, Object[] argArray) {
        if (this.m_delegate.isWarnEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.warn(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void warn(Marker marker, String msg, Throwable t) {
        if (this.m_delegate.isWarnEnabled()) {
            this.m_delegate.warn(msg, t);
        }
    }

    public boolean isErrorEnabled() {
        return this.m_delegate.isErrorEnabled();
    }

    public void error(String msg) {
        if (this.m_delegate.isErrorEnabled()) {
            this.m_delegate.error(msg, null);
        }
    }

    public void error(String format, Object arg) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.error(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void error(String format, Object arg1, Object arg2) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.error(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void error(String format, Object[] argArray) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.error(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void error(String msg, Throwable t) {
        if (this.m_delegate.isErrorEnabled()) {
            this.m_delegate.error(msg, t);
        }
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.m_delegate.isErrorEnabled();
    }

    public void error(Marker marker, String msg) {
        if (this.m_delegate.isErrorEnabled()) {
            this.m_delegate.error(msg, null);
        }
    }

    public void error(Marker marker, String format, Object arg) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg);
            this.m_delegate.error(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.format(format, arg1, arg2);
            this.m_delegate.error(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void error(Marker marker, String format, Object[] argArray) {
        if (this.m_delegate.isErrorEnabled()) {
            FormattingTuple tuple = MessageFormatter.arrayFormat(format, argArray);
            this.m_delegate.error(tuple.getMessage(), tuple.getThrowable());
        }
    }

    public void error(Marker marker, String msg, Throwable t) {
        if (this.m_delegate.isErrorEnabled()) {
            this.m_delegate.error(msg, t);
        }
    }

    void setPaxLoggingManager(PaxLoggingManager loggingManager, String name) {
        this.m_delegate = loggingManager.getLogger(name, SLF4J_FQCN);
    }
}

