/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.mavenplugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.DefaultArtifactCollector;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateConfigMojo
extends AbstractMojo {
    protected static final String SEPARATOR = "/";
    private static final String SETTINGS_DEPENDENCY_OPTIONS = "dependency_options";
    protected MavenProject project;
    private File configOutput;
    private String dependencyScope;
    private Map<String, String> options = new HashMap<String, String>();
    private Map<String, String> settings = new HashMap<String, String>();
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactResolver resolver;
    protected ArtifactCollector collector = new DefaultArtifactCollector();
    protected ArtifactFactory factory;
    private List<ArtifactRepository> remoteRepositories;
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        OutputStream out = null;
        try {
            this.configOutput.getParentFile().mkdirs();
            out = new FileOutputStream(this.configOutput);
            PrintStream printer = new PrintStream(out);
            List<Dependency> dependencies = this.getProvisionableDependencies();
            this.writeHeader(printer);
            this.writeProvisioning(printer, dependencies);
            this.writeSettings(printer);
            this.getLog().info((CharSequence)("Generated configuration as Pax Runner arguments file " + this.configOutput));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create dependencies file: " + e, e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.getLog().info((CharSequence)("Failed to close: " + this.configOutput + ". Reason: " + e), (Throwable)e);
                }
            }
        }
    }

    private void writeHeader(PrintStream out) {
        out.println("# Configurations generated by the Pax Exam Maven Plugin");
        out.println("# Generated at: " + new Date());
        out.println();
        out.println("# groupId = " + this.project.getGroupId());
        out.println("# artifactId = " + this.project.getArtifactId());
        out.println("# version = " + this.project.getVersion());
        out.println("# " + this.project.getGroupId() + SEPARATOR + this.project.getArtifactId() + SEPARATOR + "version = " + this.project.getVersion());
        out.println();
    }

    private void writeSettings(PrintStream out) {
        out.println("# Settings parsed from pom.xml in settings of plugin");
        for (String key : this.options.keySet()) {
            out.println("--" + key + "=" + this.options.get(key));
        }
        out.println();
    }

    private List<Dependency> getProvisionableDependencies() {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        this.getLog().info((CharSequence)("Adding dependencies in scope " + this.dependencyScope));
        for (Dependency d : this.getDependencies()) {
            if (d.getScope() == null || !d.getScope().equalsIgnoreCase(this.dependencyScope)) continue;
            dependencies.add(d);
        }
        return dependencies;
    }

    private List<Dependency> getDependencies() {
        return this.project.getDependencies();
    }

    protected void writeProvisioning(PrintStream out, List<Dependency> dependencies) throws ArtifactResolutionException, ArtifactNotFoundException {
        out.println("# provisioning");
        out.println();
        for (Dependency dependency : dependencies) {
            Artifact artifact = this.factory.createDependencyArtifact(dependency.getGroupId(), dependency.getArtifactId(), VersionRange.createFromVersion((String)dependency.getVersion()), dependency.getType(), dependency.getClassifier(), dependency.getScope());
            boolean found = false;
            for (MavenProject project : this.session.getSortedProjects()) {
                Artifact projectArtifact = project.getArtifact();
                if (!projectArtifact.getArtifactId().equals(artifact.getArtifactId()) || !projectArtifact.getGroupId().equals(artifact.getGroupId()) || !projectArtifact.getVersion().equals(artifact.getVersion())) continue;
                artifact = projectArtifact;
                found = true;
                break;
            }
            if (!found) {
                this.resolver.resolve(artifact, this.remoteRepositories, this.session.getLocalRepository());
            }
            out.println(this.createPaxRunnerScan(artifact, this.getSettingsForArtifact(this.settings.get(SETTINGS_DEPENDENCY_OPTIONS), artifact.getGroupId(), artifact.getArtifactId())));
            this.getLog().debug((CharSequence)("Dependency: " + dependency + " classifier: " + dependency.getClassifier() + " type: " + dependency.getType()));
        }
        out.println();
    }

    public String getSettingsForArtifact(String fullSettings, String groupId, String artifactId) {
        if (fullSettings != null) {
            String[] arr$ = fullSettings.split(",");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String token;
                int end = (token = arr$[i$]).indexOf("@") >= 0 ? token.indexOf("@") : token.length();
                String[] ga_part = token.substring(0, end).split(":");
                if (!ga_part[0].equals(groupId) || !ga_part[1].equals(artifactId)) continue;
                return token.substring(end);
            }
        }
        return "";
    }

    private String createPaxRunnerScan(Artifact artifact, String optionTokens) {
        return "scan-bundle:" + artifact.getFile().toURI().normalize().toString() + "@update" + optionTokens;
    }
}

