/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import com.google.common.collect.LinkedListMultimap;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import org.kohsuke.stapler.AbstractProcessorImpl;
import org.kohsuke.stapler.export.Exported;

@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedAnnotationTypes(value={"*"})
public class ExportedBeanAnnotationProcessor6
extends AbstractProcessorImpl {
    private static final String STAPLER_BEAN_FILE = "META-INF/exposed.stapler-beans";

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            if (roundEnv.processingOver()) {
                return false;
            }
            LinkedListMultimap props = LinkedListMultimap.create();
            for (Element element : roundEnv.getElementsAnnotatedWith(Exported.class)) {
                props.put((Object)((TypeElement)element.getEnclosingElement()), (Object)element);
            }
            Set<String> exposedBeanNames = this.scanExisting();
            for (Map.Entry e : props.asMap().entrySet()) {
                exposedBeanNames.add(((TypeElement)e.getKey()).getQualifiedName().toString());
                Properties javadocs = new Properties();
                block7: for (Element md : (Collection)e.getValue()) {
                    switch (md.getKind()) {
                        case FIELD: 
                        case METHOD: {
                            String javadoc = this.getJavadoc(md);
                            if (javadoc == null) continue block7;
                            javadocs.put(md.getSimpleName().toString(), javadoc);
                            continue block7;
                        }
                    }
                    throw new AssertionError((Object)("Unexpected element type: " + md));
                }
                String javadocFile = ((TypeElement)e.getKey()).getQualifiedName().toString().replace('.', '/') + ".javadoc";
                this.notice("Generating " + javadocFile, (Element)e.getKey());
                this.writePropertyFile(javadocs, javadocFile);
            }
            FileObject fileObject = this.createResource(STAPLER_BEAN_FILE);
            PrintWriter w = new PrintWriter(new OutputStreamWriter(fileObject.openOutputStream(), "UTF-8"));
            for (String beanName : exposedBeanNames) {
                w.println(beanName);
            }
            w.close();
        }
        catch (IOException x) {
            this.error(x.toString());
        }
        return false;
    }

    private Set<String> scanExisting() throws IOException {
        TreeSet<String> exposedBeanNames = new TreeSet<String>();
        FileObject beans = this.getResource(STAPLER_BEAN_FILE);
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(beans.openInputStream(), "UTF-8"));
            while ((line = in.readLine()) != null) {
                exposedBeanNames.add(line.trim());
            }
            in.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return exposedBeanNames;
    }
}

