/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.owasp.html.AttributePolicy;
import org.owasp.html.ElementPolicy;
import org.owasp.html.HtmlTextEscapingMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ElementAndAttributePolicies {
    final String elementName;
    final boolean isVoid;
    final ElementPolicy elPolicy;
    final ImmutableMap<String, AttributePolicy> attrPolicies;
    final boolean skipIfEmpty;

    ElementAndAttributePolicies(String elementName, ElementPolicy elPolicy, Map<? extends String, ? extends AttributePolicy> attrPolicies, boolean skipIfEmpty) {
        this.elementName = elementName;
        this.isVoid = HtmlTextEscapingMode.isVoidElement(elementName);
        this.elPolicy = elPolicy;
        this.attrPolicies = ImmutableMap.copyOf(attrPolicies);
        this.skipIfEmpty = skipIfEmpty;
    }

    ElementAndAttributePolicies and(ElementAndAttributePolicies p) {
        String attrName;
        assert (this.elementName.equals(p.elementName)) : this.elementName + " != " + p.elementName;
        ImmutableMap.Builder joinedAttrPolicies = ImmutableMap.builder();
        for (Map.Entry e : this.attrPolicies.entrySet()) {
            attrName = (String)e.getKey();
            AttributePolicy a = (AttributePolicy)e.getValue();
            AttributePolicy b = (AttributePolicy)p.attrPolicies.get((Object)attrName);
            if (b != null) {
                a = AttributePolicy.Util.join(a, b);
            }
            joinedAttrPolicies.put((Object)attrName, (Object)a);
        }
        for (Map.Entry e : p.attrPolicies.entrySet()) {
            attrName = (String)e.getKey();
            if (this.attrPolicies.containsKey((Object)attrName)) continue;
            joinedAttrPolicies.put((Object)attrName, e.getValue());
        }
        return new ElementAndAttributePolicies(this.elementName, ElementPolicy.Util.join(this.elPolicy, p.elPolicy), (Map<? extends String, ? extends AttributePolicy>)joinedAttrPolicies.build(), this.skipIfEmpty || p.skipIfEmpty);
    }
}

