/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;

final class MaskingClassLoader
extends ClassLoader {
    private static final Enumeration<URL> EMPTY_ENUMERATION = new Enumeration<URL>(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public URL nextElement() {
            throw new NoSuchElementException();
        }
    };
    private static final String[] PACKAGES = new String[]{"org.apache.maven.", "org.codehaus.plexus.", "org.sonatype."};
    private static final String[] PREFIXES = new String[PACKAGES.length];

    public MaskingClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String pkg : PACKAGES) {
            if (!name.startsWith(pkg)) continue;
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        if (this.isMaskedResourcePrefix(name)) {
            return null;
        }
        return super.getResource(name);
    }

    private boolean isMaskedResourcePrefix(String name) {
        for (String p : PREFIXES) {
            if (!name.startsWith(p)) continue;
            return true;
        }
        return name.startsWith("META-INF/plexus") || name.startsWith("META-INF/maven");
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.isMaskedResourcePrefix(name)) {
            return EMPTY_ENUMERATION;
        }
        return super.getResources(name);
    }

    static {
        for (int i = 0; i < PACKAGES.length; ++i) {
            MaskingClassLoader.PREFIXES[i] = PACKAGES[i].replace('.', '/');
        }
    }
}

