/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.jetty.maven.plugin.AbstractJettyMojo;
import org.eclipse.jetty.maven.plugin.MaskingClassLoader;
import org.eclipse.jetty.maven.plugin.Overlay;
import org.eclipse.jetty.maven.plugin.OverlayConfig;
import org.eclipse.jetty.maven.plugin.ScanTargetPattern;
import org.eclipse.jetty.maven.plugin.SelectiveJarResource;
import org.eclipse.jetty.maven.plugin.WarPluginInfo;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.resource.Resource;

public class JettyRunMojo
extends AbstractJettyMojo {
    public static final String DEFAULT_WEBAPP_SRC = "src" + File.separator + "main" + File.separator + "webapp";
    public static final String FAKE_WEBAPP = "webapp-tmp";
    protected boolean useTestScope;
    protected String webXml;
    protected File classesDirectory;
    private File[] additionalClassesDirectories = new File[0];
    protected File testClassesDirectory;
    protected File webAppSourceDirectory;
    protected File[] scanTargets;
    protected ScanTargetPattern[] scanTargetPatterns;
    protected List<File> extraScanTargets;
    protected WarPluginInfo warPluginInfo;
    protected List<Artifact> warArtifacts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.warPluginInfo = new WarPluginInfo(this.project);
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new MaskingClassLoader(ccl));
        try {
            super.execute();
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    @Override
    public void checkPomConfiguration() throws MojoExecutionException {
        try {
            if (this.webAppSourceDirectory == null || !this.webAppSourceDirectory.exists()) {
                this.getLog().info((CharSequence)("webAppSourceDirectory" + (this.webAppSourceDirectory == null ? " not set." : this.webAppSourceDirectory.getAbsolutePath() + " does not exist.") + " Trying " + DEFAULT_WEBAPP_SRC));
                this.webAppSourceDirectory = new File(this.project.getBasedir(), DEFAULT_WEBAPP_SRC);
                if (!this.webAppSourceDirectory.exists()) {
                    this.getLog().info((CharSequence)("webAppSourceDirectory " + this.webAppSourceDirectory.getAbsolutePath() + " does not exist. Trying " + this.project.getBuild().getDirectory() + File.separator + FAKE_WEBAPP));
                    File target = new File(this.project.getBuild().getDirectory());
                    this.webAppSourceDirectory = new File(target, FAKE_WEBAPP);
                    if (!this.webAppSourceDirectory.exists()) {
                        this.webAppSourceDirectory.mkdirs();
                    }
                }
            } else {
                this.getLog().info((CharSequence)("Webapp source directory = " + this.webAppSourceDirectory.getCanonicalPath()));
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Webapp source directory does not exist", (Exception)e);
        }
        if (!"automatic".equalsIgnoreCase(this.reload) && !"manual".equalsIgnoreCase(this.reload)) {
            throw new MojoExecutionException("invalid reload mechanic specified, must be 'automatic' or 'manual'");
        }
        this.getLog().info((CharSequence)("Reload Mechanic: " + this.reload));
        try {
            if (this.classesDirectory != null) {
                if (!this.classesDirectory.exists()) {
                    this.getLog().info((CharSequence)("Classes directory " + this.classesDirectory.getCanonicalPath() + " does not exist"));
                } else {
                    this.getLog().info((CharSequence)("Classes = " + this.classesDirectory.getCanonicalPath()));
                }
            } else {
                this.getLog().info((CharSequence)"Classes directory not set");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Location of classesDirectory does not exist");
        }
        this.extraScanTargets = new ArrayList<File>();
        if (this.scanTargets != null) {
            for (int i = 0; i < this.scanTargets.length; ++i) {
                this.getLog().info((CharSequence)("Added extra scan target:" + this.scanTargets[i]));
                this.extraScanTargets.add(this.scanTargets[i]);
            }
        }
        if (this.scanTargetPatterns != null) {
            for (int i = 0; i < this.scanTargetPatterns.length; ++i) {
                Iterator itor = this.scanTargetPatterns[i].getIncludes().iterator();
                StringBuffer strbuff = new StringBuffer();
                while (itor.hasNext()) {
                    strbuff.append((String)itor.next());
                    if (!itor.hasNext()) continue;
                    strbuff.append(",");
                }
                String includes = strbuff.toString();
                itor = this.scanTargetPatterns[i].getExcludes().iterator();
                strbuff = new StringBuffer();
                while (itor.hasNext()) {
                    strbuff.append((String)itor.next());
                    if (!itor.hasNext()) continue;
                    strbuff.append(",");
                }
                String excludes = strbuff.toString();
                try {
                    List files = FileUtils.getFiles((File)this.scanTargetPatterns[i].getDirectory(), (String)includes, (String)excludes);
                    itor = files.iterator();
                    while (itor.hasNext()) {
                        this.getLog().info((CharSequence)("Adding extra scan target from pattern: " + itor.next()));
                    }
                    List<File> currentTargets = this.extraScanTargets;
                    if (currentTargets != null && !currentTargets.isEmpty()) {
                        currentTargets.addAll(files);
                        continue;
                    }
                    this.extraScanTargets = files;
                    continue;
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getMessage());
                }
            }
        }
    }

    @Override
    public void finishConfigurationBeforeStart() throws Exception {
        this.server.setStopAtShutdown(true);
        super.finishConfigurationBeforeStart();
    }

    @Override
    public void configureWebApplication() throws Exception {
        Overlay overlay;
        super.configureWebApplication();
        Resource webAppSourceDirectoryResource = Resource.newResource((String)this.webAppSourceDirectory.getCanonicalPath());
        if (this.webApp.getWar() == null) {
            this.webApp.setWar(webAppSourceDirectoryResource.toString());
        }
        if (this.webApp.getBaseResource() == null) {
            this.webApp.setBaseResource(webAppSourceDirectoryResource);
        }
        if (this.classesDirectory != null) {
            this.webApp.setClasses(this.classesDirectory);
        }
        if (this.useTestScope && this.testClassesDirectory != null) {
            this.webApp.setTestClasses(this.testClassesDirectory);
        }
        this.webApp.setWebInfLib(this.getDependencyFiles());
        HashSet<Artifact> matchedWarArtifacts = new HashSet<Artifact>();
        for (Artifact a : this.getWarArtifacts()) {
            this.extraScanTargets.add(a.getFile());
        }
        ArrayList<Overlay> overlays = new ArrayList<Overlay>();
        for (OverlayConfig config : this.warPluginInfo.getMavenWarOverlayConfigs()) {
            if (config.isSkip()) continue;
            if (config.isCurrentProject()) {
                overlay = new Overlay(config, null);
                overlays.add(overlay);
                continue;
            }
            Artifact a = this.getArtifactForOverlay(config, this.getWarArtifacts());
            if (a == null) continue;
            matchedWarArtifacts.add(a);
            SelectiveJarResource r = new SelectiveJarResource(new URL("jar:" + Resource.toURL((File)a.getFile()).toString() + "!/"));
            r.setIncludes(config.getIncludes());
            r.setExcludes(config.getExcludes());
            Overlay overlay2 = new Overlay(config, (Resource)r);
            overlays.add(overlay2);
        }
        for (Artifact a : this.getWarArtifacts()) {
            if (matchedWarArtifacts.contains(a)) continue;
            overlay = new Overlay(null, Resource.newResource((URL)new URL("jar:" + Resource.toURL((File)a.getFile()).toString() + "!/")));
            overlays.add(overlay);
        }
        this.webApp.setOverlays(overlays);
        if (this.webApp.getDescriptor() == null) {
            File f;
            Resource r;
            if (this.webXml != null && (r = Resource.newResource((String)this.webXml)).exists() && !r.isDirectory()) {
                this.webApp.setDescriptor(r.toString());
            }
            if (this.webApp.getDescriptor() == null && this.webApp.getBaseResource() != null && (r = this.webApp.getBaseResource().addPath("WEB-INF/web.xml")).exists() && !r.isDirectory()) {
                this.webApp.setDescriptor(r.toString());
            }
            if (this.webApp.getDescriptor() == null && this.webAppSourceDirectory != null && (f = new File(new File(this.webAppSourceDirectory, "WEB-INF"), "web.xml")).exists() && f.isFile()) {
                this.webApp.setDescriptor(f.getCanonicalPath());
            }
        }
        this.getLog().info((CharSequence)("web.xml file = " + this.webApp.getDescriptor()));
        this.getLog().info((CharSequence)("Webapp directory = " + this.webAppSourceDirectory.getCanonicalPath()));
    }

    @Override
    public void configureScanner() throws MojoExecutionException {
        File jettyWebXmlFile;
        Throwable throwable;
        Resource r;
        this.scanList = new ArrayList();
        if (this.webApp.getDescriptor() != null) {
            try {
                r = Resource.newResource((String)this.webApp.getDescriptor());
                throwable = null;
                try {
                    this.scanList.add(r.getFile());
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (r != null) {
                        if (throwable != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem configuring scanner for web.xml", (Exception)e);
            }
        }
        if (this.webApp.getJettyEnvXml() != null) {
            try {
                r = Resource.newResource((String)this.webApp.getJettyEnvXml());
                throwable = null;
                try {
                    this.scanList.add(r.getFile());
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (r != null) {
                        if (throwable != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem configuring scanner for jetty-env.xml", (Exception)e);
            }
        }
        if (this.webApp.getDefaultsDescriptor() != null) {
            try {
                r = Resource.newResource((String)this.webApp.getDefaultsDescriptor());
                throwable = null;
                try {
                    if (!"org/eclipse/jetty/webapp/webdefault.xml".equals(this.webApp.getDefaultsDescriptor())) {
                        this.scanList.add(r.getFile());
                    }
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (r != null) {
                        if (throwable != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem configuring scanner for webdefaults.xml", (Exception)e);
            }
        }
        if (this.webApp.getOverrideDescriptor() != null) {
            try {
                r = Resource.newResource((String)this.webApp.getOverrideDescriptor());
                throwable = null;
                try {
                    this.scanList.add(r.getFile());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (r != null) {
                        if (throwable != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Problem configuring scanner for webdefaults.xml", (Exception)e);
            }
        }
        if ((jettyWebXmlFile = this.findJettyWebXmlFile(new File(this.webAppSourceDirectory, "WEB-INF"))) != null) {
            this.scanList.add(jettyWebXmlFile);
        }
        this.scanList.addAll(this.extraScanTargets);
        this.scanList.add(this.project.getFile());
        if (this.webApp.getTestClasses() != null) {
            this.scanList.add(this.webApp.getTestClasses());
        }
        if (this.webApp.getClasses() != null) {
            this.scanList.add(this.webApp.getClasses());
        }
        this.scanList.addAll(this.webApp.getWebInfLib());
        this.scannerListeners = new ArrayList();
        this.scannerListeners.add(new Scanner.BulkListener(){

            public void filesChanged(List changes) {
                try {
                    boolean reconfigure = changes.contains(JettyRunMojo.this.project.getFile().getCanonicalPath());
                    JettyRunMojo.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    JettyRunMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)("restarting " + (Object)((Object)this.webApp)));
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.webApp.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        this.configureWebApplication();
        if (reconfigureScanner) {
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            this.scanList.clear();
            if (this.webApp.getDescriptor() != null) {
                this.scanList.add(new File(this.webApp.getDescriptor()));
            }
            if (this.webApp.getJettyEnvXml() != null) {
                this.scanList.add(new File(this.webApp.getJettyEnvXml()));
            }
            this.scanList.addAll(this.extraScanTargets);
            this.scanList.add(this.project.getFile());
            if (this.webApp.getTestClasses() != null) {
                this.scanList.add(this.webApp.getTestClasses());
            }
            if (this.webApp.getClasses() != null) {
                this.scanList.add(this.webApp.getClasses());
            }
            this.scanList.addAll(this.webApp.getWebInfLib());
            this.scanner.setScanDirs((List)this.scanList);
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webApp.start();
        this.getLog().info((CharSequence)("Restart completed at " + new Date().toString()));
    }

    private List<File> getDependencyFiles() {
        ArrayList<File> dependencyFiles = new ArrayList<File>();
        dependencyFiles.addAll(Arrays.asList(this.additionalClassesDirectories));
        for (Artifact artifact : this.projectArtifacts) {
            if (artifact.getType().equals("war") || "provided".equals(artifact.getScope()) || "test".equals(artifact.getScope()) && !this.useTestScope) continue;
            dependencyFiles.add(artifact.getFile());
            this.getLog().debug((CharSequence)("Adding artifact " + artifact.getFile().getName() + " with scope " + artifact.getScope() + " for WEB-INF/lib "));
        }
        return dependencyFiles;
    }

    private List<Artifact> getWarArtifacts() {
        if (this.warArtifacts != null) {
            return this.warArtifacts;
        }
        this.warArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : this.projectArtifacts) {
            if (!artifact.getType().equals("war")) continue;
            try {
                this.warArtifacts.add(artifact);
                this.getLog().info((CharSequence)("Dependent war artifact " + artifact.getId()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.warArtifacts;
    }

    protected Artifact getArtifactForOverlay(OverlayConfig o, List<Artifact> warArtifacts) {
        if (o == null || warArtifacts == null || warArtifacts.isEmpty()) {
            return null;
        }
        for (Artifact a : warArtifacts) {
            if (!o.matchesArtifact(a.getGroupId(), a.getArtifactId(), a.getClassifier())) continue;
            return a;
        }
        return null;
    }
}

