/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.util;

import groovy.lang.GroovyShell;
import hudson.remoting.DelegatingCallable;
import java.io.PrintWriter;
import java.io.StringWriter;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.config.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroovyScript
implements DelegatingCallable<String, RuntimeException> {
    private static final long serialVersionUID = 1L;
    private final String script;
    private final Parameter[] parameters;
    private final boolean failWithException;
    private transient ClassLoader cl;
    private static final String PW_PARAM_VARIABLE = "out";

    public GroovyScript(String script, Parameter[] parameters, boolean failWithException) {
        this.script = script;
        this.parameters = parameters;
        this.failWithException = failWithException;
        this.cl = this.getClassLoader();
    }

    public ClassLoader getClassLoader() {
        return Jenkins.getInstance().getPluginManager().uberClassLoader;
    }

    public String call() throws RuntimeException {
        if (this.cl == null) {
            this.cl = Thread.currentThread().getContextClassLoader();
        }
        GroovyShell shell = new GroovyShell(this.cl);
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        for (Parameter param : this.parameters) {
            String paramName = param.getName();
            if (PW_PARAM_VARIABLE.equals(paramName)) {
                pw.write(Messages.skipParamter(PW_PARAM_VARIABLE));
                continue;
            }
            shell.setVariable(paramName, (Object)param.getValue());
        }
        shell.setVariable(PW_PARAM_VARIABLE, (Object)pw);
        try {
            Object output = shell.evaluate(this.script);
            if (output != null) {
                pw.println(Messages.resultPrefix() + " " + output);
            }
        }
        catch (Throwable t) {
            if (this.failWithException) {
                throw new ScriptlerExecutionException(t);
            }
            t.printStackTrace(pw);
        }
        return out.toString();
    }

    private static final class ScriptlerExecutionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ScriptlerExecutionException(Throwable cause) {
            super(cause);
        }
    }
}

