/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.share.scriptlerweb;

import com.thoughtworks.xstream.XStream;
import hudson.Extension;
import hudson.XmlFile;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jenkinsci.plugins.scriptler.share.CatalogInfo;
import org.jenkinsci.plugins.scriptler.share.ScriptInfoCatalog;
import org.jenkinsci.plugins.scriptler.share.scriptlerweb.CatalogEntry;
import org.jenkinsci.plugins.scriptler.share.scriptlerweb.CatalogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension(ordinal=5.0)
public class ScritplerWebCatalog
extends ScriptInfoCatalog<CatalogEntry> {
    public static final CatalogInfo CATALOG_INFO = new CatalogInfo("scriptlerweb", "http://scriptlerweb.appspot.com/catalog/xml", "http://scriptlerweb.appspot.com/script/show/{1}", "http://scriptlerweb.appspot.com/script/download/{1}");
    private static final CatalogManager CATALOG_MANAGER = new CatalogManager(CATALOG_INFO);

    @Override
    public CatalogInfo getInfo() {
        return CATALOG_INFO;
    }

    @Override
    public String getDisplayName() {
        return "ScriptlerWeb";
    }

    @Override
    public CatalogEntry getEntryById(String id) {
        for (CatalogEntry scr : this.getEntries()) {
            if (scr.getId() == null || !scr.getId().equals(id)) continue;
            return scr;
        }
        return null;
    }

    @Override
    public List<CatalogEntry> getEntries() {
        return new ArrayList<CatalogEntry>(ScritplerWebCatalog.CATALOG_MANAGER.loadCatalog().entrySet);
    }

    @Override
    public String getScriptSource(CatalogEntry scriptInfo) {
        return CATALOG_MANAGER.downloadScript(scriptInfo.getName(), scriptInfo.getId());
    }

    public static class CatalogContent {
        private static final XStream XSTREAM = new XStream2();
        protected Set<CatalogEntry> entrySet = new HashSet<CatalogEntry>();

        public static CatalogContent load(File catalogFile) throws IOException {
            XmlFile f = CatalogContent.getXmlFile(catalogFile);
            if (f.exists()) {
                CatalogContent sc = (CatalogContent)f.read();
                return sc;
            }
            return null;
        }

        public synchronized void save(File catalogFile) throws IOException {
            XmlFile f = CatalogContent.getXmlFile(catalogFile);
            f.write((Object)this);
        }

        private static XmlFile getXmlFile(File file) {
            return new XmlFile(XSTREAM, file);
        }

        static {
            XSTREAM.alias("catalog", CatalogContent.class);
            XSTREAM.alias("entry", CatalogEntry.class);
        }
    }
}

