/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptler.builder;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.security.Permission;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.scriptler.Messages;
import org.jenkinsci.plugins.scriptler.ScriptlerManagment;
import org.jenkinsci.plugins.scriptler.config.Parameter;
import org.jenkinsci.plugins.scriptler.config.Script;
import org.jenkinsci.plugins.scriptler.config.ScriptlerConfiguration;
import org.jenkinsci.plugins.scriptler.util.GroovyScript;
import org.jenkinsci.plugins.scriptler.util.ScriptHelper;
import org.jenkinsci.plugins.scriptler.util.UIHelper;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.bind.JavaScriptMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptlerBuilder
extends Builder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(ScriptlerBuilder.class.getName());
    private String builderId;
    private String scriptId;
    private Parameter[] parameters;

    public ScriptlerBuilder(String builderId, String scriptId, Parameter[] parameters) {
        this.builderId = builderId;
        this.scriptId = scriptId;
        this.parameters = parameters;
    }

    public String getScriptId() {
        return this.scriptId;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public String getBuilderId() {
        return this.builderId;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        boolean isOk = false;
        Script script = ScriptHelper.getScript(this.scriptId, true);
        if (script != null) {
            try {
                Parameter[] expandedParams = new Parameter[this.parameters.length];
                for (int i = 0; i < this.parameters.length; ++i) {
                    Parameter parameter = this.parameters[i];
                    expandedParams[i] = new Parameter(parameter.getName(), TokenMacro.expandAll(build, (TaskListener)listener, (String)parameter.getValue()));
                }
                String output = (String)launcher.getChannel().call((Callable)new GroovyScript(script.script, expandedParams, true));
                listener.getLogger().print(output);
                isOk = true;
            }
            catch (Exception e) {
                listener.getLogger().print(Messages.scriptExecutionFailed(this.scriptId) + " - " + e.getMessage());
            }
        } else if (StringUtils.isBlank((String)this.scriptId)) {
            listener.getLogger().print(Messages.scriptNotDefined());
        } else {
            listener.getLogger().print(Messages.scriptNotFound(this.scriptId));
        }
        return isOk;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private static final AtomicInteger CURRENT_ID = new AtomicInteger();

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return Jenkins.getInstance().hasPermission(Jenkins.RUN_SCRIPTS);
        }

        public String getDisplayName() {
            return Messages.builder_name();
        }

        public Permission getRequiredPermission() {
            return this.getScriptler().getRequiredPermissionForRunScript();
        }

        public ScriptlerBuilder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            ScriptlerBuilder builder = null;
            String builderId = formData.optString("builderId");
            if (!Jenkins.getInstance().hasPermission(Jenkins.RUN_SCRIPTS)) {
                String backupJobName = formData.optString("backupJobName");
                if (StringUtils.isNotBlank((String)builderId) && StringUtils.isNotBlank((String)backupJobName)) {
                    Project project = (Project)Jenkins.getInstance().getItemByFullName(backupJobName, Project.class);
                    List builders = project.getBuilders();
                    for (Builder b : builders) {
                        ScriptlerBuilder sb;
                        if (!(b instanceof ScriptlerBuilder) || !builderId.equals((sb = (ScriptlerBuilder)b).getBuilderId())) continue;
                        LOGGER.log(Level.FINE, "reloading ScriptlerBuilder [" + builderId + "] on project [" + backupJobName + "], as user has no permission to change it!");
                        return sb;
                    }
                }
            } else {
                String id = formData.optString("scriptlerScriptId");
                if (StringUtils.isBlank((String)builderId)) {
                    builderId = System.currentTimeMillis() + "_" + CURRENT_ID.addAndGet(1);
                }
                if (StringUtils.isNotBlank((String)id)) {
                    Parameter[] params = null;
                    try {
                        params = UIHelper.extractParameters(formData);
                    }
                    catch (ServletException e) {
                        throw new Descriptor.FormException(Messages.parameterExtractionFailed(), "parameters");
                    }
                    builder = new ScriptlerBuilder(builderId, id, params);
                }
            }
            if (builder == null) {
                builder = new ScriptlerBuilder(builderId, null, null);
            }
            return builder;
        }

        public Set<Script> getScripts() {
            Set<Script> scripts = this.getConfig().getScripts();
            HashSet<Script> scriptsForBuilder = new HashSet<Script>();
            for (Script script : scripts) {
                if (!script.nonAdministerUsing) continue;
                scriptsForBuilder.add(script);
            }
            return scriptsForBuilder;
        }

        private ScriptlerManagment getScriptler() {
            return (ScriptlerManagment)((Object)Jenkins.getInstance().getExtensionList(ScriptlerManagment.class).get(0));
        }

        private ScriptlerConfiguration getConfig() {
            return this.getScriptler().getConfiguration();
        }

        @JavaScriptMethod
        public JSONArray getParameters(String scriptlerScriptId) {
            Script script = this.getConfig().getScriptById(scriptlerScriptId);
            if (script != null && script.getParameters() != null) {
                return JSONArray.fromObject((Object)script.getParameters());
            }
            return null;
        }
    }
}

