/*
 * Decompiled with CFR 0.152.
 */
package org.jenkins_ci.plugins.run_condition.contributed;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.tasks.Shell;
import java.util.ArrayList;
import java.util.Arrays;
import org.jenkins_ci.plugins.run_condition.RunCondition;
import org.jenkins_ci.plugins.run_condition.contributed.CommandInterperterCondition;
import org.jenkins_ci.plugins.run_condition.contributed.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class ShellCondition
extends CommandInterperterCondition {
    @DataBoundConstructor
    public ShellCondition(String command) {
        super(ShellCondition.fixCrLf(command));
    }

    private static String fixCrLf(String s) {
        int idx;
        while ((idx = s.indexOf("\r\n")) != -1) {
            s = s.substring(0, idx) + s.substring(idx + 1);
        }
        return s;
    }

    private static String addCrForNonASCII(String s) {
        if (!s.startsWith("#!") && s.indexOf(10) != 0) {
            return "\n" + s;
        }
        return s;
    }

    public String[] buildCommandLine(FilePath script) {
        if (this.command.startsWith("#!")) {
            int end = this.command.indexOf(10);
            if (end < 0) {
                end = this.command.length();
            }
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(Arrays.asList(Util.tokenize((String)this.command.substring(0, end).trim())));
            args.add(script.getRemote());
            args.set(0, ((String)args.get(0)).substring(2));
            return args.toArray(new String[args.size()]);
        }
        Shell.DescriptorImpl shellDesc = (Shell.DescriptorImpl)Hudson.getInstance().getDescriptorByType(Shell.DescriptorImpl.class);
        return new String[]{shellDesc.getShellOrDefault(script.getChannel()), "-xe", script.getRemote()};
    }

    protected String getContents() {
        return ShellCondition.addCrForNonASCII(ShellCondition.fixCrLf(this.command));
    }

    protected String getFileExtension() {
        return ".sh";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class ShellConditionDescriptor
    extends RunCondition.RunConditionDescriptor {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.ShellCondition_Displayname();
        }
    }
}

