/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.ParameterizedTriggerUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedBuildParameters
extends AbstractBuildParameters {
    private final String properties;

    @DataBoundConstructor
    public PredefinedBuildParameters(String properties) {
        this.properties = properties;
    }

    @Override
    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        EnvVars env = this.getEnvironment(build, listener);
        Properties p = ParameterizedTriggerUtils.loadProperties(this.getProperties());
        ArrayList<StringParameterValue> values = new ArrayList<StringParameterValue>();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            values.add(new StringParameterValue(entry.getKey().toString(), env.expand(entry.getValue().toString())));
        }
        return new ParametersAction(values);
    }

    public String getProperties() {
        return this.properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<AbstractBuildParameters> {
        public String getDisplayName() {
            return "Predefined parameters";
        }
    }
}

