/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.CheckPoint;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.User;
import hudson.scm.ChangeLogSet;
import hudson.tasks.MailMessageIdAction;
import hudson.tasks.Mailer;
import hudson.tasks.i18n.Messages;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailSender {
    private String recipients;
    private List<AbstractProject> includeUpstreamCommitters = new ArrayList<AbstractProject>();
    private boolean dontNotifyEveryUnstableBuild;
    private boolean sendToIndividuals;
    private String charset;
    public static boolean debug = false;
    private static final int MAX_LOG_LINES = Integer.getInteger(MailSender.class.getName() + ".maxLogLines", 250);
    private static final CheckPoint CHECKPOINT = new CheckPoint("mail sent");

    public MailSender(String recipients, boolean dontNotifyEveryUnstableBuild, boolean sendToIndividuals) {
        this(recipients, dontNotifyEveryUnstableBuild, sendToIndividuals, "UTF-8");
    }

    public MailSender(String recipients, boolean dontNotifyEveryUnstableBuild, boolean sendToIndividuals, String charset) {
        this(recipients, dontNotifyEveryUnstableBuild, sendToIndividuals, charset, Collections.emptyList());
    }

    public MailSender(String recipients, boolean dontNotifyEveryUnstableBuild, boolean sendToIndividuals, String charset, Collection<AbstractProject> includeUpstreamCommitters) {
        this.recipients = recipients;
        this.dontNotifyEveryUnstableBuild = dontNotifyEveryUnstableBuild;
        this.sendToIndividuals = sendToIndividuals;
        this.charset = charset;
        this.includeUpstreamCommitters.addAll(includeUpstreamCommitters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(AbstractBuild<?, ?> build, BuildListener listener) throws InterruptedException {
        try {
            MimeMessage mail = this.getMail(build, listener);
            if (mail != null) {
                Address[] allRecipients;
                AbstractBuild pb = build.getPreviousBuild();
                if (pb != null && pb.getResult() == Result.SUCCESS) {
                    mail.removeHeader("In-Reply-To");
                    mail.removeHeader("References");
                }
                if ((allRecipients = mail.getAllRecipients()) != null) {
                    StringBuilder buf = new StringBuilder("Sending e-mails to:");
                    for (Address a : allRecipients) {
                        buf.append(' ').append(a);
                    }
                    listener.getLogger().println(buf);
                    Transport.send((Message)mail);
                    build.addAction((Action)new MailMessageIdAction(mail.getMessageID()));
                } else {
                    listener.getLogger().println(Messages.MailSender_ListEmpty());
                }
            }
        }
        catch (MessagingException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace(listener.error(e.getMessage()));
        }
        finally {
            CHECKPOINT.report();
        }
        return true;
    }

    private Result findPreviousBuildResult(AbstractBuild<?, ?> b) throws InterruptedException {
        CHECKPOINT.block();
        do {
            if ((b = b.getPreviousBuild()) != null) continue;
            return null;
        } while (b.getResult() == Result.ABORTED || b.getResult() == Result.NOT_BUILT);
        return b.getResult();
    }

    protected MimeMessage getMail(AbstractBuild<?, ?> build, BuildListener listener) throws MessagingException, UnsupportedEncodingException, InterruptedException {
        Result prev;
        if (build.getResult() == Result.FAILURE) {
            return this.createFailureMail(build, listener);
        }
        if (build.getResult() == Result.UNSTABLE) {
            if (!this.dontNotifyEveryUnstableBuild) {
                return this.createUnstableMail(build, listener);
            }
            prev = this.findPreviousBuildResult(build);
            if (prev == Result.SUCCESS) {
                return this.createUnstableMail(build, listener);
            }
        }
        if (build.getResult() == Result.SUCCESS) {
            prev = this.findPreviousBuildResult(build);
            if (prev == Result.FAILURE) {
                return this.createBackToNormalMail(build, Messages.MailSender_BackToNormal_Normal(), listener);
            }
            if (prev == Result.UNSTABLE) {
                return this.createBackToNormalMail(build, Messages.MailSender_BackToNormal_Stable(), listener);
            }
        }
        return null;
    }

    private MimeMessage createBackToNormalMail(AbstractBuild<?, ?> build, String subject, BuildListener listener) throws MessagingException, UnsupportedEncodingException {
        MimeMessage msg = this.createEmptyMail(build, listener);
        msg.setSubject(this.getSubject(build, Messages.MailSender_BackToNormalMail_Subject(subject)), this.charset);
        StringBuilder buf = new StringBuilder();
        this.appendBuildUrl(build, buf);
        msg.setText(buf.toString(), this.charset);
        return msg;
    }

    private MimeMessage createUnstableMail(AbstractBuild<?, ?> build, BuildListener listener) throws MessagingException, UnsupportedEncodingException {
        MimeMessage msg = this.createEmptyMail(build, listener);
        String subject = Messages.MailSender_UnstableMail_Subject();
        AbstractBuild prev = build.getPreviousBuild();
        boolean still = false;
        if (prev != null) {
            if (prev.getResult() == Result.SUCCESS) {
                subject = Messages.MailSender_UnstableMail_ToUnStable_Subject();
            } else if (prev.getResult() == Result.UNSTABLE) {
                subject = Messages.MailSender_UnstableMail_StillUnstable_Subject();
                still = true;
            }
        }
        msg.setSubject(this.getSubject(build, subject), this.charset);
        StringBuilder buf = new StringBuilder();
        if (!(!still || build.getChangeSet().isEmptySet() && prev.getChangeSet().isEmptySet())) {
            this.appendUrl(Util.encode((String)build.getProject().getUrl()) + "changes", buf);
        } else {
            this.appendBuildUrl(build, buf);
        }
        msg.setText(buf.toString(), this.charset);
        return msg;
    }

    private void appendBuildUrl(AbstractBuild<?, ?> build, StringBuilder buf) {
        this.appendUrl(Util.encode((String)build.getUrl()) + (build.getChangeSet().isEmptySet() ? "" : "changes"), buf);
    }

    private void appendUrl(String url, StringBuilder buf) {
        String baseUrl = Mailer.descriptor().getUrl();
        if (baseUrl != null) {
            buf.append(Messages.MailSender_Link(baseUrl, url)).append("\n\n");
        }
    }

    private MimeMessage createFailureMail(AbstractBuild<?, ?> build, BuildListener listener) throws MessagingException, UnsupportedEncodingException, InterruptedException {
        MimeMessage msg = this.createEmptyMail(build, listener);
        msg.setSubject(this.getSubject(build, Messages.MailSender_FailureMail_Subject()), this.charset);
        StringBuilder buf = new StringBuilder();
        this.appendBuildUrl(build, buf);
        boolean firstChange = true;
        for (ChangeLogSet.Entry entry : build.getChangeSet()) {
            if (firstChange) {
                firstChange = false;
                buf.append(Messages.MailSender_FailureMail_Changes()).append("\n\n");
            }
            buf.append('[');
            buf.append(entry.getAuthor().getFullName());
            buf.append("] ");
            String m = entry.getMsg();
            if (m != null) {
                buf.append(m);
                if (!m.endsWith("\n")) {
                    buf.append('\n');
                }
            }
            buf.append('\n');
        }
        buf.append("------------------------------------------\n");
        try {
            List lines = build.getLog(MAX_LOG_LINES);
            String workspaceUrl = null;
            String artifactUrl = null;
            Pattern wsPattern = null;
            String baseUrl = Mailer.descriptor().getUrl();
            if (baseUrl != null) {
                workspaceUrl = baseUrl + Util.encode((String)build.getProject().getUrl()) + "ws/";
                artifactUrl = baseUrl + Util.encode((String)build.getUrl()) + "artifact/";
                FilePath ws = build.getWorkspace();
                wsPattern = Pattern.compile("(" + Pattern.quote(ws.getRemote()) + "|" + Pattern.quote(ws.toURI().toString()) + ")[/\\\\]?([^:#\\s]*)");
            }
            for (String line : lines) {
                line = line.replace('\u0000', ' ');
                if (wsPattern != null) {
                    Matcher m = wsPattern.matcher(line);
                    int pos = 0;
                    while (m.find(pos)) {
                        String path = m.group(2).replace(File.separatorChar, '/');
                        String linkUrl = this.artifactMatches(path, build) ? artifactUrl : workspaceUrl;
                        String prefix = line.substring(0, m.start()) + '<' + linkUrl + Util.encode((String)path) + '>';
                        pos = prefix.length();
                        line = prefix + line.substring(m.end());
                        m = wsPattern.matcher(line);
                    }
                }
                buf.append(line);
                buf.append('\n');
            }
        }
        catch (IOException e) {
            buf.append(Messages.MailSender_FailureMail_FailedToAccessBuildLog()).append("\n\n").append(Functions.printThrowable((Throwable)e));
        }
        msg.setText(buf.toString(), this.charset);
        return msg;
    }

    private MimeMessage createEmptyMail(AbstractBuild<?, ?> build, BuildListener listener) throws MessagingException, UnsupportedEncodingException {
        MailMessageIdAction b;
        MimeMessage msg = new MimeMessage(Mailer.descriptor().createSession());
        msg.addHeader("X-Jenkins-Job", build.getProject().getDisplayName());
        msg.addHeader("X-Jenkins-Result", build.getResult().toString());
        msg.setContent((Object)"", "text/plain");
        msg.setFrom((Address)Mailer.StringToAddress(Mailer.descriptor().getAdminAddress(), this.charset));
        msg.setSentDate(new Date());
        String replyTo = Mailer.descriptor().getReplyToAddress();
        if (StringUtils.isNotBlank((String)replyTo)) {
            msg.setReplyTo(new Address[]{Mailer.StringToAddress(replyTo, this.charset)});
        }
        LinkedHashSet<InternetAddress> rcp = new LinkedHashSet<InternetAddress>();
        String defaultSuffix = Mailer.descriptor().getDefaultSuffix();
        StringTokenizer tokens = new StringTokenizer(this.recipients);
        while (tokens.hasMoreTokens()) {
            String address = tokens.nextToken();
            if (address.startsWith("upstream-individuals:")) {
                String projectName = address.substring("upstream-individuals:".length());
                AbstractProject up = (AbstractProject)Jenkins.getInstance().getItem(projectName, (Item)build.getProject(), AbstractProject.class);
                if (up == null) {
                    listener.getLogger().println("No such project exist: " + projectName);
                    continue;
                }
                this.includeCulpritsOf(up, build, listener, rcp);
                continue;
            }
            if (!address.contains("@") && defaultSuffix != null && defaultSuffix.contains("@")) {
                address = address + defaultSuffix;
            }
            try {
                rcp.add(Mailer.StringToAddress(address, this.charset));
            }
            catch (AddressException e) {
                listener.getLogger().println("Unable to send to address: " + address);
                e.printStackTrace(listener.error(e.getMessage()));
            }
        }
        for (AbstractProject project : this.includeUpstreamCommitters) {
            this.includeCulpritsOf(project, build, listener, rcp);
        }
        if (this.sendToIndividuals) {
            Set culprits = build.getCulprits();
            if (debug) {
                listener.getLogger().println("Trying to send e-mails to individuals who broke the build. sizeof(culprits)==" + culprits.size());
            }
            rcp.addAll(this.buildCulpritList(listener, culprits));
        }
        msg.setRecipients(Message.RecipientType.TO, (Address[])rcp.toArray(new InternetAddress[rcp.size()]));
        AbstractBuild pb = build.getPreviousBuild();
        if (pb != null && (b = (MailMessageIdAction)pb.getAction(MailMessageIdAction.class)) != null) {
            msg.setHeader("In-Reply-To", b.messageId);
            msg.setHeader("References", b.messageId);
        }
        return msg;
    }

    void includeCulpritsOf(AbstractProject upstreamProject, AbstractBuild<?, ?> currentBuild, BuildListener listener, Set<InternetAddress> recipientList) throws AddressException, UnsupportedEncodingException {
        AbstractBuild previousBuildUpstreamBuild;
        AbstractBuild upstreamBuild = currentBuild.getUpstreamRelationshipBuild(upstreamProject);
        AbstractBuild previousBuild = currentBuild.getPreviousBuild();
        AbstractBuild abstractBuild = previousBuildUpstreamBuild = previousBuild != null ? previousBuild.getUpstreamRelationshipBuild(upstreamProject) : null;
        if (previousBuild == null && upstreamBuild == null && previousBuildUpstreamBuild == null) {
            listener.getLogger().println("Unable to compute the changesets in " + upstreamProject + ". Is the fingerprint configured?");
            return;
        }
        if (previousBuild == null || upstreamBuild == null || previousBuildUpstreamBuild == null) {
            listener.getLogger().println("Unable to compute the changesets in " + upstreamProject);
            return;
        }
        AbstractBuild b = previousBuildUpstreamBuild;
        do {
            if ((b = b.getNextBuild()) == null) continue;
            recipientList.addAll(this.buildCulpritList(listener, b.getCulprits()));
        } while (b != upstreamBuild && b != null);
    }

    private Set<InternetAddress> buildCulpritList(BuildListener listener, Set<User> culprits) throws AddressException, UnsupportedEncodingException {
        HashSet<InternetAddress> r = new HashSet<InternetAddress>();
        for (User a : culprits) {
            String adrs = Util.fixEmpty((String)((Mailer.UserProperty)a.getProperty(Mailer.UserProperty.class)).getAddress());
            if (debug) {
                listener.getLogger().println("  User " + a.getId() + " -> " + adrs);
            }
            if (adrs != null) {
                try {
                    r.add(Mailer.StringToAddress(adrs, this.charset));
                }
                catch (AddressException e) {
                    listener.getLogger().println("Invalid address: " + adrs);
                }
                continue;
            }
            listener.getLogger().println(Messages.MailSender_NoAddress(a.getFullName()));
        }
        return r;
    }

    private String getSubject(AbstractBuild<?, ?> build, String caption) {
        return caption + ' ' + build.getFullDisplayName();
    }

    protected boolean artifactMatches(String path, AbstractBuild<?, ?> build) {
        return false;
    }
}

