/*
 * Decompiled with CFR 0.152.
 */
package com.tikal.jenkins.plugins.multijob;

import com.tikal.jenkins.plugins.multijob.LineQueue;
import com.tikal.jenkins.plugins.multijob.MultiJobBuild;
import com.tikal.jenkins.plugins.multijob.MultiJobProject;
import com.tikal.jenkins.plugins.multijob.PhaseJobsConfig;
import com.tikal.jenkins.plugins.multijob.SubTask;
import groovy.util.Eval;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BallColor;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.scm.ChangeLogSet;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectBuilderContributionAction;
import org.jenkinsci.plugins.envinject.service.EnvInjectActionSetter;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVars;
import org.jenkinsci.plugins.envinject.service.EnvInjectVariableGetter;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiJobBuilder
extends Builder
implements DependecyDeclarer {
    public static final String BUILD_ALWAYS_KEY = "hudson.scm.multijob.build.always";
    private static final String[] TRIGGER_MESSAGES = new String[]{"    >> [%s] added to build queue.\n", "    >> [%s] has changes since last build. Adding to build queue.\n", "    >> [%s] has no changes since last build, but it will be adding to build queue.\n", "    >> [%s] has no changes since last build, but you have enabled the 'build always' function. Adding to build queue.\n", "    >> [%s] has no changes since last build, so it will be skipped.\n", "    >> [%s] has been disabled. Skipping it.\n"};
    private String phaseName;
    private List<PhaseJobsConfig> phaseJobs;
    private ContinuationCondition continuationCondition = ContinuationCondition.SUCCESSFUL;

    @DataBoundConstructor
    public MultiJobBuilder(String phaseName, List<PhaseJobsConfig> phaseJobs, ContinuationCondition continuationCondition) {
        this.phaseName = phaseName;
        this.phaseJobs = Util.fixNull(phaseJobs);
        this.continuationCondition = continuationCondition;
    }

    public String expandToken(String toExpand, AbstractBuild<?, ?> build, BuildListener listener) {
        String expandedExpression = toExpand;
        try {
            expandedExpression = TokenMacro.expandAll(build, (TaskListener)listener, (String)toExpand, (boolean)false, null);
        }
        catch (Exception e) {
            listener.getLogger().println(e.getMessage());
        }
        Pattern pattern = Pattern.compile("(\\$\\{.+?\\})", 2);
        Matcher matcher = pattern.matcher(expandedExpression);
        return matcher.replaceAll("");
    }

    private int getScmChange(AbstractProject subjob, PhaseJobsConfig phaseConfig, AbstractBuild build, BuildListener listener, Launcher launcher) throws IOException, InterruptedException {
        boolean containsLastBuild = subjob.getLastBuild() != null;
        SCM scm = subjob.getScm();
        SCMRevisionState scmRS = containsLastBuild ? scm.calcRevisionsFromBuild(subjob.getLastBuild(), launcher, (TaskListener)listener) : null;
        boolean hasChanges = containsLastBuild ? scm.poll(subjob, launcher, subjob.getWorkspace(), (TaskListener)listener, scmRS).hasChanges() : true;
        boolean buildOnlyIfSCMChanges = phaseConfig.isBuildOnlyIfSCMChanges();
        boolean buildAlways = Boolean.valueOf((String)build.getBuildVariables().get(BUILD_ALWAYS_KEY));
        int message = !buildOnlyIfSCMChanges ? 0 : (hasChanges ? 1 : (!buildOnlyIfSCMChanges ? 2 : (buildAlways ? 3 : 4)));
        listener.getLogger().printf(TRIGGER_MESSAGES[message], subjob.getName());
        return message;
    }

    public boolean evalCondition(String condition, AbstractBuild<?, ?> build, BuildListener listener) {
        try {
            return (Boolean)Eval.me((String)this.expandToken(condition, build, listener).toLowerCase().trim());
        }
        catch (Exception e) {
            listener.getLogger().println("Can't evaluate expression, false is assumed.");
            listener.getLogger().println(e.toString());
            return false;
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Jenkins jenkins = Jenkins.getInstance();
        MultiJobBuild multiJobBuild = (MultiJobBuild)build;
        MultiJobProject thisProject = (MultiJobProject)multiJobBuild.getProject();
        HashMap<PhaseSubJob, PhaseJobsConfig> phaseSubJobs = new HashMap<PhaseSubJob, PhaseJobsConfig>(this.phaseJobs.size());
        for (PhaseJobsConfig phaseJobConfig : this.phaseJobs) {
            Item item = jenkins.getItemByFullName(phaseJobConfig.getJobName());
            if (!(item instanceof AbstractProject)) continue;
            AbstractProject job = (AbstractProject)item;
            phaseSubJobs.put(new PhaseSubJob(job), phaseJobConfig);
        }
        ArrayList<SubTask> subTasks = new ArrayList<SubTask>();
        for (PhaseSubJob phaseSubJob : phaseSubJobs.keySet()) {
            AbstractProject subJob = phaseSubJob.job;
            if (subJob.isDisabled()) {
                listener.getLogger().println(String.format("Skipping %s. This Job has been disabled.", subJob.getName()));
                continue;
            }
            PhaseJobsConfig phaseConfig = (PhaseJobsConfig)phaseSubJobs.get(phaseSubJob);
            if (phaseConfig.getEnableCondition() && phaseConfig.getCondition() != null && !this.evalCondition(phaseConfig.getCondition(), build, listener)) {
                listener.getLogger().println(String.format("Skipping %s. Condition is evaluate to false.", subJob.getName()));
                continue;
            }
            if (phaseConfig.isBuildOnlyIfSCMChanges() && this.getScmChange(subJob, phaseConfig, (AbstractBuild)multiJobBuild, listener, launcher) >= 4) continue;
            this.reportStart(listener, subJob);
            ArrayList<Action> actions = new ArrayList<Action>();
            this.prepareActions((AbstractBuild)multiJobBuild, subJob, phaseConfig, listener, actions);
            while (subJob.isInQueue()) {
                TimeUnit.SECONDS.sleep(subJob.getQuietPeriod());
            }
            if (!phaseConfig.isDisableJob()) {
                subTasks.add(new SubTask(subJob, phaseConfig, actions, multiJobBuild));
                continue;
            }
            listener.getLogger().println(String.format("Warning: %s subjob is disabled.", subJob.getName()));
        }
        if (subTasks.size() < 1) {
            return true;
        }
        ExecutorService executor = Executors.newFixedThreadPool(subTasks.size());
        HashSet<Result> jobResults = new HashSet<Result>();
        ArrayBlockingQueue<SubTask> queue = new ArrayBlockingQueue<SubTask>(subTasks.size());
        for (SubTask subTask : subTasks) {
            SubJobWorker worker = new SubJobWorker(thisProject, listener, subTask, queue);
            executor.execute(worker);
        }
        try {
            executor.shutdown();
            int resultCounter = 0;
            while (!executor.isTerminated()) {
                SubTask subTask;
                subTask = (SubTask)queue.take();
                ++resultCounter;
                if (subTask.result != null) {
                    jobResults.add(subTask.result);
                    this.checkPhaseTermination(subTask, subTasks, listener);
                }
                if (subTasks.size() != resultCounter) continue;
                break;
            }
            executor.shutdownNow();
        }
        catch (InterruptedException exception) {
            listener.getLogger().println("Aborting all subjobs.");
            for (SubTask _subTask : subTasks) {
                _subTask.cancelJob();
            }
            for (int i = 0; !executor.isTerminated() && i < 20; ++i) {
                Thread.sleep(1000L);
            }
            throw new InterruptedException();
        }
        for (Result result : jobResults) {
            if (this.continuationCondition.isContinue(result)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkPhaseTermination(SubTask subTask, List<SubTask> subTasks, BuildListener listener) {
        try {
            PhaseJobsConfig.KillPhaseOnJobResultCondition killCondition = subTask.phaseConfig.getKillPhaseOnJobResultCondition();
            if (killCondition.equals((Object)PhaseJobsConfig.KillPhaseOnJobResultCondition.NEVER)) {
                return false;
            }
            if (killCondition.isKillPhase(subTask.result) && (subTask.result != Result.ABORTED || subTask.phaseConfig.getAbortAllJob())) {
                for (SubTask _subTask : subTasks) {
                    _subTask.cancelJob();
                }
                return true;
            }
        }
        catch (Exception e) {
            listener.getLogger().printf(e.toString(), new Object[0]);
            return false;
        }
        return false;
    }

    private void reportStart(BuildListener listener, AbstractProject subJob) {
        listener.getLogger().printf("Starting build job %s.\n", HyperlinkNote.encodeTo((String)('/' + subJob.getUrl()), (String)subJob.getFullName()));
    }

    private void reportFinish(BuildListener listener, AbstractBuild jobBuild, Result result) {
        listener.getLogger().println("Finished Build : " + HyperlinkNote.encodeTo((String)("/" + jobBuild.getUrl() + "/"), (String)String.valueOf(jobBuild.getDisplayName())) + " of Job : " + HyperlinkNote.encodeTo((String)('/' + jobBuild.getProject().getUrl()), (String)jobBuild.getProject().getFullName()) + " with status : " + HyperlinkNote.encodeTo((String)('/' + jobBuild.getUrl() + "/console"), (String)result.toString()));
    }

    private void updateSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, PhaseJobsConfig phaseConfig) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), phaseConfig.getJobName(), 0, this.phaseName, null, BallColor.NOTBUILT.getImage(), "not built", "");
        multiJobBuild.addSubBuild(subBuild);
    }

    private void updateSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, AbstractBuild jobBuild) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), jobBuild.getProject().getName(), jobBuild.getNumber(), this.phaseName, null, jobBuild.getIconColor().getImage(), jobBuild.getDurationString(), jobBuild.getUrl());
        multiJobBuild.addSubBuild(subBuild);
    }

    private void updateSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, AbstractBuild jobBuild, Result result) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), jobBuild.getProject().getName(), jobBuild.getNumber(), this.phaseName, result, jobBuild.getIconColor().getImage(), jobBuild.getDurationString(), jobBuild.getUrl());
        multiJobBuild.addSubBuild(subBuild);
    }

    private void updateSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, AbstractBuild jobBuild, Result result, boolean retry) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), jobBuild.getProject().getName(), jobBuild.getNumber(), this.phaseName, result, jobBuild.getIconColor().getImage(), jobBuild.getDurationString(), jobBuild.getUrl(), retry, false);
        multiJobBuild.addSubBuild(subBuild);
    }

    private void abortSubBuild(MultiJobBuild multiJobBuild, MultiJobProject multiJobProject, AbstractBuild jobBuild) {
        MultiJobBuild.SubBuild subBuild = new MultiJobBuild.SubBuild(multiJobProject.getName(), multiJobBuild.getNumber(), jobBuild.getProject().getName(), jobBuild.getNumber(), this.phaseName, Result.ABORTED, BallColor.ABORTED.getImage(), "", jobBuild.getUrl(), false, true);
        multiJobBuild.addSubBuild(subBuild);
    }

    private void addBuildEnvironmentVariables(MultiJobBuild thisBuild, AbstractBuild jobBuild, BuildListener listener) {
        HashMap<String, String> variables = new HashMap<String, String>();
        String jobName = jobBuild.getProject().getName();
        String jobNameSafe = jobName.replaceAll("[^A-Za-z0-9]", "_").toUpperCase();
        String buildNumber = Integer.toString(jobBuild.getNumber());
        String buildResult = jobBuild.getResult().toString();
        variables.put("LAST_TRIGGERED_JOB_NAME", jobName);
        variables.put(jobNameSafe + "_BUILD_NUMBER", buildNumber);
        variables.put(jobNameSafe + "_BUILD_RESULT", buildResult);
        if (variables.get("TRIGGERED_JOB_NAMES") == null) {
            variables.put("TRIGGERED_JOB_NAMES", jobName);
        } else {
            String triggeredJobNames = (String)variables.get("TRIGGERED_JOB_NAMES") + "," + jobName;
            variables.put("TRIGGERED_JOB_NAMES", triggeredJobNames);
        }
        if (variables.get("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe) == null) {
            variables.put("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe, "1");
        } else {
            String runCount = Integer.toString(Integer.parseInt((String)variables.get("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe)) + 1);
            variables.put("TRIGGERED_BUILD_RUN_COUNT_" + jobNameSafe, runCount);
        }
        this.injectEnvVars((AbstractBuild<?, ?>)thisBuild, listener, (Map<String, String>)variables);
    }

    private void injectEnvVars(AbstractBuild<?, ?> build, BuildListener listener, Map<String, String> incomingVars) {
        if (build != null && incomingVars != null) {
            EnvInjectLogger logger = new EnvInjectLogger((TaskListener)listener);
            FilePath ws = build.getWorkspace();
            EnvInjectActionSetter envInjectActionSetter = new EnvInjectActionSetter(ws);
            EnvInjectEnvVars envInjectEnvVarsService = new EnvInjectEnvVars(logger);
            try {
                EnvInjectVariableGetter variableGetter = new EnvInjectVariableGetter();
                Map previousEnvVars = variableGetter.getEnvVarsPreviousSteps(build, logger);
                HashMap variables = new HashMap(previousEnvVars);
                Map resultVariables = envInjectEnvVarsService.getMergedVariables(variables, incomingVars);
                build.addAction((Action)new EnvInjectBuilderContributionAction(resultVariables));
                envInjectActionSetter.addEnvVarsToEnvInjectBuildAction(build, resultVariables);
            }
            catch (Throwable throwable) {
                listener.getLogger().println("[MultiJob] - [ERROR] - Problems occurs on injecting env vars as a build step: " + throwable.getMessage());
            }
        }
    }

    private void prepareActions(AbstractBuild build, AbstractProject project, PhaseJobsConfig projectConfig, BuildListener listener, List<Action> actions) throws IOException, InterruptedException {
        List<Action> parametersActions = null;
        parametersActions = projectConfig.getActions(build, (TaskListener)listener, project, projectConfig.isCurrParams());
        actions.addAll(parametersActions);
    }

    public String getPhaseName() {
        return this.phaseName;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public List<PhaseJobsConfig> getPhaseJobs() {
        return this.phaseJobs;
    }

    public void setPhaseJobs(List<PhaseJobsConfig> phaseJobs) {
        this.phaseJobs = phaseJobs;
    }

    public boolean phaseNameExist(String phaseName) {
        for (PhaseJobsConfig phaseJob : this.phaseJobs) {
            if (!phaseJob.getDisplayName().equals(phaseName)) continue;
            return true;
        }
        return false;
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        Jenkins jenkins = Jenkins.getInstance();
        List<PhaseJobsConfig> phaseJobsConfigs = this.getPhaseJobs();
        if (phaseJobsConfigs == null) {
            return;
        }
        for (PhaseJobsConfig project : phaseJobsConfigs) {
            Item topLevelItem = jenkins.getItemByFullName(project.getJobName());
            if (!(topLevelItem instanceof AbstractProject)) continue;
            DependencyGraph.Dependency dependency = new DependencyGraph.Dependency(owner, (AbstractProject)topLevelItem){

                public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
                    return false;
                }
            };
            graph.addDependency(dependency);
        }
    }

    public boolean onJobRenamed(String oldName, String newName) {
        boolean changed = false;
        Iterator<PhaseJobsConfig> i = this.phaseJobs.iterator();
        while (i.hasNext()) {
            PhaseJobsConfig phaseJobs = i.next();
            String jobName = phaseJobs.getJobName();
            if (!jobName.trim().equals(oldName)) continue;
            if (newName != null) {
                phaseJobs.setJobName(newName);
                changed = true;
                continue;
            }
            i.remove();
            changed = true;
        }
        return changed;
    }

    public boolean onJobDeleted(String oldName) {
        return this.onJobRenamed(oldName, null);
    }

    public ContinuationCondition getContinuationCondition() {
        return this.continuationCondition;
    }

    public void setContinuationCondition(ContinuationCondition continuationCondition) {
        this.continuationCondition = continuationCondition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContinuationCondition {
        SUCCESSFUL("Successful"){

            public boolean isContinue(Result result) {
                return result.equals(Result.SUCCESS);
            }
        }
        ,
        UNSTABLE("Stable or Unstable but not Failed"){

            public boolean isContinue(Result result) {
                return result.isBetterOrEqualTo(Result.UNSTABLE);
            }
        }
        ,
        COMPLETED("Complete (always continue)"){

            public boolean isContinue(Result result) {
                return result.equals(Result.ABORTED) ? true : result.isBetterOrEqualTo(Result.FAILURE);
            }
        }
        ,
        FAILURE("Failed"){

            public boolean isContinue(Result result) {
                return result.equals(Result.ABORTED) || result.isBetterOrEqualTo(Result.FAILURE);
            }
        };

        private final String label;

        public abstract boolean isContinue(Result var1);

        private ContinuationCondition(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return jobType.equals(MultiJobProject.class);
        }

        public String getDisplayName() {
            return "MultiJob Phase";
        }

        public Builder newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(MultiJobBuilder.class, formData);
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            this.save();
            return true;
        }
    }

    private static final class PhaseSubJob {
        AbstractProject job;

        PhaseSubJob(AbstractProject job) {
            this.job = job;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class SubJobWorker
    extends Thread {
        private final MultiJobProject multiJobProject;
        private final BuildListener listener;
        private SubTask subTask;
        private BlockingQueue<SubTask> queue;
        private List<Pattern> compiledPatterns;

        public SubJobWorker(MultiJobProject multiJobProject, BuildListener listener, SubTask subTask, BlockingQueue<SubTask> queue) {
            this.multiJobProject = multiJobProject;
            this.listener = listener;
            this.subTask = subTask;
            this.queue = queue;
        }

        @Override
        public void run() {
            Result result = null;
            AbstractBuild jobBuild = null;
            try {
                int maxRetries = this.subTask.phaseConfig.getMaxRetries();
                if (!this.subTask.phaseConfig.getEnableRetryStrategy()) {
                    maxRetries = 0;
                }
                int retry = 0;
                boolean finish = false;
                while (retry <= maxRetries && !finish) {
                    ++retry;
                    QueueTaskFuture future = (QueueTaskFuture)this.subTask.future;
                    while (true) {
                        if (this.subTask.isCancelled() && jobBuild != null) {
                            Executor exect = jobBuild.getExecutor();
                            if (exect != null) {
                                exect.interrupt(Result.ABORTED);
                            }
                            MultiJobBuilder.this.reportFinish(this.listener, jobBuild, Result.ABORTED);
                            MultiJobBuilder.this.abortSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild);
                            finish = true;
                            break;
                        }
                        try {
                            jobBuild = (AbstractBuild)future.getStartCondition().get(5L, TimeUnit.SECONDS);
                        }
                        catch (Exception e) {
                            if (e instanceof TimeoutException) continue;
                            throw e;
                        }
                        MultiJobBuilder.this.updateSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild);
                        if (future.isDone()) break;
                        Thread.sleep(2500L);
                    }
                    if (jobBuild == null || finish) continue;
                    result = jobBuild.getResult();
                    MultiJobBuilder.this.reportFinish(this.listener, jobBuild, result);
                    if (result.isWorseOrEqualTo(Result.FAILURE) && result.isCompleteBuild()) {
                        if (this.isKnownRandomFailure(jobBuild)) {
                            if (retry <= maxRetries) {
                                this.listener.getLogger().println("Known failure detected, retrying this build. Try " + retry + " of " + maxRetries + ".");
                                MultiJobBuilder.this.updateSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild, result, true);
                                this.subTask.GenerateFuture();
                            } else {
                                this.listener.getLogger().println("Known failure detected, max retries (" + maxRetries + ") exceeded.");
                                MultiJobBuilder.this.updateSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild, result);
                            }
                        } else {
                            this.listener.getLogger().println("Failed the build, the failure doesn't match the rules.");
                            MultiJobBuilder.this.updateSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild, result);
                            finish = true;
                        }
                    } else {
                        MultiJobBuilder.this.updateSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild, result);
                        finish = true;
                    }
                    ChangeLogSet changeLogSet = jobBuild.getChangeSet();
                    this.subTask.multiJobBuild.addChangeLogSet((ChangeLogSet<? extends ChangeLogSet.Entry>)changeLogSet);
                    MultiJobBuilder.this.addBuildEnvironmentVariables(this.subTask.multiJobBuild, jobBuild, this.listener);
                    this.subTask.result = result;
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    if (jobBuild != null) {
                        MultiJobBuilder.this.reportFinish(this.listener, jobBuild, Result.ABORTED);
                        MultiJobBuilder.this.abortSubBuild(this.subTask.multiJobBuild, this.multiJobProject, jobBuild);
                        this.subTask.result = Result.ABORTED;
                    }
                }
                this.listener.getLogger().println(e.toString());
                e.printStackTrace();
            }
            if (jobBuild == null) {
                MultiJobBuilder.this.updateSubBuild(this.subTask.multiJobBuild, this.multiJobProject, this.subTask.phaseConfig);
            }
            this.queue.add(this.subTask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Pattern> getCompiledPattern() throws FileNotFoundException, InterruptedException {
            if (this.compiledPatterns == null) {
                this.compiledPatterns = new ArrayList<Pattern>();
                try {
                    this.listener.getLogger().println("Scanning failed job console output using parsing rule file " + this.subTask.phaseConfig.getParsingRulesPath() + ".");
                    File rulesFile = new File(this.subTask.phaseConfig.getParsingRulesPath());
                    BufferedReader reader = new BufferedReader(new FileReader(rulesFile.getAbsolutePath()));
                    try {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            this.compiledPatterns.add(Pattern.compile(line));
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    if (e instanceof InterruptedException) {
                        throw new InterruptedException();
                    }
                    if (e instanceof FileNotFoundException) {
                        throw new FileNotFoundException();
                    }
                    this.listener.getLogger().println(e.toString());
                    e.printStackTrace();
                }
            }
            return this.compiledPatterns;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isKnownRandomFailure(AbstractBuild build) throws InterruptedException {
            boolean failure = false;
            try {
                List<Pattern> patterns = this.getCompiledPattern();
                File logFile = build.getLogFile();
                BufferedReader reader = new BufferedReader(new FileReader(logFile.getAbsolutePath()));
                try {
                    int numberOfThreads = 10;
                    if (numberOfThreads < 0) {
                        numberOfThreads = 1;
                    }
                    ExecutorService executorAnalyser = Executors.newFixedThreadPool(numberOfThreads);
                    ArrayBlockingQueue<LineQueue> finishQueue = new ArrayBlockingQueue<LineQueue>(numberOfThreads);
                    for (int i = 0; i < numberOfThreads; ++i) {
                        LineAnalyser worker = new LineAnalyser(reader, patterns, finishQueue);
                        executorAnalyser.execute(worker);
                    }
                    executorAnalyser.shutdown();
                    int resultCounter = 0;
                    while (!executorAnalyser.isTerminated()) {
                        ++resultCounter;
                        LineQueue lineQueue = (LineQueue)finishQueue.take();
                        if (lineQueue.hasError()) {
                            failure = true;
                            break;
                        }
                        if (numberOfThreads != resultCounter) continue;
                        break;
                    }
                    executorAnalyser.shutdownNow();
                }
                finally {
                    reader.close();
                }
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    throw new InterruptedException();
                }
                if (e instanceof FileNotFoundException) {
                    this.listener.getLogger().println("Parser rules file not found.");
                    failure = false;
                }
                this.listener.getLogger().println(e.toString());
                e.printStackTrace();
            }
            return failure;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class LineAnalyser
        extends Thread {
            private final BufferedReader reader;
            private final List<Pattern> patterns;
            private BlockingQueue<LineQueue> finishQueue;

            public LineAnalyser(BufferedReader reader, List<Pattern> patterns, BlockingQueue<LineQueue> finishQueue) {
                this.reader = reader;
                this.patterns = patterns;
                this.finishQueue = finishQueue;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean errorFound = false;
                try {
                    block5: while (this.reader.ready() && !errorFound) {
                        String line = this.reader.readLine();
                        if (line == null) continue;
                        for (Pattern pattern : this.patterns) {
                            if (!pattern.matcher(line).find()) continue;
                            errorFound = true;
                            continue block5;
                        }
                    }
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                    } else {
                        SubJobWorker.this.listener.getLogger().println(e.toString());
                        e.printStackTrace();
                    }
                }
                finally {
                    this.finishQueue.add(new LineQueue(errorFound));
                }
            }
        }
    }
}

