/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.scm.browsers.QueryBuilder;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class Stash
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public Stash(String repoUrl) {
        super(repoUrl);
    }

    private QueryBuilder param(URL url) {
        return new QueryBuilder(url.getQuery());
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        URL url = this.getUrl();
        return new URL(url, url.getPath() + "commits/" + changeSet.getId());
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        if (path.getEditType() == EditType.DELETE) {
            return new URL(url, url.getPath() + "diff/" + path.getPath() + this.param(url).add("at=" + changeSet.getParentCommit()).add("until=" + changeSet.getId()).toString());
        }
        return new URL(url, url.getPath() + "diff/" + path.getPath() + this.param(url).add("at=" + changeSet.getId()).add("until=" + changeSet.getId()).toString());
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        URL url = this.getUrl();
        if (path.getEditType() == EditType.DELETE) {
            return new URL(url, url.getPath() + "browse/" + path.getPath() + this.param(url).add("at=" + changeSet.getParentCommit()).toString());
        }
        return new URL(url, url.getPath() + "browse/" + path.getPath() + this.param(url).add("at=" + changeSet.getId()).toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class StashDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return "stash";
        }

        public Stash newInstance(StaplerRequest req, JSONObject jsonObject) throws Descriptor.FormException {
            return (Stash)((Object)req.bindJSON(Stash.class, jsonObject));
        }
    }
}

