/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildCauseRetriever {
    public static final String ENV_CAUSE = "BUILD_CAUSE";

    public Map<String, String> getTriggeredCause(AbstractBuild<?, ?> build) {
        HashMap<String, String> triggerVars = new HashMap<String, String>();
        StringBuilder all = new StringBuilder();
        CauseAction causeAction = (CauseAction)build.getAction(CauseAction.class);
        List buildCauses = causeAction.getCauses();
        for (Cause cause : buildCauses) {
            String name = BuildCauseRetriever.getTriggerName(cause);
            if (StringUtils.isBlank((String)name)) continue;
            triggerVars.put("BUILD_CAUSE_" + name, "true");
            all.append(",");
            all.append(name);
        }
        triggerVars.put(ENV_CAUSE, all.toString().substring(1));
        return triggerVars;
    }

    private static String getTriggerName(Cause cause) {
        if (SCMTrigger.SCMTriggerCause.class.isInstance(cause)) {
            return "SCMTRIGGER";
        }
        if (TimerTrigger.TimerTriggerCause.class.isInstance(cause)) {
            return "TIMERTRIGGER";
        }
        if (Cause.UserIdCause.class.isInstance(cause)) {
            return "MANUALTRIGGER";
        }
        if (Cause.UserCause.class.isInstance(cause)) {
            return "MANUALTRIGGER";
        }
        if (Cause.UpstreamCause.class.isInstance(cause)) {
            return "UPSTREAMTRIGGER";
        }
        if (cause != null) {
            return cause.getClass().getSimpleName().toUpperCase();
        }
        return null;
    }
}

