/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.ExtensionPoint;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectFactoryDescriptor;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceOwner;

public abstract class MultiBranchProjectFactory
extends AbstractDescribableImpl<MultiBranchProjectFactory>
implements ExtensionPoint {
    public boolean recognizes(@Nonnull ItemGroup<?> parent, @Nonnull String name, @Nonnull List<? extends SCMSource> scmSources, @Nonnull Map<String, Object> attributes, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        if (Util.isOverridden(MultiBranchProjectFactory.class, ((Object)((Object)this)).getClass(), (String)"createProject", (Class[])new Class[]{ItemGroup.class, String.class, List.class, Map.class, TaskListener.class})) {
            return this.createProject(parent, name, scmSources, attributes, listener) != null;
        }
        throw new AbstractMethodError(((Object)((Object)this)).getClass().getName() + " must override recognizes");
    }

    @Nonnull
    public MultiBranchProject<?, ?> createNewProject(@Nonnull ItemGroup<?> parent, @Nonnull String name, @Nonnull List<? extends SCMSource> scmSources, @Nonnull Map<String, Object> attributes, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        if (Util.isOverridden(MultiBranchProjectFactory.class, ((Object)((Object)this)).getClass(), (String)"createProject", (Class[])new Class[]{ItemGroup.class, String.class, List.class, Map.class, TaskListener.class})) {
            MultiBranchProject<?, ?> p = this.createProject(parent, name, scmSources, attributes, listener);
            if (p == null) {
                throw new IOException("recognized project " + name + " before, but now");
            }
            return p;
        }
        throw new AbstractMethodError(((Object)((Object)this)).getClass().getName() + " must override createNewProject");
    }

    public void updateExistingProject(MultiBranchProject<?, ?> project, @Nonnull Map<String, Object> attributes, @Nonnull TaskListener listener) throws IOException, InterruptedException {
    }

    @Deprecated
    @CheckForNull
    public MultiBranchProject<?, ?> createProject(@Nonnull ItemGroup<?> parent, @Nonnull String name, @Nonnull List<? extends SCMSource> scmSources, @Nonnull Map<String, Object> attributes, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        if (this.recognizes(parent, name, scmSources, attributes, listener)) {
            return this.createNewProject(parent, name, scmSources, attributes, listener);
        }
        return null;
    }

    public MultiBranchProjectFactoryDescriptor getDescriptor() {
        return (MultiBranchProjectFactoryDescriptor)super.getDescriptor();
    }

    public static abstract class BySCMSourceCriteria
    extends MultiBranchProjectFactory {
        @Nonnull
        protected abstract SCMSourceCriteria getSCMSourceCriteria(@Nonnull SCMSource var1);

        @Nonnull
        protected abstract MultiBranchProject<?, ?> doCreateProject(@Nonnull ItemGroup<?> var1, @Nonnull String var2, @Nonnull Map<String, Object> var3);

        @Override
        public final MultiBranchProject<?, ?> createNewProject(ItemGroup<?> parent, String name, List<? extends SCMSource> scmSources, Map<String, Object> attributes, TaskListener listener) throws IOException, InterruptedException {
            return this.doCreateProject(parent, name, attributes);
        }

        @Override
        public boolean recognizes(ItemGroup<?> parent, String name, List<? extends SCMSource> scmSources, Map<String, Object> attributes, final TaskListener listener) throws IOException, InterruptedException {
            for (final SCMSource sCMSource : scmSources) {
                boolean empty;
                SCMSourceOwner owner = sCMSource.getOwner();
                if (!(owner instanceof SCMSourceOwnerHack)) {
                    throw new IOException("cannot influence criteria on " + owner);
                }
                try {
                    empty = ((SCMSourceOwnerHack)owner).withSCMSourceCriteria(sCMSource, this.getSCMSourceCriteria(sCMSource), new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return sCMSource.fetch(listener).isEmpty();
                        }
                    });
                }
                catch (IOException x) {
                    throw x;
                }
                catch (InterruptedException x) {
                    throw x;
                }
                catch (RuntimeException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new AssertionError((Object)x);
                }
                if (empty) continue;
                return true;
            }
            return false;
        }
    }

    static interface SCMSourceOwnerHack
    extends SCMSourceOwner {
        public <T> T withSCMSourceCriteria(@Nonnull SCMSource var1, @Nonnull SCMSourceCriteria var2, @Nonnull Callable<T> var3) throws Exception;
    }
}

