/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks._ant;

import hudson.console.LineTransformationOutputStream;
import hudson.tasks._ant.AntOutcomeNote;
import hudson.tasks._ant.AntTargetNote;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class AntConsoleAnnotator
extends LineTransformationOutputStream {
    private final OutputStream out;
    private final Charset charset;
    private boolean seenEmptyLine;

    public AntConsoleAnnotator(OutputStream out, Charset charset) {
        this.out = out;
        this.charset = charset;
    }

    protected void eol(byte[] b, int len) throws IOException {
        String line = this.charset.decode(ByteBuffer.wrap(b, 0, len)).toString();
        line = this.trimEOL(line);
        if (this.seenEmptyLine && this.endsWith(line, ':') && line.indexOf(32) < 0) {
            new AntTargetNote().encodeTo(this.out);
        }
        if (line.equals("BUILD SUCCESSFUL") || line.equals("BUILD FAILED")) {
            new AntOutcomeNote().encodeTo(this.out);
        }
        this.seenEmptyLine = line.length() == 0;
        this.out.write(b, 0, len);
    }

    private boolean endsWith(String line, char c) {
        int len = line.length();
        return len > 0 && line.charAt(len - 1) == c;
    }

    public void close() throws IOException {
        super.close();
        this.out.close();
    }
}

