/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.slaves.NodeSpecific;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks._ant.AntConsoleAnnotator;
import hudson.tasks._ant.Messages;
import hudson.tools.DownloadFromUrlInstaller;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ant
extends Builder {
    private final String targets;
    private final String antName;
    private final String antOpts;
    private final String buildFile;
    private final String properties;

    @DataBoundConstructor
    public Ant(String targets, String antName, String antOpts, String buildFile, String properties) {
        this.targets = targets;
        this.antName = antName;
        this.antOpts = Util.fixEmptyAndTrim((String)antOpts);
        this.buildFile = Util.fixEmptyAndTrim((String)buildFile);
        this.properties = Util.fixEmptyAndTrim((String)properties);
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public String getProperties() {
        return this.properties;
    }

    public String getTargets() {
        return this.targets;
    }

    public AntInstallation getAnt() {
        for (AntInstallation i : this.getDescriptor().getInstallations()) {
            if (this.antName == null || !this.antName.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    public String getAntOpts() {
        return this.antOpts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        AntInstallation ai = this.getAnt();
        if (ai == null) {
            args.add(launcher.isUnix() ? "ant" : "ant.bat");
        } else {
            ai = ai.forNode(Computer.currentComputer().getNode(), (TaskListener)listener);
            String exe = (ai = ai.forEnvironment(env)).getExecutable(launcher);
            if (exe == null) {
                listener.fatalError(Messages.Ant_ExecutableNotFound(ai.getName()));
                return false;
            }
            args.add(exe);
        }
        VariableResolver.ByMap vr = new VariableResolver.ByMap((Map)env);
        String buildFile = env.expand(this.buildFile);
        String targets = env.expand(this.targets);
        FilePath buildFilePath = Ant.buildFilePath(build.getModuleRoot(), buildFile, targets);
        if (!buildFilePath.exists()) {
            FilePath buildFilePath2 = Ant.buildFilePath(build.getWorkspace(), buildFile, targets);
            if (buildFilePath2.exists()) {
                buildFilePath = buildFilePath2;
            } else {
                listener.fatalError("Unable to find build script at " + buildFilePath);
                return false;
            }
        }
        if (buildFile != null) {
            args.add(new String[]{"-file", buildFilePath.getName()});
        }
        Set sensitiveVars = build.getSensitiveBuildVariables();
        args.addKeyValuePairs("-D", build.getBuildVariables(), sensitiveVars);
        args.addKeyValuePairsFromPropertyString("-D", this.properties, (VariableResolver)vr, sensitiveVars);
        args.addTokenized(targets.replaceAll("[\t\r\n]+", " "));
        if (ai != null) {
            ai.buildEnvVars(env);
        }
        if (this.antOpts != null) {
            env.put("ANT_OPTS", env.expand(this.antOpts));
        }
        if (!launcher.isUnix()) {
            args = args.toWindowsCommand();
            ArrayList<String> newArgs = new ArrayList<String>(args.toList());
            newArgs.set(newArgs.size() - 1, ((String)newArgs.get(newArgs.size() - 1)).replaceAll("(?<= )(-D[^\" ]+)= ", "$1=\"\" "));
            args = new ArgumentListBuilder(newArgs.toArray(new String[newArgs.size()]));
        }
        long startTime = System.currentTimeMillis();
        try {
            int r;
            AntConsoleAnnotator aca = new AntConsoleAnnotator(listener.getLogger(), build.getCharset());
            try {
                r = launcher.launch().cmds(args).envs((Map)env).stdout((OutputStream)((Object)aca)).pwd(buildFilePath.getParent()).join();
            }
            finally {
                aca.forceEol();
            }
            return r == 0;
        }
        catch (IOException e) {
            Util.displayIOException((IOException)e, (TaskListener)listener);
            String errorMessage = Messages.Ant_ExecFailed();
            if (ai == null && System.currentTimeMillis() - startTime < 1000L) {
                errorMessage = this.getDescriptor().getInstallations() == null ? errorMessage + Messages.Ant_GlobalConfigNeeded() : errorMessage + Messages.Ant_ProjectConfigNeeded();
            }
            e.printStackTrace(listener.fatalError(errorMessage));
            return false;
        }
    }

    private static FilePath buildFilePath(FilePath base, String buildFile, String targets) {
        if (buildFile != null) {
            return base.child(buildFile);
        }
        String[] tokens = Util.tokenize((String)targets);
        for (int i = 0; i < tokens.length - 1; ++i) {
            String a = tokens[i];
            if (!a.equals("-f") && !a.equals("-file") && !a.equals("-buildfile")) continue;
            return base.child(tokens[i + 1]);
        }
        return base.child("build.xml");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static class AntInstaller
    extends DownloadFromUrlInstaller {
        @DataBoundConstructor
        public AntInstaller(String id) {
            super(id);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static final class DescriptorImpl
        extends DownloadFromUrlInstaller.DescriptorImpl<AntInstaller> {
            public String getDisplayName() {
                return Messages.InstallFromApache();
            }

            public boolean isApplicable(Class<? extends ToolInstallation> toolType) {
                return toolType == AntInstallation.class;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AntInstallation
    extends ToolInstallation
    implements EnvironmentSpecific<AntInstallation>,
    NodeSpecific<AntInstallation> {
        @Deprecated
        private transient String antHome;
        private static final long serialVersionUID = 1L;

        @DataBoundConstructor
        public AntInstallation(String name, String home, List<? extends ToolProperty<?>> properties) {
            super(name, AntInstallation.launderHome(home), properties);
        }

        public AntInstallation(String name, String home) {
            this(name, home, Collections.emptyList());
        }

        private static String launderHome(String home) {
            if (home.endsWith("/") || home.endsWith("\\")) {
                return home.substring(0, home.length() - 1);
            }
            return home;
        }

        public String getAntHome() {
            return this.getHome();
        }

        public void buildEnvVars(EnvVars env) {
            env.put("ANT_HOME", this.getHome());
        }

        public String getExecutable(Launcher launcher) throws IOException, InterruptedException {
            return (String)launcher.getChannel().call((Callable)new Callable<String, IOException>(){

                public String call() throws IOException {
                    File exe = AntInstallation.this.getExeFile();
                    if (exe.exists()) {
                        return exe.getPath();
                    }
                    return null;
                }
            });
        }

        private File getExeFile() {
            String execName = Functions.isWindows() ? "ant.bat" : "ant";
            String home = Util.replaceMacro((String)this.getHome(), (Map)EnvVars.masterEnvVars);
            return new File(home, "bin/" + execName);
        }

        public boolean getExists() throws IOException, InterruptedException {
            return this.getExecutable((Launcher)new Launcher.LocalLauncher(TaskListener.NULL)) != null;
        }

        public AntInstallation forEnvironment(EnvVars environment) {
            return new AntInstallation(this.getName(), environment.expand(this.getHome()), this.getProperties().toList());
        }

        public AntInstallation forNode(Node node, TaskListener log) throws IOException, InterruptedException {
            return new AntInstallation(this.getName(), this.translateFor(node, log), this.getProperties().toList());
        }

        public static class ConverterImpl
        extends ToolInstallation.ToolConverter {
            public ConverterImpl(XStream2 xstream) {
                super(xstream);
            }

            protected String oldHomeField(ToolInstallation obj) {
                return ((AntInstallation)obj).antHome;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class DescriptorImpl
        extends ToolDescriptor<AntInstallation> {
            public String getDisplayName() {
                return "Ant";
            }

            public AntInstallation[] getInstallations() {
                return ((hudson.tasks.Ant$DescriptorImpl)Jenkins.getInstance().getDescriptorByType(hudson.tasks.Ant$DescriptorImpl.class)).getInstallations();
            }

            public void setInstallations(AntInstallation ... installations) {
                ((hudson.tasks.Ant$DescriptorImpl)Jenkins.getInstance().getDescriptorByType(hudson.tasks.Ant$DescriptorImpl.class)).setInstallations(installations);
            }

            public List<? extends ToolInstaller> getDefaultInstallers() {
                return Collections.singletonList(new AntInstaller(null));
            }

            public FormValidation doCheckHome(@QueryParameter File value) {
                if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
                    return FormValidation.ok();
                }
                if (value.getPath().equals("")) {
                    return FormValidation.ok();
                }
                if (!value.isDirectory()) {
                    return FormValidation.error((String)Messages.Ant_NotADirectory(value));
                }
                File antJar = new File(value, "lib/ant.jar");
                if (!antJar.exists()) {
                    return FormValidation.error((String)Messages.Ant_NotAntDirectory(value));
                }
                return FormValidation.ok();
            }

            public FormValidation doCheckName(@QueryParameter String value) {
                return FormValidation.validateRequired((String)value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private volatile AntInstallation[] installations = new AntInstallation[0];

        public DescriptorImpl() {
            this.load();
        }

        protected DescriptorImpl(Class<? extends Ant> clazz) {
            super(clazz);
        }

        public AntInstallation.DescriptorImpl getToolDescriptor() {
            return (AntInstallation.DescriptorImpl)((Object)ToolInstallation.all().get(AntInstallation.DescriptorImpl.class));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.Ant_DisplayName();
        }

        public AntInstallation[] getInstallations() {
            return this.installations;
        }

        public void setInstallations(AntInstallation ... antInstallations) {
            this.installations = antInstallations;
            this.save();
        }
    }
}

