/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.instance_identity.pem;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.main.modules.instance_identity.pem.Asn1Object;
import org.jenkinsci.main.modules.instance_identity.pem.DerParser;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class PEMHelper {
    private static final String BEGIN_RSA_PK = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String END_RSA_PK = "-----END RSA PRIVATE KEY-----";
    private static final String BEGIN_PK = "-----BEGIN PRIVATE KEY-----";
    private static final String END_PK = "-----END PRIVATE KEY-----";
    private static final String PEM_LINE_SEP = "\n";
    private static final int PEM_LINE_LENGTH = 64;
    private static final Logger LOGGER = Logger.getLogger(PEMHelper.class.getName());

    @Nonnull
    public static KeyPair decodePEM(@Nonnull String pem) throws IOException {
        KeySpec privKeySpec;
        byte[] binaryPem;
        if (pem.startsWith(BEGIN_RSA_PK)) {
            binaryPem = PEMHelper.extractBinaryPEM(pem, BEGIN_RSA_PK, END_RSA_PK);
            privKeySpec = PEMHelper.newRSAPrivateCrtKeySpec(binaryPem);
        } else if (pem.startsWith(BEGIN_PK)) {
            binaryPem = PEMHelper.extractBinaryPEM(pem, BEGIN_PK, END_PK);
            privKeySpec = new PKCS8EncodedKeySpec(binaryPem);
        } else {
            throw new IOException("Could not read PEM file incorrect header.");
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PrivateKey privKey = kf.generatePrivate(privKeySpec);
            if (privKey instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rsaPrivateKey = (RSAPrivateCrtKey)privKey;
                RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent());
                return new KeyPair(kf.generatePublic(pubKeySpec), privKey);
            }
            LOGGER.log(Level.SEVERE, "Error reading private key, obtained unexpected result. Received {0} when expecting {1}", new Object[]{privKey.getClass().getName(), RSAPrivateCrtKey.class.getName()});
            throw new IOException("Error reading private key, obtained unexpected result.");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"RSA algorithm support is mandated by Java Language Specification. See https://docs.oracle.com/javase/7/docs/api/java/security/KeyFactory.html");
        }
        catch (InvalidKeySpecException e) {
            throw new IOException("Invalid key specification: " + e.getMessage());
        }
    }

    @Nonnull
    public static String encodePEM(@Nonnull KeyPair keys) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedWriter bw = new BufferedWriter(new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8")));
            bw.write(BEGIN_PK);
            bw.write(PEM_LINE_SEP);
            PEMHelper.writeEncoded(keys.getPrivate().getEncoded(), bw);
            bw.write(END_PK);
            bw.write(PEM_LINE_SEP);
            bw.close();
            return baos.toString(StandardCharsets.UTF_8.name());
        }
        catch (AssertionError e) {
            throw new AssertionError((Object)"UTF-8 character set support is mandated by Java Language Specification. See https://docs.oracle.com/javase/7/docs/api/java/nio/charset/StandardCharsets.html");
        }
    }

    private static byte[] extractBinaryPEM(String pem, String header, String footer) {
        String stripedPEM = StringUtils.stripEnd((String)StringUtils.strip((String)pem, (String)header), (String)header);
        stripedPEM = stripedPEM.replaceAll("(\r|\n|\t| )", "");
        return DatatypeConverter.parseBase64Binary((String)stripedPEM);
    }

    private static RSAPrivateCrtKeySpec newRSAPrivateCrtKeySpec(byte[] keyInPkcs1) throws IOException {
        DerParser parser = new DerParser(keyInPkcs1);
        Asn1Object sequence = parser.read();
        if (sequence.getType() != 16) {
            throw new IllegalArgumentException("Invalid DER: not a sequence");
        }
        DerParser seqParser = sequence.getParser();
        seqParser.read();
        BigInteger modulus = seqParser.read().getInteger();
        BigInteger publicExp = seqParser.read().getInteger();
        BigInteger privateExp = seqParser.read().getInteger();
        BigInteger prime1 = seqParser.read().getInteger();
        BigInteger prime2 = seqParser.read().getInteger();
        BigInteger exp1 = seqParser.read().getInteger();
        BigInteger exp2 = seqParser.read().getInteger();
        BigInteger crtCoef = seqParser.read().getInteger();
        RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
        return keySpec;
    }

    private static void writeEncoded(byte[] bytes, BufferedWriter wr) throws IOException {
        char[] buf = new char[64];
        bytes = DatatypeConverter.printBase64Binary((byte[])bytes).getBytes("UTF-8");
        for (int i = 0; i < bytes.length; i += buf.length) {
            int index;
            for (index = 0; index < buf.length && i + index < bytes.length; ++index) {
                buf[index] = (char)bytes[i + index];
            }
            wr.write(buf, 0, index);
            wr.write(PEM_LINE_SEP);
        }
    }
}

