/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;

final class Checksum {
    public final long sum1;
    public final long sum2;

    Checksum(long sum1, long sum2) {
        this.sum1 = sum1;
        this.sum2 = sum2;
    }

    Checksum(byte[] arrayOf16bytes, int numOfLong) {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(arrayOf16bytes));
            long l1 = 0L;
            long l2 = 0L;
            for (int i = 0; i < numOfLong; ++i) {
                long l = in.readLong();
                if (i % 2 == 0) {
                    l1 ^= l;
                    continue;
                }
                l2 ^= l;
            }
            this.sum1 = l1;
            this.sum2 = l2;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Checksum) {
            Checksum that = (Checksum)o;
            return this.sum1 == that.sum1 && this.sum2 == that.sum2;
        }
        return false;
    }

    public int hashCode() {
        long l = this.sum1 ^ this.sum2;
        return (int)(l ^ l >>> 32);
    }

    public String toString() {
        return String.format("%016X%016X", this.sum1, this.sum2);
    }
}

