/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.Channel;
import hudson.remoting.ErrorPropagatingOutputStream;
import hudson.remoting.Pipe;
import hudson.remoting.ProxyInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteInputStream
extends InputStream
implements Serializable {
    private transient InputStream core;
    private boolean autoUnexport;
    private transient Greedy greedyAt;
    private boolean greedy;
    private static final long serialVersionUID = 1L;

    public RemoteInputStream(InputStream core) {
        this(core, Flag.NOT_GREEDY);
    }

    public RemoteInputStream(InputStream core, boolean autoUnexport) {
        this(core, Flag.NOT_GREEDY, autoUnexport ? Flag.NOT_GREEDY : Flag.MANUAL_UNEXPORT);
    }

    public RemoteInputStream(InputStream core, Flag f) {
        this(core, EnumSet.of(f));
    }

    public RemoteInputStream(InputStream core, Flag f1, Flag f2) {
        this(core, EnumSet.of(f1, f2));
    }

    public RemoteInputStream(InputStream core, Set<Flag> flags) {
        this.core = core;
        this.greedy = flags.contains((Object)Flag.GREEDY);
        if (this.greedy) {
            this.greedyAt = new Greedy();
        }
        this.autoUnexport = !flags.contains((Object)Flag.MANUAL_UNEXPORT);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Channel ch = Channel.current();
        if (ch.remoteCapability.supportsGreedyRemoteInputStream()) {
            oos.writeBoolean(this.greedy);
            if (this.greedy) {
                Pipe pipe = Pipe.createLocalToRemote();
                final InputStream i = this.core;
                final OutputStream o = pipe.getOut();
                new Thread("RemoteInputStream greedy pump thread: " + this.greedyAt.print()){
                    {
                        super(x0);
                        this.setDaemon(true);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            byte[] buf = new byte[8192];
                            while (true) {
                                int len;
                                try {
                                    len = i.read(buf);
                                    if (len < 0) {
                                        break;
                                    }
                                }
                                catch (IOException e) {
                                    if (o instanceof ErrorPropagatingOutputStream) {
                                        try {
                                            ((ErrorPropagatingOutputStream)((Object)o)).error(e);
                                        }
                                        catch (IOException _) {
                                        }
                                    }
                                    Object var6_6 = null;
                                    try {
                                        i.close();
                                    }
                                    catch (IOException _) {
                                        // empty catch block
                                    }
                                    try {
                                        o.close();
                                    }
                                    catch (IOException _) {
                                        // empty catch block
                                    }
                                    return;
                                }
                                try {
                                    o.write(buf, 0, len);
                                }
                                catch (IOException iOException) {}
                            }
                            Object var6_7 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_8 = null;
                            try {
                                i.close();
                            }
                            catch (IOException _) {
                                // empty catch block
                            }
                            try {
                                o.close();
                            }
                            catch (IOException _) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                        try {
                            i.close();
                        }
                        catch (IOException _) {
                            // empty catch block
                        }
                        try {
                            o.close();
                        }
                        catch (IOException _) {}
                    }
                }.start();
                oos.writeObject(pipe);
                return;
            }
        }
        int id = ch.export(this.core, this.autoUnexport);
        oos.writeInt(id);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        boolean greedy;
        Channel channel = Channel.current();
        assert (channel != null);
        if (channel.remoteCapability.supportsGreedyRemoteInputStream() && (greedy = ois.readBoolean())) {
            Pipe p = (Pipe)ois.readObject();
            this.core = p.getIn();
            return;
        }
        this.core = new ProxyInputStream(channel, ois.readInt());
    }

    @Override
    public int read() throws IOException {
        return this.core.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.core.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.core.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.core.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.core.available();
    }

    @Override
    public void close() throws IOException {
        this.core.close();
    }

    @Override
    public void mark(int readlimit) {
        this.core.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.core.reset();
    }

    @Override
    public boolean markSupported() {
        return this.core.markSupported();
    }

    private static final class Greedy
    extends Exception {
        private Greedy() {
        }

        public String print() {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.printStackTrace(pw);
            pw.close();
            return sw.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flag {
        GREEDY,
        NOT_GREEDY,
        MANUAL_UNEXPORT;

    }
}

