/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import hudson.remoting.DiagnosedStreamCorruptionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class FlightRecorderInputStream
extends InputStream {
    private final InputStream source;
    private final ByteArrayOutputStream recorder = new ByteArrayOutputStream();

    FlightRecorderInputStream(InputStream source) {
        this.source = source;
    }

    public void clear() {
        this.recorder.reset();
    }

    public byte[] getRecord() {
        return this.recorder.toByteArray();
    }

    public DiagnosedStreamCorruptionException analyzeCrash(Exception problem, String diagnosisName) {
        final ByteArrayOutputStream readAhead = new ByteArrayOutputStream();
        final IOException[] error = new IOException[1];
        Thread diagnosisThread = new Thread(diagnosisName + " stream corruption diagnosis thread"){

            public void run() {
                try {
                    int b;
                    while (!Thread.interrupted() && (b = FlightRecorderInputStream.this.source.read()) != -1) {
                        readAhead.write(b);
                    }
                }
                catch (IOException e) {
                    error[0] = e;
                }
            }
        };
        diagnosisThread.start();
        try {
            diagnosisThread.join(1000L);
        }
        catch (InterruptedException _) {
            Thread.currentThread().interrupt();
        }
        IOException diagnosisProblem = error[0];
        if (diagnosisThread.isAlive()) {
            diagnosisThread.interrupt();
        }
        return new DiagnosedStreamCorruptionException(problem, diagnosisProblem, this.getRecord(), readAhead.toByteArray());
    }

    public int read() throws IOException {
        int i = this.source.read();
        if (i >= 0) {
            this.recorder.write(i);
        }
        return i;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if ((len = this.source.read(b, off, len)) > 0) {
            this.recorder.write(b, off, len);
        }
        return len;
    }

    public long skip(long n) throws IOException {
        byte[] buf = new byte[(int)Math.min(n, 65536L)];
        return this.read(buf, 0, buf.length);
    }

    public int available() throws IOException {
        return this.source.available();
    }

    public void close() throws IOException {
        this.source.close();
    }

    public boolean markSupported() {
        return false;
    }
}

