/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.maven.AbstractMavenBuild;
import hudson.maven.AbstractMavenProcessFactory;
import hudson.maven.MavenModuleSet;
import hudson.maven.Messages;
import hudson.maven.PlexusModuleContributor;
import hudson.maven.PlexusModuleContributorFactory;
import hudson.maven.ProcessCache;
import hudson.maven.agent.AbortException;
import hudson.maven.agent.Main;
import hudson.maven.agent.Maven21Interceptor;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.tasks.Maven;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MavenProcessFactory
extends AbstractMavenProcessFactory
implements ProcessCache.Factory {
    private static final FilenameFilter CLASSWORLDS_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.contains("classworlds") && name.endsWith(".jar");
        }
    };
    public static boolean debug = false;
    public static boolean profile = Boolean.getBoolean("hudson.maven.profile");
    public static int socketTimeOut = Integer.parseInt(System.getProperty("hudson.maven.socketTimeOut", Integer.toString(30000)));

    MavenProcessFactory(MavenModuleSet mms, AbstractMavenBuild<?, ?> build, Launcher launcher, EnvVars envVars, String mavenOpts, FilePath workDir) {
        super(mms, build, launcher, envVars, mavenOpts, workDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getMavenAgentClassPath(Maven.MavenInstallation mvn, FilePath slaveRoot, BuildListener listener) throws IOException, InterruptedException {
        String classPath = this.classPathEntry(slaveRoot, Main.class, "maven-agent", (TaskListener)listener) + (this.getLauncher().isUnix() ? ":" : ";");
        if (slaveRoot == null) {
            String classWorldsJar = (String)this.getLauncher().getChannel().call((Callable)new GetClassWorldsJar(mvn.getHome(), (TaskListener)listener));
            classPath = classPath + classWorldsJar;
        } else {
            FilePath jar = slaveRoot.child("classworlds.jar");
            if (jar.exists() && jar.digest().equals(Util.getDigestOf((InputStream)MavenProcessFactory.class.getClassLoader().getResourceAsStream("classworlds.jar")))) {
                listener.getLogger().println("classworlds.jar already up to date");
            } else {
                InputStream in = MavenProcessFactory.class.getClassLoader().getResourceAsStream("classworlds.jar");
                try {
                    jar.copyFrom(in);
                }
                finally {
                    in.close();
                }
                listener.getLogger().println("Copied classworlds.jar");
            }
            classPath = classPath + jar.getRemote();
        }
        return classPath;
    }

    @Override
    protected String getMainClassName() {
        return Main.class.getName();
    }

    @Override
    protected String getMavenInterceptorClassPath(Maven.MavenInstallation mvn, FilePath slaveRoot, BuildListener listener) throws IOException, InterruptedException {
        return this.classPathEntry(slaveRoot, AbortException.class, "maven-interceptor", (TaskListener)listener);
    }

    @Override
    protected String getMavenInterceptorOverride(Maven.MavenInstallation mvn, FilePath slaveRoot, BuildListener listener) throws IOException, InterruptedException {
        if (mvn.isMaven2_1(this.getLauncher())) {
            return this.classPathEntry(slaveRoot, Maven21Interceptor.class, "maven2.1-interceptor", (TaskListener)listener);
        }
        return null;
    }

    @Override
    protected void applyPlexusModuleContributor(Channel channel, AbstractMavenBuild<?, ?> context) throws InterruptedException, IOException {
        channel.call((Callable)new InstallPlexusModulesTask(context));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetClassWorldsJar
    implements Callable<String, IOException> {
        private static final long serialVersionUID = 5812919424079344101L;
        private final String mvnHome;
        private final TaskListener listener;

        private GetClassWorldsJar(String mvnHome, TaskListener listener) {
            this.mvnHome = mvnHome;
            this.listener = listener;
        }

        public String call() throws IOException {
            File home = new File(this.mvnHome);
            File bootDir = new File(home, "core/boot");
            File[] classworlds = bootDir.listFiles(CLASSWORLDS_FILTER);
            if (!(classworlds != null && classworlds.length != 0 || (classworlds = (bootDir = new File(home, "boot")).listFiles(CLASSWORLDS_FILTER)) != null && classworlds.length != 0)) {
                this.listener.error(Messages.MavenProcessFactory_ClassWorldsNotFound(home));
                throw new Run.RunnerAbortedException();
            }
            return classworlds[0].getAbsolutePath();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InstallPlexusModulesTask
    implements Callable<Void, IOException> {
        PlexusModuleContributor c;

        public InstallPlexusModulesTask(AbstractMavenBuild<?, ?> context) throws IOException, InterruptedException {
            this.c = PlexusModuleContributorFactory.aggregate(context);
        }

        public Void call() throws IOException {
            Main.addPlexusComponents((URL[])this.c.getPlexusComponentJars().toArray(new URL[0]));
            return null;
        }
    }
}

