/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import hudson.Util;
import hudson.maven.MojoInfo;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum TestMojo {
    FALLBACK("", "", "", "reportsDirectory"){

        protected boolean is(String artifactId, String groupId, String goal) {
            return false;
        }
    }
    ,
    MAVEN_SUREFIRE("org.apache.maven.plugins", "maven-surefire-plugin", "test", "reportsDirectory"),
    MAVEN_FAILSAFE("org.apache.maven.plugins", "maven-failsafe-plugin", "integration-test", "reportsDirectory"),
    MAVEN_FAILSAFE_B("org.apache.maven.plugins", "maven-failsafe-plugin", "verify", "reportsDirectory"),
    MAVEN_JUNIT("com.sun.maven", "maven-junit-plugin", "test", "reportsDirectory"),
    FLEXMOJOS("org.sonatype.flexmojos", "flexmojos-maven-plugin", "test-run", null),
    MAVEN_OSGI_TEST("org.sonatype.tycho", "maven-osgi-test-plugin", "test", "reportsDirectory"),
    TYCHO_SUREFIRE("org.eclipse.tycho", "tycho-surefire-plugin", "test", "reportsDirectory"),
    MAVEN_ANDROID_PLUGIN("com.jayway.maven.plugins.android.generation2", "maven-android-plugin", "internal-integration-test", null, "3.0.0-alpha-6"),
    ANDROID_MAVEN_PLUGIN("com.jayway.maven.plugins.android.generation2", "android-maven-plugin", "internal-integration-test", null, "3.0.0-alpha-6"),
    GWT_MAVEN_PLUGIN("org.codehaus.mojo", "gwt-maven-plugin", "test", "reportsDirectory", "1.2"),
    MAVEN_SOAPUI_PLUGIN("eviware", "maven-soapui-plugin", "test", "outputFolder"),
    MAVEN_SOAPUI_PRO_PLUGIN("eviware", "maven-soapui-pro-plugin", "test", "outputFolder"),
    JASMINE("com.github.searls", "jasmine-maven-plugin", "test", null){

        public Collection<File> getReportFiles(MavenProject pom, MojoInfo mojo) throws ComponentConfigurationException {
            File reportsDir = mojo.getConfigurationValue("jasmineTargetDir", File.class);
            String junitFileName = mojo.getConfigurationValue("junitXmlReportFileName", String.class);
            if (reportsDir != null && junitFileName != null) {
                return Collections.singleton(new File(reportsDir, junitFileName));
            }
            return null;
        }
    }
    ,
    TOOLKIT_RESOLVER_PLUGIN("org.terracotta.maven.plugins", "toolkit-resolver-plugin", "toolkit-resolve-test", "reportsDirectory"),
    SCALATEST_MAVEN_PLUGIN("org.scalatest", "scalatest-maven-plugin", "test", null){

        @Override
        public Iterable<File> getReportFiles(MavenProject pom, MojoInfo mojo) throws ComponentConfigurationException {
            String[] junitDirsList;
            File reportsDir = mojo.getConfigurationValue("reportsDirectory", File.class);
            String junitDirs = mojo.getConfigurationValue("junitxml", String.class);
            if (junitDirs == null || junitDirs.trim().length() == 0) {
                return null;
            }
            for (String dir : junitDirsList = junitDirs.trim().split("(?<!\\\\),")) {
                String junitDirName;
                File junitDir;
                if (dir.trim().length() <= 0 || !(junitDir = new File(reportsDir, junitDirName = dir.trim().replaceAll("\\\\,", ","))).exists()) continue;
                return ((TestMojo)this).getReportFiles(junitDir, ((TestMojo)this).getFileSet(junitDir));
            }
            return null;
        }
    };

    private String reportDirectoryConfigKey;
    private Key key;
    private String minimalRequiredVersion;

    private TestMojo(String artifactId, String groupId, String goal, String reportDirectoryConfigKey) {
        this.key = new Key(artifactId, groupId, goal);
        this.reportDirectoryConfigKey = reportDirectoryConfigKey;
    }

    private TestMojo(String artifactId, String groupId, String goal, String reportDirectoryConfigKey, String minimalRequiredVersion) {
        this.key = new Key(artifactId, groupId, goal);
        this.reportDirectoryConfigKey = reportDirectoryConfigKey;
        this.minimalRequiredVersion = minimalRequiredVersion;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean canRunTests(MojoInfo mojo) {
        if (this.minimalRequiredVersion == null) {
            return true;
        }
        return mojo.pluginName.version.compareTo(this.minimalRequiredVersion) >= 0;
    }

    @CheckForNull
    public Iterable<File> getReportFiles(MavenProject pom, MojoInfo mojo) throws ComponentConfigurationException {
        File reportsDir;
        if (this.reportDirectoryConfigKey != null && (reportsDir = mojo.getConfigurationValue(this.reportDirectoryConfigKey, File.class)) != null && reportsDir.exists()) {
            return this.getReportFiles(reportsDir, this.getFileSet(reportsDir));
        }
        reportsDir = new File(pom.getBuild().getDirectory(), "surefire-reports");
        if (reportsDir.exists()) {
            return this.getReportFiles(reportsDir, this.getFileSet(reportsDir));
        }
        return null;
    }

    private Iterable<File> getReportFiles(final File baseDir, FileSet set) {
        final String[] includedFiles = set.getDirectoryScanner().getIncludedFiles();
        return new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return Iterators.transform((Iterator)Iterators.forArray((Object[])includedFiles), (Function)new Function<String, File>(){

                    public File apply(String file) {
                        return new File(baseDir, file);
                    }
                });
            }
        };
    }

    private FileSet getFileSet(File baseDir) {
        return Util.createFileSet((File)baseDir, (String)"*.xml", (String)"testng-results.xml,testng-failed.xml");
    }

    protected boolean is(String artifactId, String groupId, String goal) {
        return this.key.artifactId.equals(artifactId) && this.key.groupId.equals(groupId) && this.key.goal.equals(goal);
    }

    public static TestMojo lookup(String artifactId, String groupId, String goal) {
        for (TestMojo mojo : TestMojo.values()) {
            if (!mojo.is(artifactId, groupId, goal)) continue;
            return mojo;
        }
        if (goal.equals("test") || goal.equals("test-run") || goal.equals("integration-test")) {
            return FALLBACK;
        }
        return null;
    }

    public static TestMojo lookup(MojoInfo mojo) {
        TestMojo testMojo = TestMojo.lookup(mojo.pluginName.groupId, mojo.pluginName.artifactId, mojo.getGoal());
        if (testMojo != null && testMojo.canRunTests(mojo)) {
            return testMojo;
        }
        return null;
    }

    static class Key {
        private String artifactId;
        private String groupId;
        private String goal;

        public Key(String artifactId, String groupId, String goal) {
            this.artifactId = artifactId;
            this.groupId = groupId;
            this.goal = goal;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.goal == null ? 0 : this.goal.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                return false;
            }
            if (this.goal == null ? other.goal != null : !this.goal.equals(other.goal)) {
                return false;
            }
            return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
        }
    }
}

