/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven.reporters;

import com.google.common.collect.Maps;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import hudson.Util;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.reporters.MavenArtifactRecord;
import hudson.model.AbstractBuild;
import hudson.model.Api;
import hudson.model.BuildListener;
import hudson.model.FingerprintMap;
import hudson.model.Run;
import hudson.util.LRUStringConverter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public final class MavenArtifact
implements Serializable {
    @Exported
    public final String groupId;
    @Exported
    public final String artifactId;
    @Exported
    public final String version;
    @Exported
    public final String classifier;
    @Exported
    public final String type;
    @Exported
    public final String fileName;
    @Exported
    public final String canonicalName;
    @Exported
    public final String md5sum;
    private static final Logger LOGGER;
    private static final long serialVersionUID = 1L;

    public MavenArtifact(Artifact a) throws IOException {
        this.groupId = a.getGroupId();
        this.artifactId = a.getArtifactId();
        this.version = a.getVersion();
        this.classifier = a.getClassifier();
        this.type = a.getType();
        this.fileName = a.getFile().getName();
        this.md5sum = Util.getDigestOf((File)a.getFile());
        String extension = a.getArtifactHandler() != null ? a.getArtifactHandler().getExtension() : a.getType();
        this.canonicalName = this.getSeed(extension);
    }

    public MavenArtifact(String groupId, String artifactId, String version, String classifier, String type, String fileName, String md5sum) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.type = type;
        this.fileName = fileName;
        this.canonicalName = this.getSeed(type);
        this.md5sum = md5sum;
    }

    public static MavenArtifact create(Artifact a) throws IOException {
        File file = a.getFile();
        if (file == null) {
            return null;
        }
        if (!file.isFile()) {
            return null;
        }
        return new MavenArtifact(a);
    }

    public boolean isPOM() {
        return this.fileName.endsWith(".pom") || "pom.xml".equals(this.fileName);
    }

    public Artifact toArtifact(ArtifactHandlerManager handlerManager, ArtifactFactory factory, MavenBuild build) throws IOException {
        final String canonicalExtension = this.canonicalName.substring(this.canonicalName.lastIndexOf(46) + 1);
        ArtifactHandler ah = handlerManager.getArtifactHandler(this.type);
        HashMap handlers = Maps.newHashMap();
        handlers.put(this.type, new DefaultArtifactHandler(this.type){

            public String getExtension() {
                return canonicalExtension;
            }
        });
        if (!this.canonicalName.endsWith(ah.getExtension())) {
            handlerManager.addHandlers((Map)handlers);
        }
        Artifact a = factory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.type, this.classifier);
        a.setFile(this.getFile(build));
        return a;
    }

    private String getSeed(String extension) {
        String name = this.artifactId + '-' + this.version;
        if (Util.fixEmpty((String)this.classifier) != null) {
            name = name + '-' + this.classifier;
        }
        name = name + '.' + extension;
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile(MavenBuild build) throws IOException {
        File f = File.createTempFile("jenkins-", this.canonicalName);
        f.deleteOnExit();
        FileOutputStream os = new FileOutputStream(f);
        try {
            Util.copyStreamAndClose((InputStream)build.getArtifactManager().root().child(this.artifactPath()).open(), (OutputStream)os);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)os).close();
            throw throwable;
        }
        ((OutputStream)os).close();
        return f;
    }

    public HttpResponse doFile(final @AncestorInPath MavenArtifactRecord parent) throws IOException {
        return new HttpResponse(){

            public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                rsp.setContentType("application/octet-stream");
                Util.copyStreamAndClose((InputStream)parent.parent.getArtifactManager().root().child(MavenArtifact.this.artifactPath()).open(), (OutputStream)rsp.getCompressedOutputStream((HttpServletRequest)req));
            }
        };
    }

    private String artifactPath() {
        return this.groupId + '/' + this.artifactId + '/' + this.version + '/' + this.canonicalName;
    }

    public void archive(MavenBuildProxy build, File file, BuildListener listener) throws IOException, InterruptedException {
        if (build.isArchivingDisabled()) {
            LOGGER.fine("Archiving disabled - not archiving " + file);
        } else {
            build.queueArchiving(this.artifactPath(), file.getAbsolutePath());
        }
    }

    public void recordFingerprint(MavenBuild build) throws IOException {
        FingerprintMap map = Jenkins.getInstance().getFingerprintMap();
        map.getOrCreate((AbstractBuild)build, this.fileName, this.md5sum);
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    static {
        Run.XSTREAM.registerLocalConverter(MavenArtifact.class, "md5sum", (SingleValueConverter)new LRUStringConverter(5000));
        LOGGER = Logger.getLogger(MavenArtifact.class.getName());
    }
}

