/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.console.ConsoleNote;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.Result;
import hudson.model.StreamBuildListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.util.AbstractTaskListener;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.List;
import jenkins.util.MarkFindingOutputStream;
import org.apache.commons.io.output.DeferredFileOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SplittableBuildListener
extends AbstractTaskListener
implements BuildListener,
Serializable {
    private final BuildListener core;
    private DeferredFileOutputStream unclaimed = this.newLog();
    private volatile OutputStream side = this.unclaimed;
    private final PrintStream logger;
    private int markCount = 0;
    private final Object markCountLock = new Object();
    private static final long serialVersionUID = 1L;
    private static final byte[] MARK = SplittableBuildListener.toUTF8("[Jenkins:SYNC-MARK]\n");

    public SplittableBuildListener(BuildListener core) {
        this.core = core;
        final PrintStream base = core.getLogger();
        OutputStream tee = new OutputStream(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(int b) throws IOException {
                base.write(b);
                Object object = SplittableBuildListener.this.lock();
                synchronized (object) {
                    SplittableBuildListener.this.side.write(b);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(byte[] b, int off, int len) throws IOException {
                base.write(b, off, len);
                Object object = SplittableBuildListener.this.lock();
                synchronized (object) {
                    SplittableBuildListener.this.side.write(b, off, len);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void flush() throws IOException {
                base.flush();
                Object object = SplittableBuildListener.this.lock();
                synchronized (object) {
                    SplittableBuildListener.this.side.flush();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void close() throws IOException {
                base.close();
                Object object = SplittableBuildListener.this.lock();
                synchronized (object) {
                    SplittableBuildListener.this.side.close();
                }
            }
        };
        this.logger = new PrintStream((OutputStream)new MarkFindingOutputStream(tee){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onMarkFound() {
                Object object = SplittableBuildListener.this.markCountLock;
                synchronized (object) {
                    SplittableBuildListener.this.markCount++;
                    SplittableBuildListener.this.markCountLock.notifyAll();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronizeOnMark(Channel ch) throws IOException, InterruptedException {
        Object object = this.markCountLock;
        synchronized (object) {
            int start = this.markCount;
            ch.call((Callable)new SendMark());
            while (this.markCount == start) {
                this.markCountLock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSideOutputStream(OutputStream os) throws IOException {
        Object object = this.lock();
        synchronized (object) {
            if (os == null) {
                os = this.unclaimed;
            } else {
                this.unclaimed.close();
                this.unclaimed.writeTo(os);
                File f = this.unclaimed.getFile();
                if (f != null) {
                    f.delete();
                }
                this.unclaimed = this.newLog();
            }
            this.side = os;
        }
    }

    private DeferredFileOutputStream newLog() {
        return new DeferredFileOutputStream(10240, "maven-build", "log", null);
    }

    private Object lock() {
        return this;
    }

    public void started(List<Cause> causes) {
        this.core.started(causes);
    }

    public void finished(Result result) {
        this.core.finished(result);
    }

    public PrintStream getLogger() {
        return this.logger;
    }

    public PrintWriter error(String msg) {
        this.core.error(msg);
        return new PrintWriter(this.logger, true);
    }

    public PrintWriter error(String format, Object ... args) {
        this.core.error(format, args);
        return new PrintWriter(this.logger, true);
    }

    public PrintWriter fatalError(String msg) {
        this.core.fatalError(msg);
        return new PrintWriter(this.logger, true);
    }

    public PrintWriter fatalError(String format, Object ... args) {
        this.core.fatalError(format, args);
        return new PrintWriter(this.logger, true);
    }

    public void annotate(ConsoleNote ann) throws IOException {
        this.core.annotate(ann);
    }

    private Object writeReplace() throws IOException {
        return new StreamBuildListener(this.logger);
    }

    private static byte[] toUTF8(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SendMark
    implements Callable<Void, IOException> {
        private SendMark() {
        }

        public Void call() throws IOException {
            System.out.write(MARK);
            System.out.flush();
            return null;
        }
    }
}

