/*
 * Decompiled with CFR 0.152.
 */
package hudson.maven;

import hudson.Functions;
import hudson.maven.ModuleName;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleDependency
implements Serializable {
    public final String groupId;
    public final String artifactId;
    public final String version;
    public final boolean plugin;
    private VersionRange range;
    private ArtifactVersion parsedVersion;
    public static final String UNKNOWN = "*";
    public static final String NONE = "-";
    private static final long serialVersionUID = 1L;

    public ModuleDependency(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, false);
    }

    public ModuleDependency(String groupId, String artifactId, String version, boolean plugin) {
        this.groupId = groupId.intern();
        this.artifactId = artifactId.intern();
        this.version = version == null ? UNKNOWN : version.intern();
        this.plugin = plugin;
    }

    public ModuleDependency(ModuleName name, String version) {
        this(name.groupId, name.artifactId, version, false);
    }

    public ModuleDependency(ModuleName name, String version, boolean plugin) {
        this(name.groupId, name.artifactId, version, plugin);
    }

    public ModuleDependency(Dependency dep) {
        this(dep.getGroupId(), dep.getArtifactId(), dep.getVersion());
    }

    public ModuleDependency(MavenProject project) {
        this(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public ModuleDependency(Plugin p) {
        this(p.getGroupId(), p.getArtifactId(), (String)Functions.defaulted((Object)p.getVersion(), (Object)NONE), true);
    }

    public ModuleDependency(ReportPlugin p) {
        this(p.getGroupId(), p.getArtifactId(), p.getVersion(), true);
    }

    public ModuleDependency(Extension ext) {
        this(ext.getGroupId(), ext.getArtifactId(), ext.getVersion());
    }

    private ModuleDependency(String groupId, String artifactId, boolean plugin) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = UNKNOWN;
        this.plugin = plugin;
    }

    public ModuleName getName() {
        return new ModuleName(this.groupId, this.artifactId);
    }

    public ModuleDependency withUnknownVersion() {
        if (UNKNOWN.equals(this.version)) {
            return this;
        }
        return new ModuleDependency(this.groupId, this.artifactId, this.plugin);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleDependency that = (ModuleDependency)o;
        return this.artifactId.equals(that.artifactId) && this.groupId.equals(that.groupId) && this.version.equals(that.version) && this.plugin == that.plugin;
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (this.plugin ? 1 : 2);
        return result;
    }

    public boolean isVersionRange() {
        return this.version.startsWith("[") || this.version.startsWith("(");
    }

    public VersionRange getVersionAsRange() throws InvalidVersionSpecificationException {
        if (this.range == null) {
            this.range = VersionRange.createFromVersionSpec((String)this.version);
        }
        return this.range;
    }

    public ArtifactVersion parseVersion() {
        if (this.parsedVersion == null) {
            this.parsedVersion = new DefaultArtifactVersion(this.version);
        }
        return this.parsedVersion;
    }

    protected Object readResolve() {
        return new ModuleDependency(this.groupId, this.artifactId, this.version, this.plugin);
    }

    public boolean contains(ModuleDependency other) {
        if (other == null || !this.getName().equals(other.getName())) {
            return false;
        }
        try {
            return this.isVersionRange() ? this.getVersionAsRange().containsVersion(other.parseVersion()) : this.parseVersion().compareTo((Object)other.parseVersion()) == 0;
        }
        catch (InvalidVersionSpecificationException ivse) {
            return false;
        }
    }

    public ModuleDependency findHighestFrom(Collection<ModuleDependency> candidates) {
        TreeMap<ArtifactVersion, ModuleDependency> sorted = new TreeMap<ArtifactVersion, ModuleDependency>((Comparator<ArtifactVersion>)new ReverseComparator());
        for (ModuleDependency candidate : candidates) {
            sorted.put(candidate.parseVersion(), candidate);
        }
        for (ModuleDependency e : sorted.values()) {
            if (!this.contains(e)) continue;
            return e;
        }
        return null;
    }

    public String toString() {
        return "ModuleDependency{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", plugin=" + this.plugin + '}';
    }
}

