/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.NullSCM;
import hudson.scm.SCMRevisionState;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.apache.commons.io.IOUtils;

public class SingleFileSCM
extends NullSCM {
    private final String path;
    private final byte[] contents;

    public SingleFileSCM(String path, byte[] contents) {
        this.path = path;
        this.contents = contents;
    }

    public SingleFileSCM(String path, String contents) throws UnsupportedEncodingException {
        this.path = path;
        this.contents = contents.getBytes("UTF-8");
    }

    public SingleFileSCM(String path, URL resource) throws IOException {
        this.path = path;
        this.contents = IOUtils.toByteArray((InputStream)resource.openStream());
    }

    public void checkout(Run<?, ?> build, Launcher launcher, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState baseline) throws IOException, InterruptedException {
        listener.getLogger().println("Staging " + this.path);
        OutputStream os = workspace.child(this.path).write();
        IOUtils.write((byte[])this.contents, (OutputStream)os);
        os.close();
    }

    private Object writeReplace() {
        return new Object();
    }
}

